/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;

@InterfaceAudience.Private
class BPServiceActor
implements Runnable {
    static final Log LOG = DataNode.LOG;
    final InetSocketAddress nnAddr;
    HAServiceProtocol.HAServiceState state;
    BPOfferService bpos;
    volatile long lastBlockReport = 0L;
    volatile long lastDeletedReport = 0L;
    boolean resetBlockReportTime = true;
    volatile long lastCacheReport = 0L;
    Thread bpThread;
    DatanodeProtocolClientSideTranslatorPB bpNamenode;
    private volatile long lastHeartbeat = 0L;
    private volatile boolean initialized = false;
    private final Map<String, PerStoragePendingIncrementalBR> pendingIncrementalBRperStorage = Maps.newHashMap();
    private volatile int pendingReceivedRequests = 0;
    private volatile boolean shouldServiceRun = true;
    private final DataNode dn;
    private final DNConf dnConf;
    private DatanodeRegistration bpRegistration;

    BPServiceActor(InetSocketAddress nnAddr, BPOfferService bpos) {
        this.bpos = bpos;
        this.dn = bpos.getDataNode();
        this.nnAddr = nnAddr;
        this.dnConf = this.dn.getDnConf();
    }

    boolean isInitialized() {
        return this.initialized;
    }

    boolean isAlive() {
        return this.shouldServiceRun && this.bpThread.isAlive();
    }

    public String toString() {
        return this.bpos.toString() + " service to " + this.nnAddr;
    }

    InetSocketAddress getNNSocketAddress() {
        return this.nnAddr;
    }

    @VisibleForTesting
    void setNameNode(DatanodeProtocolClientSideTranslatorPB dnProtocol) {
        this.bpNamenode = dnProtocol;
    }

    @VisibleForTesting
    DatanodeProtocolClientSideTranslatorPB getNameNodeProxy() {
        return this.bpNamenode;
    }

    @VisibleForTesting
    NamespaceInfo retrieveNamespaceInfo() throws IOException {
        NamespaceInfo nsInfo = null;
        while (this.shouldRun()) {
            try {
                nsInfo = this.bpNamenode.versionRequest();
                LOG.debug((Object)(this + " received versionRequest response: " + nsInfo));
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.warn((Object)("Problem connecting to server: " + this.nnAddr));
            }
            catch (IOException e) {
                LOG.warn((Object)("Problem connecting to server: " + this.nnAddr));
            }
            this.sleepAndLogInterrupts(5000, "requesting version info from NN");
        }
        if (nsInfo == null) {
            throw new IOException("DN shut down before block pool connected");
        }
        this.checkNNVersion(nsInfo);
        return nsInfo;
    }

    private void checkNNVersion(NamespaceInfo nsInfo) throws IncorrectVersionException {
        String minimumNameNodeVersion;
        String nnVersion = nsInfo.getSoftwareVersion();
        if (VersionUtil.compareVersions((String)nnVersion, (String)(minimumNameNodeVersion = this.dnConf.getMinimumNameNodeVersion())) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(minimumNameNodeVersion, nnVersion, "NameNode", "DataNode");
            LOG.warn((Object)ive.getMessage());
            throw ive;
        }
        String dnVersion = VersionInfo.getVersion();
        if (!nnVersion.equals(dnVersion)) {
            LOG.info((Object)("Reported NameNode version '" + nnVersion + "' does not match " + "DataNode version '" + dnVersion + "' but is within acceptable " + "limits. Note: This is normal during a rolling upgrade."));
        }
        if (HdfsConstants.LAYOUT_VERSION != nsInfo.getLayoutVersion()) {
            LOG.warn((Object)("DataNode and NameNode layout versions must be the same. Expected: " + HdfsConstants.LAYOUT_VERSION + " actual " + nsInfo.getLayoutVersion()));
            throw new IncorrectVersionException(nsInfo.getLayoutVersion(), "namenode");
        }
    }

    private void connectToNNAndHandshake() throws IOException {
        this.bpNamenode = this.dn.connectToNN(this.nnAddr);
        NamespaceInfo nsInfo = this.retrieveNamespaceInfo();
        this.bpos.verifyAndSetNamespaceInfo(nsInfo);
        this.register();
    }

    void scheduleBlockReport(long delay) {
        this.lastBlockReport = delay > 0L ? Time.now() - (this.dnConf.blockReportInterval - (long)DFSUtil.getRandom().nextInt((int)delay)) : this.lastHeartbeat - this.dnConf.blockReportInterval;
        this.resetBlockReportTime = true;
    }

    void reportBadBlocks(ExtendedBlock block, String storageUuid, StorageType storageType) {
        if (this.bpRegistration == null) {
            return;
        }
        DatanodeInfo[] dnArr = new DatanodeInfo[]{new DatanodeInfo(this.bpRegistration)};
        String[] uuids = new String[]{storageUuid};
        StorageType[] types = new StorageType[]{storageType};
        LocatedBlock[] blocks = new LocatedBlock[]{new LocatedBlock(block, dnArr, uuids, types)};
        try {
            this.bpNamenode.reportBadBlocks(blocks);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to report bad block " + block + " to namenode : " + " Exception"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportReceivedDeletedBlocks() throws IOException {
        PerStoragePendingIncrementalBR perStorageMap;
        ArrayList<StorageReceivedDeletedBlocks> reports = new ArrayList<StorageReceivedDeletedBlocks>(this.pendingIncrementalBRperStorage.size());
        Map<String, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            for (Map.Entry<String, PerStoragePendingIncrementalBR> entry : this.pendingIncrementalBRperStorage.entrySet()) {
                String storageUuid = entry.getKey();
                perStorageMap = entry.getValue();
                if (perStorageMap.getBlockInfoCount() <= 0) continue;
                ReceivedDeletedBlockInfo[] rdbi = perStorageMap.dequeueBlockInfos();
                this.pendingReceivedRequests = this.pendingReceivedRequests > rdbi.length ? this.pendingReceivedRequests - rdbi.length : 0;
                reports.add(new StorageReceivedDeletedBlocks(storageUuid, rdbi));
            }
        }
        if (reports.size() == 0) {
            return;
        }
        boolean success = false;
        try {
            this.bpNamenode.blockReceivedAndDeleted(this.bpRegistration, this.bpos.getBlockPoolId(), reports.toArray(new StorageReceivedDeletedBlocks[reports.size()]));
            success = true;
        }
        finally {
            if (!success) {
                Map<String, PerStoragePendingIncrementalBR> map2 = this.pendingIncrementalBRperStorage;
                synchronized (map2) {
                    for (StorageReceivedDeletedBlocks report : reports) {
                        perStorageMap = this.pendingIncrementalBRperStorage.get(report.getStorageID());
                        this.pendingReceivedRequests += perStorageMap.putMissingBlockInfos(report.getBlocks());
                    }
                }
            }
        }
    }

    private PerStoragePendingIncrementalBR getIncrementalBRMapForStorage(String storageUuid) {
        PerStoragePendingIncrementalBR mapForStorage = this.pendingIncrementalBRperStorage.get(storageUuid);
        if (mapForStorage == null) {
            mapForStorage = new PerStoragePendingIncrementalBR();
            this.pendingIncrementalBRperStorage.put(storageUuid, mapForStorage);
        }
        return mapForStorage;
    }

    void addPendingReplicationBlockInfo(ReceivedDeletedBlockInfo bInfo, String storageUuid) {
        for (Map.Entry<String, PerStoragePendingIncrementalBR> entry : this.pendingIncrementalBRperStorage.entrySet()) {
            if (entry.getValue().removeBlockInfo(bInfo)) break;
        }
        this.getIncrementalBRMapForStorage(storageUuid).putBlockInfo(bInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNamenodeBlockImmediately(ReceivedDeletedBlockInfo bInfo, String storageUuid) {
        Map<String, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.addPendingReplicationBlockInfo(bInfo, storageUuid);
            ++this.pendingReceivedRequests;
            this.pendingIncrementalBRperStorage.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNamenodeDeletedBlock(ReceivedDeletedBlockInfo bInfo, String storageUuid) {
        Map<String, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.addPendingReplicationBlockInfo(bInfo, storageUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerBlockReportForTests() {
        Map<String, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.lastBlockReport = 0L;
            this.lastHeartbeat = 0L;
            this.pendingIncrementalBRperStorage.notifyAll();
            while (this.lastBlockReport == 0L) {
                try {
                    this.pendingIncrementalBRperStorage.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerHeartbeatForTests() {
        Map<String, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.lastHeartbeat = 0L;
            this.pendingIncrementalBRperStorage.notifyAll();
            while (this.lastHeartbeat == 0L) {
                try {
                    this.pendingIncrementalBRperStorage.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void triggerDeletionReportForTests() {
        Map<String, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
        synchronized (map) {
            this.lastDeletedReport = 0L;
            this.pendingIncrementalBRperStorage.notifyAll();
            while (this.lastDeletedReport == 0L) {
                try {
                    this.pendingIncrementalBRperStorage.wait(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    DatanodeCommand blockReport() throws IOException {
        DatanodeCommand cmd = null;
        long startTime = Time.now();
        if (startTime - this.lastBlockReport > this.dnConf.blockReportInterval) {
            this.reportReceivedDeletedBlocks();
            long brCreateStartTime = Time.now();
            long totalBlockCount = 0L;
            Map<DatanodeStorage, BlockListAsLongs> perVolumeBlockLists = this.dn.getFSDataset().getBlockReports(this.bpos.getBlockPoolId());
            long brSendStartTime = Time.now();
            StorageBlockReport[] reports = new StorageBlockReport[perVolumeBlockLists.size()];
            int i = 0;
            for (Map.Entry<DatanodeStorage, BlockListAsLongs> kvPair : perVolumeBlockLists.entrySet()) {
                DatanodeStorage dnStorage = kvPair.getKey();
                BlockListAsLongs blockList = kvPair.getValue();
                totalBlockCount += (long)blockList.getNumberOfBlocks();
                reports[i++] = new StorageBlockReport(dnStorage, blockList.getBlockListAsLongs());
            }
            cmd = this.bpNamenode.blockReport(this.bpRegistration, this.bpos.getBlockPoolId(), reports);
            long brSendCost = Time.now() - brSendStartTime;
            long brCreateCost = brSendStartTime - brCreateStartTime;
            this.dn.getMetrics().addBlockReport(brSendCost);
            LOG.info((Object)("BlockReport of " + totalBlockCount + " blocks took " + brCreateCost + " msec to generate and " + brSendCost + " msecs for RPC and NN processing"));
            if (this.resetBlockReportTime) {
                this.lastBlockReport = startTime - (long)DFSUtil.getRandom().nextInt((int)this.dnConf.blockReportInterval);
                this.resetBlockReportTime = false;
            } else {
                this.lastBlockReport += (Time.now() - this.lastBlockReport) / this.dnConf.blockReportInterval * this.dnConf.blockReportInterval;
            }
            LOG.info((Object)("sent block report, processed command:" + cmd));
        }
        return cmd;
    }

    DatanodeCommand cacheReport() throws IOException {
        if (this.dn.getFSDataset().getCacheCapacity() == 0L) {
            return null;
        }
        DatanodeCommand cmd = null;
        long startTime = Time.monotonicNow();
        if (startTime - this.lastCacheReport > this.dnConf.cacheReportInterval) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending cacheReport from service actor: " + this));
            }
            this.lastCacheReport = startTime;
            String bpid = this.bpos.getBlockPoolId();
            List<Long> blockIds = this.dn.getFSDataset().getCacheReport(bpid);
            long createTime = Time.monotonicNow();
            cmd = this.bpNamenode.cacheReport(this.bpRegistration, bpid, blockIds);
            long sendTime = Time.monotonicNow();
            long createCost = createTime - startTime;
            long sendCost = sendTime - createTime;
            this.dn.getMetrics().addCacheReport(sendCost);
            LOG.debug((Object)("CacheReport of " + blockIds.size() + " block(s) took " + createCost + " msec to generate and " + sendCost + " msecs for RPC and NN processing"));
        }
        return cmd;
    }

    HeartbeatResponse sendHeartBeat() throws IOException {
        StorageReport[] reports = this.dn.getFSDataset().getStorageReports(this.bpos.getBlockPoolId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending heartbeat with " + reports.length + " storage reports from service actor: " + this));
        }
        return this.bpNamenode.sendHeartbeat(this.bpRegistration, reports, this.dn.getFSDataset().getCacheCapacity(), this.dn.getFSDataset().getCacheUsed(), this.dn.getXmitsInProgress(), this.dn.getXceiverCount(), this.dn.getFSDataset().getNumFailedVolumes());
    }

    void start() {
        if (this.bpThread != null && this.bpThread.isAlive()) {
            return;
        }
        this.bpThread = new Thread((Runnable)this, this.formatThreadName());
        this.bpThread.setDaemon(true);
        this.bpThread.start();
    }

    private String formatThreadName() {
        List<StorageLocation> dataDirs = DataNode.getStorageLocations(this.dn.getConf());
        return "DataNode: [" + dataDirs.toString() + "] " + " heartbeating to " + this.nnAddr;
    }

    void stop() {
        this.shouldServiceRun = false;
        if (this.bpThread != null) {
            this.bpThread.interrupt();
        }
    }

    void join() {
        try {
            if (this.bpThread != null) {
                this.bpThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void cleanUp() {
        this.shouldServiceRun = false;
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.bpNamenode});
        this.bpos.shutdownActor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerService() throws Exception {
        LOG.info((Object)("For namenode " + this.nnAddr + " using" + " DELETEREPORT_INTERVAL of " + this.dnConf.deleteReportInterval + " msec " + " BLOCKREPORT_INTERVAL of " + this.dnConf.blockReportInterval + "msec" + " CACHEREPORT_INTERVAL of " + this.dnConf.cacheReportInterval + "msec" + " Initial delay: " + this.dnConf.initialBlockReportDelay + "msec" + "; heartBeatInterval=" + this.dnConf.heartBeatInterval));
        while (this.shouldRun()) {
            try {
                long startTime = Time.now();
                if (startTime - this.lastHeartbeat >= this.dnConf.heartBeatInterval) {
                    this.lastHeartbeat = startTime;
                    if (!this.dn.areHeartbeatsDisabledForTests()) {
                        HeartbeatResponse resp = this.sendHeartBeat();
                        assert (resp != null);
                        this.dn.getMetrics().addHeartbeat(Time.now() - startTime);
                        this.bpos.updateActorStatesFromHeartbeat(this, resp.getNameNodeHaState());
                        this.state = resp.getNameNodeHaState().getState();
                        long startProcessCommands = Time.now();
                        if (!this.processCommand(resp.getCommands())) continue;
                        long endProcessCommands = Time.now();
                        if (endProcessCommands - startProcessCommands > 2000L) {
                            LOG.info((Object)("Took " + (endProcessCommands - startProcessCommands) + "ms to process " + resp.getCommands().length + " commands from NN"));
                        }
                    }
                }
                if (this.pendingReceivedRequests > 0 || startTime - this.lastDeletedReport > this.dnConf.deleteReportInterval) {
                    this.reportReceivedDeletedBlocks();
                    this.lastDeletedReport = startTime;
                }
                DatanodeCommand cmd = this.blockReport();
                this.processCommand(new DatanodeCommand[]{cmd});
                cmd = this.cacheReport();
                this.processCommand(new DatanodeCommand[]{cmd});
                if (this.dn.blockScanner != null) {
                    this.dn.blockScanner.addBlockPool(this.bpos.getBlockPoolId());
                }
                long waitTime = this.dnConf.heartBeatInterval - (Time.now() - this.lastHeartbeat);
                Map<String, PerStoragePendingIncrementalBR> map = this.pendingIncrementalBRperStorage;
                synchronized (map) {
                    if (waitTime > 0L && this.pendingReceivedRequests == 0) {
                        try {
                            this.pendingIncrementalBRperStorage.wait(waitTime);
                        }
                        catch (InterruptedException ie) {
                            LOG.warn((Object)("BPOfferService for " + this + " interrupted"));
                        }
                    }
                }
            }
            catch (RemoteException re) {
                String reClass = re.getClassName();
                if (UnregisteredNodeException.class.getName().equals(reClass) || DisallowedDatanodeException.class.getName().equals(reClass) || IncorrectVersionException.class.getName().equals(reClass)) {
                    LOG.warn((Object)(this + " is shutting down"), (Throwable)re);
                    this.shouldServiceRun = false;
                    return;
                }
                LOG.warn((Object)"RemoteException in offerService", (Throwable)re);
                try {
                    long sleepTime = Math.min(1000L, this.dnConf.heartBeatInterval);
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"IOException in offerService", (Throwable)e);
            }
        }
    }

    void register() throws IOException {
        this.bpRegistration = this.bpos.createRegistration();
        LOG.info((Object)(this + " beginning handshake with NN"));
        while (this.shouldRun()) {
            try {
                this.bpRegistration = this.bpNamenode.registerDatanode(this.bpRegistration);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + this.nnAddr));
                this.sleepAndLogInterrupts(1000, "connecting to server");
            }
        }
        LOG.info((Object)("Block pool " + this + " successfully registered with NN"));
        this.bpos.registrationSucceeded(this, this.bpRegistration);
        this.scheduleBlockReport(this.dnConf.initialBlockReportDelay);
    }

    private void sleepAndLogInterrupts(int millis, String stateString) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            LOG.info((Object)("BPOfferService " + this + " interrupted while " + stateString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info((Object)(this + " starting to offer service"));
        try {
            try {
                this.connectToNNAndHandshake();
            }
            catch (IOException ioe) {
                LOG.fatal((Object)("Initialization failed for block pool " + this), (Throwable)ioe);
                LOG.warn((Object)("Ending block pool service for: " + this));
                this.cleanUp();
                return;
            }
            this.initialized = true;
            while (this.shouldRun()) {
                try {
                    this.offerService();
                }
                catch (Exception ex) {
                    LOG.error((Object)("Exception in BPOfferService for " + this), (Throwable)ex);
                    this.sleepAndLogInterrupts(5000, "offering service");
                }
            }
        }
        catch (Throwable ex) {
            LOG.warn((Object)("Unexpected exception in block pool " + this), ex);
        }
        finally {
            LOG.warn((Object)("Ending block pool service for: " + this));
            this.cleanUp();
        }
    }

    private boolean shouldRun() {
        return this.shouldServiceRun && this.dn.shouldRun();
    }

    boolean processCommand(DatanodeCommand[] cmds) {
        if (cmds != null) {
            for (DatanodeCommand cmd : cmds) {
                try {
                    if (!this.bpos.processCommandFromActor(cmd, this)) {
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error processing datanode Command", (Throwable)ioe);
                }
            }
        }
        return true;
    }

    void trySendErrorReport(int errCode, String errMsg) {
        try {
            this.bpNamenode.errorReport(this.bpRegistration, errCode, errMsg);
        }
        catch (IOException e) {
            LOG.warn((Object)("Error reporting an error to NameNode " + this.nnAddr), (Throwable)e);
        }
    }

    void reportRemoteBadBlock(DatanodeInfo dnInfo, ExtendedBlock block) throws IOException {
        LocatedBlock lb = new LocatedBlock(block, new DatanodeInfo[]{dnInfo});
        this.bpNamenode.reportBadBlocks(new LocatedBlock[]{lb});
    }

    void reRegister() throws IOException {
        if (this.shouldRun()) {
            this.retrieveNamespaceInfo();
            this.register();
        }
    }

    private static class PerStoragePendingIncrementalBR {
        private Map<Long, ReceivedDeletedBlockInfo> pendingIncrementalBR = Maps.newHashMap();

        private PerStoragePendingIncrementalBR() {
        }

        int getBlockInfoCount() {
            return this.pendingIncrementalBR.size();
        }

        ReceivedDeletedBlockInfo[] dequeueBlockInfos() {
            ReceivedDeletedBlockInfo[] blockInfos = this.pendingIncrementalBR.values().toArray(new ReceivedDeletedBlockInfo[this.getBlockInfoCount()]);
            this.pendingIncrementalBR.clear();
            return blockInfos;
        }

        int putMissingBlockInfos(ReceivedDeletedBlockInfo[] blockArray) {
            int blocksPut = 0;
            for (ReceivedDeletedBlockInfo rdbi : blockArray) {
                if (this.pendingIncrementalBR.containsKey(rdbi.getBlock().getBlockId())) continue;
                this.pendingIncrementalBR.put(rdbi.getBlock().getBlockId(), rdbi);
                ++blocksPut;
            }
            return blocksPut;
        }

        void putBlockInfo(ReceivedDeletedBlockInfo blockInfo) {
            this.pendingIncrementalBR.put(blockInfo.getBlock().getBlockId(), blockInfo);
        }

        boolean removeBlockInfo(ReceivedDeletedBlockInfo blockInfo) {
            return this.pendingIncrementalBR.remove(blockInfo.getBlock().getBlockId()) != null;
        }
    }
}

