/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaUtils {
    private static final Logger log = LoggerFactory.getLogger(KafkaUtils.class);

    public static String getTopicName(State state) {
        Preconditions.checkArgument((boolean)state.contains("topic.name"), (Object)"Missing configuration property topic.name");
        return state.getProp("topic.name");
    }

    public static KafkaPartition getPartition(State state) {
        Preconditions.checkArgument((boolean)state.contains("topic.name"), (Object)"Missing configuration property topic.name");
        Preconditions.checkArgument((boolean)state.contains("partition.id"), (Object)"Missing configuration property partition.id");
        KafkaPartition.Builder builder = new KafkaPartition.Builder().withTopicName(state.getProp("topic.name")).withId(state.getPropAsInt("partition.id"));
        if (state.contains("leader.id")) {
            builder = builder.withLeaderId(state.getPropAsInt("leader.id"));
        }
        if (state.contains("leader.hostandport")) {
            builder = builder.withLeaderHostAndPort(state.getProp("leader.hostandport"));
        }
        return builder.build();
    }

    public static List<KafkaPartition> getPartitions(State state) {
        ArrayList partitions = Lists.newArrayList();
        String topicName = state.getProp("topic.name");
        int i = 0;
        while (state.contains(KafkaUtils.getPartitionPropName("partition.id", i))) {
            KafkaPartition partition = new KafkaPartition.Builder().withTopicName(topicName).withId(state.getPropAsInt(KafkaUtils.getPartitionPropName("partition.id", i))).withLeaderId(state.getPropAsInt(KafkaUtils.getPartitionPropName("leader.id", i))).withLeaderHostAndPort(state.getProp(KafkaUtils.getPartitionPropName("leader.hostandport", i))).build();
            partitions.add(partition);
            ++i;
        }
        if (partitions.isEmpty()) {
            partitions.add(KafkaUtils.getPartition(state));
        }
        return partitions;
    }

    public static String getPartitionPropName(String topicName, int partitionId) {
        return topicName + "." + partitionId;
    }

    public static boolean containsPartitionAvgRecordSize(State state, KafkaPartition partition) {
        return state.contains(KafkaUtils.getPartitionPropName(partition.getTopicName(), partition.getId()) + "." + "avg.record.size");
    }

    public static long getPartitionAvgRecordSize(State state, KafkaPartition partition) {
        return state.getPropAsLong(KafkaUtils.getPartitionPropName(partition.getTopicName(), partition.getId()) + "." + "avg.record.size");
    }

    public static void setPartitionAvgRecordSize(State state, KafkaPartition partition, long size) {
        state.setProp(KafkaUtils.getPartitionPropName(partition.getTopicName(), partition.getId()) + "." + "avg.record.size", (Object)size);
    }

    public static boolean containsPartitionAvgRecordMillis(State state, KafkaPartition partition) {
        return state.contains(KafkaUtils.getPartitionPropName(partition.getTopicName(), partition.getId()) + "." + "avg.record.millis");
    }

    public static double getPartitionAvgRecordMillis(State state, KafkaPartition partition) {
        double avgRecordMillis = state.getPropAsDouble(KafkaUtils.getPartitionPropName(partition.getTopicName(), partition.getId()) + "." + "avg.record.millis");
        int avgFetchTimeCap = state.getPropAsInt("kakfa.source.avgFetchTimeCap", 100);
        if (avgFetchTimeCap > 0 && avgRecordMillis > (double)avgFetchTimeCap) {
            log.info("Topic {} partition {} has an average fetch time of {}, capping it to {}", new Object[]{partition.getTopicName(), partition.getId(), avgRecordMillis, avgFetchTimeCap});
            avgRecordMillis = avgFetchTimeCap;
        }
        return avgRecordMillis;
    }

    public static void setPartitionAvgRecordMillis(State state, KafkaPartition partition, double millis) {
        state.setProp(KafkaUtils.getPartitionPropName(partition.getTopicName(), partition.getId()) + "." + "avg.record.millis", (Object)millis);
    }
}

