/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaPartition;

public final class KafkaTopic {
    private final String name;
    private final List<KafkaPartition> partitions;

    public KafkaTopic(String name, List<KafkaPartition> partitions) {
        this.name = name;
        this.partitions = Lists.newArrayList();
        for (KafkaPartition partition : partitions) {
            this.partitions.add(new KafkaPartition(partition));
        }
    }

    public String getName() {
        return this.name;
    }

    public List<KafkaPartition> getPartitions() {
        return Collections.unmodifiableList(this.partitions);
    }
}

