/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.net.HostAndPort;

public final class KafkaPartition {
    private final int id;
    private final String topicName;
    private KafkaLeader leader;

    public KafkaPartition(KafkaPartition other) {
        this.topicName = other.topicName;
        this.id = other.id;
        this.leader = new KafkaLeader(other.leader.id, other.leader.hostAndPort);
    }

    private KafkaPartition(Builder builder) {
        this.id = builder.id;
        this.topicName = builder.topicName;
        this.leader = new KafkaLeader(builder.leaderId, builder.leaderHostAndPort);
    }

    public KafkaLeader getLeader() {
        return this.leader;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public int getId() {
        return this.id;
    }

    public void setLeader(int leaderId, String leaderHost, int leaderPort) {
        this.leader = new KafkaLeader(leaderId, HostAndPort.fromParts((String)leaderHost, (int)leaderPort));
    }

    public String toString() {
        return this.getTopicName() + ":" + this.getId();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.topicName == null ? 0 : this.topicName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KafkaPartition)) {
            return false;
        }
        KafkaPartition other = (KafkaPartition)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName));
    }

    public static final class KafkaLeader {
        private final int id;
        private final HostAndPort hostAndPort;

        public int getId() {
            return this.id;
        }

        public HostAndPort getHostAndPort() {
            return this.hostAndPort;
        }

        public KafkaLeader(int id, HostAndPort hostAndPort) {
            this.id = id;
            this.hostAndPort = hostAndPort;
        }
    }

    public static class Builder {
        private int id = 0;
        private String topicName = "";
        private int leaderId = 0;
        private HostAndPort leaderHostAndPort;

        public Builder withId(int id) {
            this.id = id;
            return this;
        }

        public Builder withTopicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public Builder withLeaderId(int leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        public Builder withLeaderHostAndPort(String hostPortString) {
            this.leaderHostAndPort = HostAndPort.fromString((String)hostPortString);
            return this;
        }

        public Builder withLeaderHostAndPort(String host, int port) {
            this.leaderHostAndPort = HostAndPort.fromParts((String)host, (int)port);
            return this;
        }

        public KafkaPartition build() {
            return new KafkaPartition(this);
        }
    }
}

