/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.gobblin.kafka.client.GobblinKafkaConsumerClient;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaTopic;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.DatasetFilterUtils;

public abstract class AbstractBaseKafkaConsumerClient
implements GobblinKafkaConsumerClient {
    public static final String CONFIG_NAMESPACE = "source.kafka";
    public static final String CONFIG_PREFIX = "source.kafka.";
    public static final String CONSUMER_CONFIG = "consumerConfig";
    public static final String CONFIG_KAFKA_FETCH_TIMEOUT_VALUE = "source.kafka.fetchTimeoutMillis";
    public static final int CONFIG_KAFKA_FETCH_TIMEOUT_VALUE_DEFAULT = 1000;
    public static final String CONFIG_KAFKA_FETCH_REQUEST_MIN_BYTES = "source.kafka.fetchMinBytes";
    private static final int CONFIG_KAFKA_FETCH_REQUEST_MIN_BYTES_DEFAULT = 1024;
    public static final String CONFIG_KAFKA_SOCKET_TIMEOUT_VALUE = "source.kafka.socketTimeoutMillis";
    public static final int CONFIG_KAFKA_SOCKET_TIMEOUT_VALUE_DEFAULT = 30000;
    protected final List<String> brokers;
    protected final int fetchTimeoutMillis;
    protected final int fetchMinBytes;
    protected final int socketTimeoutMillis;

    public AbstractBaseKafkaConsumerClient(Config config) {
        this.brokers = ConfigUtils.getStringList((Config)config, (String)"kafka.brokers");
        if (this.brokers.isEmpty()) {
            throw new IllegalArgumentException("Need to specify at least one Kafka broker.");
        }
        this.socketTimeoutMillis = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_SOCKET_TIMEOUT_VALUE, (Integer)30000);
        this.fetchTimeoutMillis = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_TIMEOUT_VALUE, (Integer)1000);
        this.fetchMinBytes = ConfigUtils.getInt((Config)config, (String)CONFIG_KAFKA_FETCH_REQUEST_MIN_BYTES, (Integer)1024);
        Preconditions.checkArgument((this.fetchTimeoutMillis < this.socketTimeoutMillis ? 1 : 0) != 0, (Object)("Kafka Source configuration error: FetchTimeout " + this.fetchTimeoutMillis + " must be smaller than SocketTimeout " + this.socketTimeoutMillis));
    }

    @Override
    public List<KafkaTopic> getFilteredTopics(final List<Pattern> blacklist, final List<Pattern> whitelist) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getTopics(), (Predicate)new Predicate<KafkaTopic>(){

            public boolean apply(@Nonnull KafkaTopic kafkaTopic) {
                return DatasetFilterUtils.survived((String)kafkaTopic.getName(), (List)blacklist, (List)whitelist);
            }
        }));
    }

    public abstract List<KafkaTopic> getTopics();
}

