/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.example.hivematerializer;

import com.google.api.client.repackaged.com.google.common.base.Splitter;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.conversion.hive.entities.StageableTableMetadata;
import org.apache.gobblin.data.management.conversion.hive.materializer.HiveMaterializer;
import org.apache.gobblin.data.management.conversion.hive.source.HiveWorkUnit;
import org.apache.gobblin.data.management.conversion.hive.task.HiveConverterUtils;
import org.apache.gobblin.data.management.conversion.hive.task.HiveTask;
import org.apache.gobblin.data.management.copy.hive.HiveDataset;
import org.apache.gobblin.data.management.copy.hive.HiveDatasetFinder;
import org.apache.gobblin.hive.HiveMetastoreClientPool;
import org.apache.gobblin.source.Source;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.AutoReturnableObject;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMaterializerSource
implements Source<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(HiveMaterializerSource.class);
    private static final String HIVE_MATERIALIZER_SOURCE_PREFIX = "gobblin.hiveMaterializerSource";
    public static final String COPY_TABLE_KEY = "gobblin.hiveMaterializerSource.copyTable";
    public static final String MATERIALIZE_VIEW = "gobblin.hiveMaterializerSource.materializeView";
    public static final String MATERIALIZE_QUERY = "gobblin.hiveMaterializerSource.materializeQuery";
    public static final String OUTPUT_STORAGE_FORMAT = "gobblin.hiveMaterializerSource.outputStorageFormat";

    public List<WorkUnit> getWorkunits(SourceState state) {
        try {
            FileSystem fs = HadoopUtils.getSourceFileSystem((State)state);
            Config config = ConfigUtils.propertiesToConfig((Properties)state.getProperties());
            if (state.contains(COPY_TABLE_KEY)) {
                HiveDataset dataset = this.getHiveDataset(state.getProp(COPY_TABLE_KEY), fs, (State)state);
                HiveWorkUnit workUnit = HiveMaterializer.tableCopyWorkUnit((HiveDataset)dataset, (StageableTableMetadata)new StageableTableMetadata(config.getConfig(HIVE_MATERIALIZER_SOURCE_PREFIX), dataset.getTable()), null);
                HiveTask.disableHiveWatermarker((State)workUnit);
                return Lists.newArrayList((Object[])new WorkUnit[]{workUnit});
            }
            if (state.contains(MATERIALIZE_VIEW)) {
                HiveDataset dataset = this.getHiveDataset(state.getProp(MATERIALIZE_VIEW), fs, (State)state);
                HiveWorkUnit workUnit = HiveMaterializer.viewMaterializationWorkUnit((HiveDataset)dataset, (HiveConverterUtils.StorageFormat)this.getOutputStorageFormat((State)state), (StageableTableMetadata)new StageableTableMetadata(config.getConfig(HIVE_MATERIALIZER_SOURCE_PREFIX), dataset.getTable()), null);
                HiveTask.disableHiveWatermarker((State)workUnit);
                return Lists.newArrayList((Object[])new WorkUnit[]{workUnit});
            }
            if (state.contains(MATERIALIZE_QUERY)) {
                String query = state.getProp(MATERIALIZE_QUERY);
                WorkUnit workUnit = HiveMaterializer.queryResultMaterializationWorkUnit((String)query, (HiveConverterUtils.StorageFormat)this.getOutputStorageFormat((State)state), (StageableTableMetadata)new StageableTableMetadata(config.getConfig(HIVE_MATERIALIZER_SOURCE_PREFIX), null));
                HiveTask.disableHiveWatermarker((State)workUnit);
                return Lists.newArrayList((Object[])new WorkUnit[]{workUnit});
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        throw new RuntimeException(String.format("Must specify either %s, %s, or %s.", COPY_TABLE_KEY, MATERIALIZE_QUERY, MATERIALIZE_VIEW));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HiveDataset getHiveDataset(String tableString, FileSystem fs, State state) throws IOException {
        try {
            HiveMetastoreClientPool pool = HiveMetastoreClientPool.get((Properties)state.getProperties(), (Optional)Optional.fromNullable((Object)state.getProp("hive.dataset.hive.metastore.uri")));
            List tokens = Splitter.on((String)".").splitToList((CharSequence)tableString);
            HiveDatasetFinder.DbAndTable sourceDbAndTable = new HiveDatasetFinder.DbAndTable((String)tokens.get(0), (String)tokens.get(1));
            try (AutoReturnableObject client = pool.getClient();){
                Table sourceTable = new Table(((IMetaStoreClient)client.get()).getTable(sourceDbAndTable.getDb(), sourceDbAndTable.getTable()));
                HiveDataset hiveDataset = new HiveDataset(fs, pool, sourceTable, ConfigUtils.propertiesToConfig((Properties)state.getProperties()));
                return hiveDataset;
            }
        }
        catch (TException exc) {
            throw new RuntimeException(exc);
        }
    }

    private HiveConverterUtils.StorageFormat getOutputStorageFormat(State state) {
        return HiveConverterUtils.StorageFormat.valueOf((String)state.getProp(OUTPUT_STORAGE_FORMAT, HiveConverterUtils.StorageFormat.TEXT_FILE.name()));
    }

    public Extractor<Object, Object> getExtractor(WorkUnitState state) throws IOException {
        return null;
    }

    public void shutdown(SourceState state) {
    }
}

