/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.runtime.JobException;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecCatalogListener;
import org.apache.gobblin.runtime.listeners.JobListener;
import org.apache.gobblin.runtime.spec_catalog.FlowCatalog;
import org.apache.gobblin.runtime.spec_catalog.TopologyCatalog;
import org.apache.gobblin.scheduler.BaseGobblinJob;
import org.apache.gobblin.scheduler.JobScheduler;
import org.apache.gobblin.scheduler.SchedulerService;
import org.apache.gobblin.service.modules.orchestration.Orchestrator;
import org.apache.gobblin.service.modules.utils.HelixUtils;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.PropertiesUtils;
import org.apache.helix.HelixManager;
import org.apache.helix.InstanceType;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinServiceJobScheduler
extends JobScheduler
implements SpecCatalogListener {
    protected final Logger _log;
    protected final Optional<FlowCatalog> flowCatalog;
    protected final Optional<HelixManager> helixManager;
    protected final Orchestrator orchestrator;
    protected final Map<String, Spec> scheduledFlowSpecs;
    protected volatile boolean isActive;

    public GobblinServiceJobScheduler(Config config, Optional<HelixManager> helixManager, Optional<FlowCatalog> flowCatalog, Optional<TopologyCatalog> topologyCatalog, Orchestrator orchestrator, SchedulerService schedulerService, Optional<Logger> log) throws Exception {
        super(ConfigUtils.configToProperties((Config)config), schedulerService);
        this._log = log.isPresent() ? (Logger)log.get() : LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.flowCatalog = flowCatalog;
        this.helixManager = helixManager;
        this.orchestrator = orchestrator;
        this.scheduledFlowSpecs = Maps.newHashMap();
    }

    public GobblinServiceJobScheduler(Config config, Optional<HelixManager> helixManager, Optional<FlowCatalog> flowCatalog, Optional<TopologyCatalog> topologyCatalog, SchedulerService schedulerService, Optional<Logger> log) throws Exception {
        this(config, helixManager, flowCatalog, topologyCatalog, new Orchestrator(config, topologyCatalog, log), schedulerService, log);
    }

    public synchronized void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        if (isActive) {
            this.isActive = isActive;
            if (this.flowCatalog.isPresent()) {
                Collection specs = ((FlowCatalog)this.flowCatalog.get()).getSpecsWithTimeUpdate();
                for (Spec spec : specs) {
                    if (spec instanceof FlowSpec) {
                        Spec modifiedSpec = GobblinServiceJobScheduler.disableFlowRunImmediatelyOnStart((FlowSpec)spec);
                        this.onAddSpec(modifiedSpec);
                        continue;
                    }
                    this.onAddSpec(spec);
                }
            }
        } else {
            for (Spec spec : this.scheduledFlowSpecs.values()) {
                this.onDeleteSpec(spec.getUri(), spec.getVersion());
            }
            this.isActive = isActive;
        }
    }

    @VisibleForTesting
    protected static Spec disableFlowRunImmediatelyOnStart(FlowSpec spec) {
        Properties properties = spec.getConfigAsProperties();
        properties.setProperty("flow.runImmediately", "false");
        Config config = ConfigFactory.parseProperties((Properties)properties);
        FlowSpec flowSpec = new FlowSpec(spec.getUri(), spec.getVersion(), spec.getDescription(), config, properties, spec.getTemplateURIs(), spec.getChildSpecs());
        return flowSpec;
    }

    protected void startUp() throws Exception {
        super.startUp();
    }

    public synchronized void scheduleJob(Properties jobProps, JobListener jobListener) throws JobException {
        HashMap additionalJobDataMap = Maps.newHashMap();
        additionalJobDataMap.put("gobblin.service.flowSpec", this.scheduledFlowSpecs.get(jobProps.getProperty("job.name")));
        try {
            this.scheduleJob(jobProps, jobListener, additionalJobDataMap, GobblinServiceJob.class);
        }
        catch (Exception e) {
            throw new JobException("Failed to schedule job " + jobProps.getProperty("job.name"), (Throwable)e);
        }
    }

    public void runJob(Properties jobProps, JobListener jobListener) throws JobException {
        try {
            Spec flowSpec = this.scheduledFlowSpecs.get(jobProps.getProperty("job.name"));
            this.orchestrator.orchestrate(flowSpec);
        }
        catch (Exception e) {
            throw new JobException("Failed to run Spec: " + jobProps.getProperty("job.name"), (Throwable)e);
        }
    }

    public void onAddSpec(Spec addedSpec) {
        if (this.helixManager.isPresent() && !((HelixManager)this.helixManager.get()).isConnected()) {
            this._log.info("System not yet initialized. Skipping Spec Addition: " + addedSpec);
            return;
        }
        this._log.info("New Flow Spec detected: " + addedSpec);
        if (addedSpec instanceof FlowSpec) {
            if (!this.isActive && this.helixManager.isPresent()) {
                this._log.info("Scheduler running in slave mode, forward Spec add via Helix message to master: " + addedSpec);
                HelixUtils.sendUserDefinedMessage("FLOWSPEC_ADD", addedSpec.getUri().toString(), UUID.randomUUID().toString(), InstanceType.CONTROLLER, (HelixManager)this.helixManager.get(), this._log);
                return;
            }
            try {
                Properties jobConfig = new Properties();
                Properties flowSpecProperties = ((FlowSpec)addedSpec).getConfigAsProperties();
                jobConfig.putAll((Map<?, ?>)this.properties);
                jobConfig.setProperty("job.name", addedSpec.getUri().toString());
                jobConfig.setProperty("job.group", ((FlowSpec)addedSpec).getConfig().getValue("flow.group").toString());
                jobConfig.setProperty("flow.runImmediately", ConfigUtils.getString((Config)((FlowSpec)addedSpec).getConfig(), (String)"flow.runImmediately", (String)"false"));
                if (flowSpecProperties.containsKey("job.schedule") && StringUtils.isNotBlank((String)flowSpecProperties.getProperty("job.schedule"))) {
                    jobConfig.setProperty("job.schedule", flowSpecProperties.getProperty("job.schedule"));
                }
                this.scheduledFlowSpecs.put(addedSpec.getUri().toString(), addedSpec);
                if (jobConfig.containsKey("job.schedule")) {
                    this._log.info("Scheduling flow spec: " + addedSpec);
                    this.scheduleJob(jobConfig, null);
                    if (PropertiesUtils.getPropAsBoolean((Properties)jobConfig, (String)"flow.runImmediately", (String)"false")) {
                        this._log.info("RunImmediately requested, hence executing FlowSpec: " + addedSpec);
                        this.jobExecutor.execute(new NonScheduledJobRunner(jobConfig, null));
                    }
                } else {
                    this._log.info("No FlowSpec schedule found, so running FlowSpec: " + addedSpec);
                    this.jobExecutor.execute(new NonScheduledJobRunner(jobConfig, null));
                }
            }
            catch (JobException je) {
                this._log.error("Failed to schedule or run FlowSpec " + addedSpec, (Throwable)je);
            }
        }
    }

    public void onDeleteSpec(URI deletedSpecURI, String deletedSpecVersion) {
        if (this.helixManager.isPresent() && !((HelixManager)this.helixManager.get()).isConnected()) {
            this._log.info("System not yet initialized. Skipping Spec Deletion: " + deletedSpecURI);
            return;
        }
        this._log.info("Spec deletion detected: " + deletedSpecURI + "/" + deletedSpecVersion);
        if (!this.isActive && this.helixManager.isPresent()) {
            this._log.info("Scheduler running in slave mode, forward Spec delete via Helix message to master: " + deletedSpecURI);
            HelixUtils.sendUserDefinedMessage("FLOWSPEC_REMOVE", deletedSpecURI.toString() + ":" + deletedSpecVersion, UUID.randomUUID().toString(), InstanceType.CONTROLLER, (HelixManager)this.helixManager.get(), this._log);
            return;
        }
        try {
            Spec deletedSpec = this.scheduledFlowSpecs.get(deletedSpecURI.toString());
            if (null != deletedSpec) {
                this.orchestrator.remove(deletedSpec);
                this.scheduledFlowSpecs.remove(deletedSpecURI.toString());
                this.unscheduleJob(deletedSpecURI.toString());
            } else {
                this._log.warn(String.format("Spec with URI: %s was not found in cache. May be it was cleaned, if not please clean it manually", deletedSpecURI));
            }
        }
        catch (JobException e) {
            this._log.warn(String.format("Spec with URI: %s was not unscheduled cleaning", deletedSpecURI), (Throwable)e);
        }
    }

    public void onUpdateSpec(Spec updatedSpec) {
        if (this.helixManager.isPresent() && !((HelixManager)this.helixManager.get()).isConnected()) {
            this._log.info("System not yet initialized. Skipping Spec Update: " + updatedSpec);
            return;
        }
        this._log.info("Spec changed: " + updatedSpec);
        if (!(updatedSpec instanceof FlowSpec)) {
            return;
        }
        if (!this.isActive && this.helixManager.isPresent()) {
            this._log.info("Scheduler running in slave mode, forward Spec update via Helix message to master: " + updatedSpec);
            HelixUtils.sendUserDefinedMessage("FLOWSPEC_UPDATE", updatedSpec.getUri().toString(), UUID.randomUUID().toString(), InstanceType.CONTROLLER, (HelixManager)this.helixManager.get(), this._log);
            return;
        }
        try {
            this.onDeleteSpec(updatedSpec.getUri(), updatedSpec.getVersion());
        }
        catch (Exception e) {
            this._log.error("Failed to update Spec: " + updatedSpec, (Throwable)e);
        }
        try {
            this.onAddSpec(updatedSpec);
        }
        catch (Exception e) {
            this._log.error("Failed to update Spec: " + updatedSpec, (Throwable)e);
        }
    }

    public Map<String, Spec> getScheduledFlowSpecs() {
        return this.scheduledFlowSpecs;
    }

    public boolean isActive() {
        return this.isActive;
    }

    class NonScheduledJobRunner
    implements Runnable {
        private final Properties jobConfig;
        private final JobListener jobListener;

        public NonScheduledJobRunner(Properties jobConfig, JobListener jobListener) {
            this.jobConfig = jobConfig;
            this.jobListener = jobListener;
        }

        @Override
        public void run() {
            try {
                GobblinServiceJobScheduler.this.runJob(this.jobConfig, this.jobListener);
            }
            catch (JobException je) {
                GobblinServiceJobScheduler.this._log.error("Failed to run job " + this.jobConfig.getProperty("job.name"), (Throwable)je);
            }
        }
    }

    @DisallowConcurrentExecution
    public static class GobblinServiceJob
    extends BaseGobblinJob
    implements InterruptableJob {
        private static final Logger log = LoggerFactory.getLogger(GobblinServiceJob.class);
        private static final Logger _log = LoggerFactory.getLogger(GobblinServiceJob.class);

        public void executeImpl(JobExecutionContext context) throws JobExecutionException {
            _log.info("Starting FlowSpec " + context.getJobDetail().getKey());
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            JobScheduler jobScheduler = (JobScheduler)dataMap.get((Object)"jobScheduler");
            Properties jobProps = (Properties)dataMap.get((Object)"jobProps");
            JobListener jobListener = (JobListener)dataMap.get((Object)"jobListener");
            try {
                jobScheduler.runJob(jobProps, jobListener);
            }
            catch (Throwable t) {
                throw new JobExecutionException(t);
            }
        }

        public void interrupt() throws UnableToInterruptJobException {
            log.info("Job was interrupted");
        }
    }
}

