/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.gobblin.broker.SharedResourcesBrokerFactory;
import org.apache.gobblin.broker.SharedResourcesBrokerImpl;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.gobblin_scopes.JobScopeInstance;
import org.apache.gobblin.broker.iface.ScopeInstance;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.cluster.TaskAttemptBuilder;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.runtime.GobblinMultiTaskAttempt;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.util.StateStores;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.JobLauncherUtils;
import org.apache.gobblin.util.SerializationUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTask {
    private static final Logger _logger = LoggerFactory.getLogger(SingleTask.class);
    private GobblinMultiTaskAttempt _taskattempt;
    private String _jobId;
    private Path _workUnitFilePath;
    private Path _jobStateFilePath;
    private FileSystem _fs;
    private TaskAttemptBuilder _taskAttemptBuilder;
    private StateStores _stateStores;

    SingleTask(String jobId, Path workUnitFilePath, Path jobStateFilePath, FileSystem fs, TaskAttemptBuilder taskAttemptBuilder, StateStores stateStores) {
        this._jobId = jobId;
        this._workUnitFilePath = workUnitFilePath;
        this._jobStateFilePath = jobStateFilePath;
        this._fs = fs;
        this._taskAttemptBuilder = taskAttemptBuilder;
        this._stateStores = stateStores;
    }

    public void run() throws IOException, InterruptedException {
        List<WorkUnit> workUnits = this.getWorkUnits();
        JobState jobState = this.getJobState();
        Config jobConfig = this.getConfigFromJobState(jobState);
        _logger.debug("SingleTask.run: jobId {} workUnitFilePath {} jobStateFilePath {} jobState {} jobConfig {}", new Object[]{this._jobId, this._workUnitFilePath, this._jobStateFilePath, jobState, jobConfig});
        try (SharedResourcesBrokerImpl globalBroker = SharedResourcesBrokerFactory.createDefaultTopLevelBroker((Config)jobConfig, (ScopeInstance)GobblinScopeTypes.GLOBAL.defaultScopeInstance());){
            SharedResourcesBroker<GobblinScopeTypes> jobBroker = this.getJobBroker(jobState, (SharedResourcesBroker<GobblinScopeTypes>)globalBroker);
            this._taskattempt = this._taskAttemptBuilder.build(workUnits.iterator(), this._jobId, jobState, jobBroker);
            this._taskattempt.runAndOptionallyCommitTaskAttempt(GobblinMultiTaskAttempt.CommitPolicy.IMMEDIATE);
        }
    }

    private SharedResourcesBroker<GobblinScopeTypes> getJobBroker(JobState jobState, SharedResourcesBroker<GobblinScopeTypes> globalBroker) {
        return globalBroker.newSubscopedBuilder((ScopeInstance)new JobScopeInstance(jobState.getJobName(), jobState.getJobId())).build();
    }

    private Config getConfigFromJobState(JobState jobState) {
        Properties jobProperties = jobState.getProperties();
        return ConfigFactory.parseProperties((Properties)jobProperties);
    }

    private JobState getJobState() throws IOException {
        JobState jobState;
        if (this._stateStores.haveJobStateStore()) {
            jobState = (JobState)this._stateStores.getJobStateStore().get(this._jobStateFilePath.getParent().getName(), this._jobStateFilePath.getName(), this._jobStateFilePath.getParent().getName());
        } else {
            jobState = new JobState();
            SerializationUtils.deserializeState((FileSystem)this._fs, (Path)this._jobStateFilePath, (State)jobState);
        }
        return jobState;
    }

    private List<WorkUnit> getWorkUnits() throws IOException {
        String fileName = this._workUnitFilePath.getName();
        String storeName = this._workUnitFilePath.getParent().getName();
        WorkUnit workUnit = this._workUnitFilePath.getName().endsWith(".mwu") ? (WorkUnit)this._stateStores.getMwuStateStore().getAll(storeName, fileName).get(0) : (WorkUnit)this._stateStores.getWuStateStore().getAll(storeName, fileName).get(0);
        ArrayList workUnits = Lists.newArrayList();
        if (workUnit instanceof MultiWorkUnit) {
            List flattenedWorkUnits = JobLauncherUtils.flattenWorkUnits((Collection)((MultiWorkUnit)workUnit).getWorkUnits());
            workUnits.addAll(flattenedWorkUnits);
        } else {
            workUnits.add(workUnit);
        }
        return workUnits;
    }

    public void cancel() {
        if (this._taskattempt != null) {
            try {
                _logger.info("Task cancelled: Shutdown starting for tasks with jobId: {}", (Object)this._jobId);
                this._taskattempt.shutdownTasks();
                _logger.info("Task cancelled: Shutdown complete for tasks with jobId: {}", (Object)this._jobId);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while shutting down task with jobId: " + this._jobId, e);
            }
        } else {
            _logger.error("Task cancelled but _taskattempt is null, so ignoring.");
        }
    }
}

