/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.helix.Criteria;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.CriteriaEvaluator;
import org.apache.helix.messaging.DefaultMessagingService;
import org.apache.helix.messaging.ZNRecordRow;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;

public class GobblinHelixMessagingService
extends DefaultMessagingService {
    private GobblinHelixCriteriaEvaluator _gobblinHelixCriteriaEvaluator;
    private HelixManager _manager;

    public GobblinHelixMessagingService(HelixManager manager) {
        super(manager);
        this._manager = manager;
        this._gobblinHelixCriteriaEvaluator = new GobblinHelixCriteriaEvaluator();
    }

    private List<Message> generateMessagesForController(Message message) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String id = UUID.randomUUID().toString();
        Message newMessage = new Message(message.getRecord(), id);
        newMessage.setMsgId(id);
        newMessage.setSrcName(this._manager.getInstanceName());
        newMessage.setTgtName("Controller");
        messages.add(newMessage);
        return messages;
    }

    public Map<InstanceType, List<Message>> generateMessage(Criteria recipientCriteria, Message message) {
        HashMap<InstanceType, List<Message>> messagesToSendMap = new HashMap<InstanceType, List<Message>>();
        InstanceType instanceType = recipientCriteria.getRecipientInstanceType();
        if (instanceType == InstanceType.CONTROLLER) {
            List<Message> messages = this.generateMessagesForController(message);
            messagesToSendMap.put(InstanceType.CONTROLLER, messages);
        } else if (instanceType == InstanceType.PARTICIPANT) {
            ArrayList<Message> messages = new ArrayList<Message>();
            List<Map<String, String>> matchedList = this._gobblinHelixCriteriaEvaluator.evaluateCriteria(recipientCriteria, this._manager);
            if (!matchedList.isEmpty()) {
                HashMap<String, String> sessionIdMap = new HashMap<String, String>();
                if (recipientCriteria.isSessionSpecific()) {
                    HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
                    PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                    List liveInstances = accessor.getChildValues(keyBuilder.liveInstances());
                    for (LiveInstance liveInstance : liveInstances) {
                        sessionIdMap.put(liveInstance.getInstanceName(), liveInstance.getSessionId());
                    }
                }
                for (Map<String, String> map : matchedList) {
                    String id = UUID.randomUUID().toString();
                    Message newMessage = new Message(message.getRecord(), id);
                    String srcInstanceName = this._manager.getInstanceName();
                    String tgtInstanceName = map.get("instanceName");
                    if (recipientCriteria.isSelfExcluded() && srcInstanceName.equalsIgnoreCase(tgtInstanceName)) continue;
                    newMessage.setSrcName(srcInstanceName);
                    newMessage.setTgtName(tgtInstanceName);
                    newMessage.setResourceName(map.get("resourceName"));
                    newMessage.setPartitionName(map.get("partitionName"));
                    if (recipientCriteria.isSessionSpecific()) {
                        newMessage.setTgtSessionId((String)sessionIdMap.get(tgtInstanceName));
                    }
                    messages.add(newMessage);
                }
                messagesToSendMap.put(InstanceType.PARTICIPANT, messages);
            }
        }
        return messagesToSendMap;
    }

    public static class GobblinHelixCriteriaEvaluator
    extends CriteriaEvaluator {
        public List<Map<String, String>> evaluateCriteria(Criteria recipientCriteria, HelixManager manager) {
            HelixDataAccessor accessor = manager.getHelixDataAccessor();
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            List properties = accessor.getChildValues(keyBuilder.liveInstances());
            List allRows = ZNRecordRow.flatten((Collection)HelixProperty.convertToList((List)properties));
            Set liveParticipants = accessor.getChildValuesMap(keyBuilder.liveInstances()).keySet();
            ArrayList result = Lists.newArrayList();
            for (ZNRecordRow row : allRows) {
                if (!this.rowMatches(recipientCriteria, row) || !liveParticipants.contains(row.getRecordId()) && !liveParticipants.contains(row.getMapSubKey())) continue;
                result.add(row);
            }
            HashSet selected = Sets.newHashSet();
            for (ZNRecordRow row : result) {
                HashMap<String, String> resultRow = new HashMap<String, String>();
                resultRow.put("instanceName", !recipientCriteria.getInstanceName().equals("") ? (!Strings.isNullOrEmpty((String)row.getMapSubKey()) ? row.getMapSubKey() : row.getRecordId()) : "");
                resultRow.put("resourceName", !recipientCriteria.getResource().equals("") ? row.getRecordId() : "");
                resultRow.put("partitionName", !recipientCriteria.getPartition().equals("") ? row.getMapKey() : "");
                resultRow.put("partitionState", !recipientCriteria.getPartitionState().equals("") ? row.getMapValue() : "");
                selected.add(resultRow);
            }
            return Lists.newArrayList((Iterable)selected);
        }

        private boolean rowMatches(Criteria criteria, ZNRecordRow row) {
            String instanceName = this.normalizePattern(criteria.getInstanceName());
            String resourceName = this.normalizePattern(criteria.getResource());
            String partitionName = this.normalizePattern(criteria.getPartition());
            String partitionState = this.normalizePattern(criteria.getPartitionState());
            return this.stringMatches(instanceName, row.getMapSubKey()) && this.stringMatches(resourceName, row.getRecordId()) && this.stringMatches(partitionName, row.getMapKey()) && this.stringMatches(partitionState, row.getMapValue());
        }

        private String normalizePattern(String pattern) {
            if (pattern == null || pattern.equals("") || pattern.equals("*")) {
                pattern = "%";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < pattern.length(); ++i) {
                char ch = pattern.charAt(i);
                if ("[](){}.*+?$^|#\\".indexOf(ch) != -1) {
                    builder.append("\\");
                }
                builder.append(ch);
            }
            pattern = builder.toString().toLowerCase().replace("_", ".").replace("%", ".*?");
            return pattern;
        }

        private boolean stringMatches(String pattern, String value) {
            Pattern p = Pattern.compile(pattern, 34);
            return p.matcher(value).matches();
        }
    }
}

