/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.GobblinClusterUtils;
import org.apache.gobblin.cluster.GobblinHelixTaskDriver;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.event.TimingEvent;
import org.apache.gobblin.rest.LauncherTypeEnum;
import org.apache.gobblin.runtime.AbstractJobLauncher;
import org.apache.gobblin.runtime.ExecutionModel;
import org.apache.gobblin.runtime.JobException;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.Task;
import org.apache.gobblin.runtime.TaskStateCollectorService;
import org.apache.gobblin.runtime.listeners.JobListener;
import org.apache.gobblin.runtime.util.StateStores;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.Id;
import org.apache.gobblin.util.JobLauncherUtils;
import org.apache.gobblin.util.ParallelRunner;
import org.apache.gobblin.util.SerializationUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.helix.HelixManager;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobQueue;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinHelixJobLauncher
extends AbstractJobLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinHelixJobLauncher.class);
    private static final String WORK_UNIT_FILE_EXTENSION = ".wu";
    private final HelixManager helixManager;
    private final TaskDriver helixTaskDriver;
    private final String helixQueueName;
    private final String jobResourceName;
    private JobListener jobListener;
    private final FileSystem fs;
    private final Path appWorkDir;
    private final Path inputWorkUnitDir;
    private final Path outputTaskStateDir;
    private final int stateSerDeRunnerThreads;
    private final TaskStateCollectorService taskStateCollectorService;
    private volatile boolean jobSubmitted = false;
    private volatile boolean jobComplete = false;
    private final ConcurrentHashMap<String, Boolean> runningMap;
    private final StateStores stateStores;
    private final Config jobConfig;
    private final long jobQueueDeleteTimeoutSeconds;

    public GobblinHelixJobLauncher(Properties jobProps, HelixManager helixManager, Path appWorkDir, List<? extends Tag<?>> metadataTags, ConcurrentHashMap<String, Boolean> runningMap) throws Exception {
        super(jobProps, GobblinHelixJobLauncher.addAdditionalMetadataTags(jobProps, metadataTags));
        LOGGER.debug("GobblinHelixJobLauncher: jobProps {}, appWorkDir {}", (Object)jobProps, (Object)appWorkDir);
        this.helixManager = helixManager;
        this.helixTaskDriver = new TaskDriver(this.helixManager);
        this.runningMap = runningMap;
        this.appWorkDir = appWorkDir;
        this.inputWorkUnitDir = new Path(appWorkDir, "_workunits");
        this.outputTaskStateDir = new Path(this.appWorkDir, "_taskstates/" + this.jobContext.getJobId());
        this.helixQueueName = this.jobContext.getJobName();
        this.jobResourceName = TaskUtil.getNamespacedJobName((String)this.helixQueueName, (String)this.jobContext.getJobId());
        this.jobContext.getJobState().setJobLauncherType(LauncherTypeEnum.CLUSTER);
        this.stateSerDeRunnerThreads = Integer.parseInt(jobProps.getProperty("parallel.runner.threads", Integer.toString(10)));
        this.jobConfig = ConfigUtils.propertiesToConfig((Properties)jobProps);
        this.jobQueueDeleteTimeoutSeconds = ConfigUtils.getLong((Config)this.jobConfig, (String)"gobblin.cluster.jobQueueDeleteTimeoutSeconds", (Long)300L);
        Config stateStoreJobConfig = ConfigUtils.propertiesToConfig((Properties)jobProps).withValue("state.store.fs.uri", ConfigValueFactory.fromAnyRef((Object)new URI(appWorkDir.toUri().getScheme(), null, appWorkDir.toUri().getHost(), appWorkDir.toUri().getPort(), null, null, null).toString()));
        this.stateStores = new StateStores(stateStoreJobConfig, appWorkDir, "_taskstates", appWorkDir, "_workunits", appWorkDir, "_jobstates");
        URI fsUri = URI.create(jobProps.getProperty("fs.uri", "file:///"));
        this.fs = FileSystem.get((URI)fsUri, (Configuration)new Configuration());
        this.taskStateCollectorService = new TaskStateCollectorService(jobProps, this.jobContext.getJobState(), this.eventBus, this.stateStores.getTaskStateStore(), this.outputTaskStateDir);
        this.startCancellationExecutor();
    }

    public void close() throws IOException {
        try {
            this.executeCancellation();
        }
        finally {
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWorkUnits(List<WorkUnit> workUnits) throws Exception {
        try {
            long workUnitStartTime = System.currentTimeMillis();
            workUnits.forEach(k -> k.setProp("workunit.creation.time.in.millis", (Object)workUnitStartTime));
            this.taskStateCollectorService.startAsync().awaitRunning();
            TimingEvent jobSubmissionTimer = this.eventSubmitter.getTimingEvent("JobHelixSubmissionTimer");
            this.submitJobToHelix(this.createJob(workUnits));
            jobSubmissionTimer.stop();
            LOGGER.info(String.format("Submitted job %s to Helix", this.jobContext.getJobId()));
            this.jobSubmitted = true;
            TimingEvent jobRunTimer = this.eventSubmitter.getTimingEvent("JobHelixRunTimer");
            this.waitForJobCompletion();
            jobRunTimer.stop();
            LOGGER.info(String.format("Job %s completed", this.jobContext.getJobId()));
            this.jobComplete = true;
        }
        finally {
            this.taskStateCollectorService.stopAsync().awaitTerminated();
            this.cleanupWorkingDirectory();
        }
    }

    protected void executeCancellation() {
        if (this.jobSubmitted) {
            try {
                this.helixTaskDriver.delete(this.helixQueueName);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Failed to cancel job {} in Helix", (Object)this.jobContext.getJobId(), (Object)e);
            }
        }
    }

    private JobConfig.Builder createJob(List<WorkUnit> workUnits) throws IOException {
        HashMap taskConfigMap = Maps.newHashMap();
        try (ParallelRunner stateSerDeRunner = new ParallelRunner(this.stateSerDeRunnerThreads, this.fs);){
            Path jobStateFilePath;
            int multiTaskIdSequence = 0;
            for (WorkUnit workUnit : workUnits) {
                if (workUnit instanceof MultiWorkUnit) {
                    workUnit.setId(JobLauncherUtils.newMultiTaskId((String)this.jobContext.getJobId(), (int)multiTaskIdSequence++));
                }
                this.addWorkUnit(workUnit, stateSerDeRunner, taskConfigMap);
            }
            if (this.stateStores.haveJobStateStore()) {
                jobStateFilePath = GobblinClusterUtils.getJobStateFilePath(true, this.appWorkDir, this.jobContext.getJobId());
                this.stateStores.getJobStateStore().put(jobStateFilePath.getParent().getName(), jobStateFilePath.getName(), (State)this.jobContext.getJobState());
            } else {
                jobStateFilePath = GobblinClusterUtils.getJobStateFilePath(false, this.appWorkDir, this.jobContext.getJobId());
                SerializationUtils.serializeState((FileSystem)this.fs, (Path)jobStateFilePath, (State)this.jobContext.getJobState());
            }
            LOGGER.debug("GobblinHelixJobLauncher.createJob: jobStateFilePath {}, jobState {} jobProperties {}", new Object[]{jobStateFilePath, this.jobContext.getJobState().toString(), this.jobContext.getJobState().getProperties()});
        }
        JobConfig.Builder jobConfigBuilder = new JobConfig.Builder();
        jobConfigBuilder.setMaxAttemptsPerTask(this.jobContext.getJobState().getPropAsInt("task.maxretries", 5));
        jobConfigBuilder.setFailureThreshold(workUnits.size());
        jobConfigBuilder.addTaskConfigMap((Map)taskConfigMap).setCommand("GobblinTaskFactory");
        jobConfigBuilder.setNumConcurrentTasksPerInstance(ConfigUtils.getInt((Config)this.jobConfig, (String)"gobblin.cluster.helix.taskConcurrency", (Integer)40).intValue());
        if (Task.getExecutionModel((State)ConfigUtils.configToState((Config)this.jobConfig)).equals((Object)ExecutionModel.STREAMING)) {
            jobConfigBuilder.setRebalanceRunningTask(true);
        }
        return jobConfigBuilder;
    }

    private void submitJobToHelix(JobConfig.Builder jobConfigBuilder) throws Exception {
        WorkflowConfig workflowConfig = TaskDriver.getWorkflowConfig((HelixManager)this.helixManager, (String)this.helixQueueName);
        if (workflowConfig != null && workflowConfig.getTargetState() == TargetState.DELETE) {
            GobblinHelixTaskDriver gobblinHelixTaskDriver = new GobblinHelixTaskDriver(this.helixManager);
            gobblinHelixTaskDriver.deleteWorkflow(this.helixQueueName, this.jobQueueDeleteTimeoutSeconds);
            workflowConfig = null;
        }
        if (workflowConfig == null) {
            JobQueue jobQueue = new JobQueue.Builder(this.helixQueueName).build();
            this.helixTaskDriver.createQueue(jobQueue);
            LOGGER.info("Created job queue {}", (Object)this.helixQueueName);
        } else {
            LOGGER.info("Job queue {} already exists", (Object)this.helixQueueName);
        }
        this.helixTaskDriver.enqueueJob(this.jobContext.getJobName(), this.jobContext.getJobId(), jobConfigBuilder);
    }

    public void launchJob(@Nullable JobListener jobListener) throws JobException {
        this.jobListener = jobListener;
        boolean isLaunched = false;
        this.runningMap.putIfAbsent(this.jobContext.getJobName(), false);
        try {
            if (this.runningMap.replace(this.jobContext.getJobName(), false, true)) {
                LOGGER.info("Job {} will be executed, add into running map.", (Object)this.jobContext.getJobId());
                isLaunched = true;
                super.launchJob(jobListener);
            } else {
                LOGGER.warn("Job {} will not be executed because other jobs are still running.", (Object)this.jobContext.getJobId());
            }
        }
        finally {
            if (isLaunched) {
                if (this.runningMap.replace(this.jobContext.getJobName(), true, false)) {
                    LOGGER.info("Job {} is done, remove from running map.", (Object)this.jobContext.getJobId());
                } else {
                    throw new IllegalStateException("A launched job should have running state equal to true in the running map.");
                }
            }
        }
    }

    private void addWorkUnit(WorkUnit workUnit, ParallelRunner stateSerDeRunner, Map<String, TaskConfig> taskConfigMap) throws IOException {
        String workUnitFilePath = this.persistWorkUnit(new Path(this.inputWorkUnitDir, this.jobContext.getJobId()), workUnit, stateSerDeRunner);
        HashMap rawConfigMap = Maps.newHashMap();
        rawConfigMap.put("gobblin.cluster.work.unit.file.path", workUnitFilePath);
        rawConfigMap.put("job.name", this.jobContext.getJobName());
        rawConfigMap.put("job.id", this.jobContext.getJobId());
        rawConfigMap.put("task.id", workUnit.getId());
        rawConfigMap.put("TASK_SUCCESS_OPTIONAL", "true");
        taskConfigMap.put(workUnit.getId(), TaskConfig.Builder.from((Map)rawConfigMap));
    }

    private String persistWorkUnit(Path workUnitFileDir, final WorkUnit workUnit, ParallelRunner stateSerDeRunner) throws IOException {
        StateStore stateStore;
        String workUnitFileName = workUnit.getId();
        if (workUnit instanceof MultiWorkUnit) {
            workUnitFileName = workUnitFileName + ".mwu";
            stateStore = this.stateStores.getMwuStateStore();
        } else {
            workUnitFileName = workUnitFileName + WORK_UNIT_FILE_EXTENSION;
            stateStore = this.stateStores.getWuStateStore();
        }
        Path workUnitFile = new Path(workUnitFileDir, workUnitFileName);
        final String fileName = workUnitFile.getName();
        final String storeName = workUnitFile.getParent().getName();
        stateSerDeRunner.submitCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                stateStore.put(storeName, fileName, (State)workUnit);
                return null;
            }
        }, "Serialize state to store " + storeName + " file " + fileName);
        return workUnitFile.toString();
    }

    private void waitForJobCompletion() throws InterruptedException {
        LOGGER.info("Waiting for job to complete...");
        boolean timeoutEnabled = Boolean.parseBoolean(this.jobProps.getProperty("job.timeout.enabled", "false"));
        long timeoutInSeconds = Long.parseLong(this.jobProps.getProperty("job.timeout.seconds", "10800"));
        long endTime = System.currentTimeMillis() + timeoutInSeconds * 1000L;
        while (!timeoutEnabled || System.currentTimeMillis() <= endTime) {
            TaskState helixJobState;
            WorkflowContext workflowContext = TaskDriver.getWorkflowContext((HelixManager)this.helixManager, (String)this.helixQueueName);
            if (workflowContext != null && ((helixJobState = workflowContext.getJobState(this.jobResourceName)) == TaskState.COMPLETED || helixJobState == TaskState.FAILED || helixJobState == TaskState.STOPPED)) {
                return;
            }
            Thread.sleep(1000L);
        }
        this.helixTaskDriverWaitToStop(this.helixQueueName, 10L);
        try {
            this.cancelJob(this.jobListener);
        }
        catch (JobException e) {
            throw new RuntimeException("Unable to cancel job " + this.jobContext.getJobName() + ": ", e);
        }
        this.helixTaskDriver.resume(this.helixQueueName);
        LOGGER.info("stopped the queue, deleted the job");
    }

    private void helixTaskDriverWaitToStop(String workflow, long timeoutInSeconds) throws InterruptedException {
        this.helixTaskDriver.stop(workflow);
        long endTime = System.currentTimeMillis() + timeoutInSeconds * 1000L;
        while (System.currentTimeMillis() <= endTime) {
            WorkflowContext workflowContext = TaskDriver.getWorkflowContext((HelixManager)this.helixManager, (String)this.helixQueueName);
            if (workflowContext == null || workflowContext.getWorkflowState().equals((Object)TaskState.IN_PROGRESS)) {
                Thread.sleep(1000L);
                continue;
            }
            LOGGER.info("Successfully stopped the queue");
            return;
        }
    }

    private void cleanupWorkingDirectory() throws IOException {
        LOGGER.info("Deleting persisted work units for job " + this.jobContext.getJobId());
        this.stateStores.getWuStateStore().delete(this.jobContext.getJobId());
        this.stateStores.getTaskStateStore().delete(this.outputTaskStateDir.getName());
        LOGGER.info("Deleting job state file for job " + this.jobContext.getJobId());
        if (this.stateStores.haveJobStateStore()) {
            this.stateStores.getJobStateStore().delete(this.jobContext.getJobId());
        } else {
            Path jobStateFilePath = GobblinClusterUtils.getJobStateFilePath(false, this.appWorkDir, this.jobContext.getJobId());
            this.fs.delete(jobStateFilePath, false);
        }
    }

    private static List<? extends Tag<?>> addAdditionalMetadataTags(Properties jobProps, List<? extends Tag<?>> inputTags) {
        String jobId;
        ArrayList metadataTags = Lists.newArrayList(inputTags);
        if (jobProps.containsKey("job.id")) {
            jobId = jobProps.getProperty("job.id");
        } else {
            jobId = JobLauncherUtils.newJobId((String)JobState.getJobNameFromProps((Properties)jobProps));
            jobProps.put("job.id", jobId);
        }
        String jobExecutionId = Long.toString(Id.Job.parse((String)jobId).getSequence());
        if (jobProps.containsKey("flow.name")) {
            metadataTags.add(new Tag("flowGroup", (Object)jobProps.getProperty("flow.group", "")));
            metadataTags.add(new Tag("flowName", (Object)jobProps.getProperty("flow.name")));
            metadataTags.add(new Tag("flowExecutionId", (Object)jobProps.getProperty("flow.executionId", jobExecutionId)));
        }
        metadataTags.add(new Tag("jobGroup", (Object)jobProps.getProperty("job.group", "")));
        metadataTags.add(new Tag("jobName", (Object)jobProps.getProperty("job.name", "")));
        metadataTags.add(new Tag("jobExecutionId", (Object)jobExecutionId));
        LOGGER.debug("GobblinHelixJobLauncher.addAdditionalMetadataTags: metadataTags {}", (Object)metadataTags);
        return metadataTags;
    }
}

