/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.template.AbstractMapTemplate;
import com.linkedin.data.template.DataObjectToObjectCache;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class WrappingMapTemplate<V extends DataTemplate<?>>
extends AbstractMapTemplate<V> {
    protected final Constructor<V> _constructor;
    protected EntrySet _entrySet;
    protected DataObjectToObjectCache<V> _cache;

    protected WrappingMapTemplate(DataMap map, MapDataSchema schema, Class<V> valueClass) throws TemplateOutputCastException {
        super(map, schema, valueClass, DataMap.class);
        this._constructor = DataTemplateUtil.templateConstructor(valueClass, schema.getValues());
        this._cache = new DataObjectToObjectCache(this.data().size());
        this._entrySet = new EntrySet();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null || !(value instanceof DataTemplate)) {
            return false;
        }
        DataTemplate template = (DataTemplate)value;
        return this._map.containsValue(template.data());
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this._entrySet;
    }

    @Override
    public V get(Object key) throws TemplateOutputCastException {
        if (key != null && key.getClass() == String.class) {
            return this.cacheLookup(this._map.get(key), (String)key);
        }
        return null;
    }

    @Override
    public V put(String key, V value) throws ClassCastException, TemplateOutputCastException {
        Object unwrapped = this.unwrap(value);
        Object found = this._map.put(key, unwrapped);
        this._cache.put(unwrapped, value);
        return this.cacheLookup(found, null);
    }

    @Override
    public V remove(Object key) throws TemplateOutputCastException {
        return this.cacheLookup(this._map.remove(key), null);
    }

    @Override
    public WrappingMapTemplate<V> clone() throws CloneNotSupportedException {
        WrappingMapTemplate clone = (WrappingMapTemplate)super.clone();
        clone.initializeClone();
        return clone;
    }

    private void initializeClone() throws CloneNotSupportedException {
        this._cache = this._cache.clone();
        this._entrySet = new EntrySet();
    }

    @Override
    public WrappingMapTemplate<V> copy() throws CloneNotSupportedException {
        WrappingMapTemplate copy = (WrappingMapTemplate)super.copy();
        copy.initializeCopy();
        return copy;
    }

    private void initializeCopy() {
        this._cache = new DataObjectToObjectCache(this.data().size());
        this._entrySet = new EntrySet();
    }

    protected Object unwrap(Object value) throws ClassCastException {
        ArgumentUtil.notNull(value, "value");
        if (value.getClass() == this._valueClass) {
            return ((DataTemplate)value).data();
        }
        throw new ClassCastException("Input " + value + " should be a " + this._valueClass.getName());
    }

    protected V cacheLookup(Object value, String key) throws TemplateOutputCastException {
        DataTemplate<Object> wrapped;
        if (value == null) {
            wrapped = null;
        } else {
            wrapped = (DataTemplate)this._cache.get(value);
            if (wrapped == null || wrapped.data() != value) {
                wrapped = DataTemplateUtil.wrap(value, this._constructor);
                if (key != null) {
                    this._cache.put(value, wrapped);
                }
            }
        }
        return (V)wrapped;
    }

    protected class EntrySet
    extends AbstractMapTemplate.AbstractEntrySet {
        protected EntrySet() {
        }

        @Override
        public boolean add(Map.Entry<String, V> entry) throws ClassCastException {
            DataTemplate value = (DataTemplate)entry.getValue();
            Object unwrapped = WrappingMapTemplate.this.unwrap(value);
            boolean added = WrappingMapTemplate.this._map.entrySet().add(new AbstractMap.SimpleEntry<String, Object>(entry.getKey(), unwrapped));
            if (added) {
                WrappingMapTemplate.this._cache.put(unwrapped, value);
            }
            return added;
        }

        @Override
        public boolean contains(Object entry) {
            Map.Entry<String, Object> unwrappedEntry = this.unwrapEntry(entry);
            if (unwrappedEntry != null) {
                return WrappingMapTemplate.this._map.entrySet().contains(unwrappedEntry);
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            final Iterator it = WrappingMapTemplate.this._map.entrySet().iterator();
            return new Iterator<Map.Entry<String, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<String, V> next() throws TemplateOutputCastException {
                    Map.Entry next = (Map.Entry)it.next();
                    return EntrySet.this.wrapEntry(next);
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        @Override
        public boolean remove(Object entry) {
            Map.Entry<String, Object> unwrappedEntry = this.unwrapEntry(entry);
            return WrappingMapTemplate.this._map.entrySet().remove(unwrappedEntry);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return WrappingMapTemplate.this._map.entrySet().removeAll(this.unwrapCollection(c));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return WrappingMapTemplate.this._map.entrySet().retainAll(this.unwrapCollection(c));
        }

        protected Map.Entry<String, Object> unwrapEntry(Object entry) {
            Map.Entry mapEntry;
            Object key;
            if (entry instanceof Map.Entry && (key = (mapEntry = (Map.Entry)entry).getKey()) != null && key.getClass() == String.class) {
                Object value = mapEntry.getValue();
                if (value == null || value.getClass() != WrappingMapTemplate.this._valueClass) {
                    return null;
                }
                Object unwrapped = ((DataTemplate)WrappingMapTemplate.this._valueClass.cast(value)).data();
                assert (unwrapped != value);
                return new AbstractMap.SimpleImmutableEntry<String, Object>((String)key, unwrapped);
            }
            return null;
        }

        protected Collection<Map.Entry<String, Object>> unwrapCollection(Collection<?> c) {
            ArrayList<Map.Entry<String, Object>> unwrappedList = new ArrayList<Map.Entry<String, Object>>(c.size());
            for (Object entry : c) {
                Map.Entry<String, Object> unwrappedEntry = this.unwrapEntry(entry);
                if (unwrappedEntry == null) continue;
                unwrappedList.add(unwrappedEntry);
            }
            return unwrappedList;
        }

        protected Map.Entry<String, V> wrapEntry(final Map.Entry<String, Object> entry) throws TemplateOutputCastException {
            return new AbstractMapTemplate.WrappingMapEntry<V>(entry){

                @Override
                public V getValue() throws TemplateOutputCastException {
                    if (this._value == null) {
                        this._value = WrappingMapTemplate.this.cacheLookup(entry.getValue(), this.getKey());
                    }
                    return (DataTemplate)this._value;
                }

                @Override
                public V setValue(V value) throws ClassCastException, TemplateOutputCastException {
                    Object unwrapped = WrappingMapTemplate.this.unwrap(value);
                    Object ret = this._entry.setValue(unwrapped);
                    WrappingMapTemplate.this._cache.put(unwrapped, value);
                    this._value = null;
                    return WrappingMapTemplate.this.cacheLookup(ret, null);
                }
            };
        }
    }
}

