/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.FieldDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DynamicRecordMetadata {
    private final Map<String, FieldDef<?>> _fieldDefMap = new HashMap();
    private final RecordDataSchema _recordDataSchema;

    public DynamicRecordMetadata(String name, Collection<? extends FieldDef<?>> fieldDefs) {
        this._recordDataSchema = DynamicRecordMetadata.buildSchema(name, fieldDefs);
        for (FieldDef<?> fieldDef : fieldDefs) {
            this._fieldDefMap.put(fieldDef.getName(), fieldDef);
        }
    }

    public static RecordDataSchema buildSchema(String name, Collection<? extends FieldDef<?>> fieldDefs) {
        StringBuilder errorMessageBuilder = new StringBuilder();
        RecordDataSchema schema = new RecordDataSchema(new Name(name, errorMessageBuilder), RecordDataSchema.RecordType.RECORD);
        ArrayList<RecordDataSchema.Field> fields = new ArrayList<RecordDataSchema.Field>(fieldDefs.size());
        for (FieldDef<?> fieldDef : fieldDefs) {
            RecordDataSchema.Field paramField = fieldDef.getField();
            if (paramField.getRecord() != null) {
                throw new IllegalArgumentException("Attempt to assign field " + fieldDef.getName() + " to record " + schema.getName() + "failed: Record of field is already set to " + paramField.getRecord().getName());
            }
            paramField.setRecord(schema);
            fields.add(paramField);
        }
        schema.setFields(fields, errorMessageBuilder);
        return schema;
    }

    public RecordDataSchema getRecordDataSchema() {
        return this._recordDataSchema;
    }

    public FieldDef<?> getFieldDef(String name) {
        return this._fieldDefMap.get(name);
    }
}

