/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.validation;

import com.linkedin.data.it.Predicate;
import com.linkedin.data.it.Predicates;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.UnrecognizedFieldMode;
import com.linkedin.util.ArgumentUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ValidationOptions {
    private CoercionMode _coercionMode;
    private RequiredMode _requiredMode;
    private UnrecognizedFieldMode _unrecognizedFieldMode;
    private boolean _avroUnionMode = false;
    private Map<String, Object> _validatorParameters = NO_VALIDATOR_PARAMETERS;
    private Predicate _treatOptional = Predicates.alwaysFalse();
    private static final Map<String, Object> NO_VALIDATOR_PARAMETERS = Collections.emptyMap();

    public ValidationOptions() {
        this._coercionMode = CoercionMode.NORMAL;
        this._requiredMode = RequiredMode.CAN_BE_ABSENT_IF_HAS_DEFAULT;
        this._unrecognizedFieldMode = UnrecognizedFieldMode.IGNORE;
    }

    public ValidationOptions(RequiredMode requiredMode) {
        this._coercionMode = CoercionMode.NORMAL;
        this._requiredMode = requiredMode;
        this._unrecognizedFieldMode = UnrecognizedFieldMode.IGNORE;
    }

    public ValidationOptions(RequiredMode requiredMode, CoercionMode coercionMode) {
        this._coercionMode = coercionMode;
        this._requiredMode = requiredMode;
        this._unrecognizedFieldMode = UnrecognizedFieldMode.IGNORE;
    }

    public ValidationOptions(RequiredMode requiredMode, CoercionMode coercionMode, UnrecognizedFieldMode unrecognizedFieldMode) {
        this._coercionMode = coercionMode;
        this._requiredMode = requiredMode;
        this._unrecognizedFieldMode = unrecognizedFieldMode;
    }

    public void setCoercionMode(CoercionMode coercionMode) {
        ArgumentUtil.notNull((Object)coercionMode, "coercionMode");
        this._coercionMode = coercionMode;
    }

    public CoercionMode getCoercionMode() {
        return this._coercionMode;
    }

    public RequiredMode getRequiredMode() {
        return this._requiredMode;
    }

    public void setRequiredMode(RequiredMode requiredMode) {
        ArgumentUtil.notNull((Object)requiredMode, "RequiredMode");
        this._requiredMode = requiredMode;
    }

    public UnrecognizedFieldMode getUnrecognizedFieldMode() {
        return this._unrecognizedFieldMode;
    }

    public void setUnrecognizedFieldMode(UnrecognizedFieldMode unrecognizedFieldMode) {
        this._unrecognizedFieldMode = unrecognizedFieldMode;
    }

    public void setValidatorParameter(String key, Object parameter) {
        if (this._validatorParameters == NO_VALIDATOR_PARAMETERS) {
            this._validatorParameters = new HashMap<String, Object>();
        }
        this._validatorParameters.put(key, parameter);
    }

    public Object getValidatorParameter(String key) {
        return this._validatorParameters.get(key);
    }

    public void setTreatOptional(Predicate treatOptional) {
        this._treatOptional = treatOptional;
    }

    public Predicate getTreatOptional() {
        return this._treatOptional;
    }

    public void setAvroUnionMode(boolean value) {
        this._avroUnionMode = value;
    }

    public boolean isAvroUnionMode() {
        return this._avroUnionMode;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        ValidationOptions otherOptions = (ValidationOptions)other;
        return otherOptions._coercionMode == this._coercionMode && otherOptions._requiredMode == this._requiredMode && otherOptions._unrecognizedFieldMode == this._unrecognizedFieldMode && otherOptions._avroUnionMode == this._avroUnionMode && otherOptions._validatorParameters.equals(this._validatorParameters);
    }

    public int hashCode() {
        int code = 17;
        code = code * 31 + (this._requiredMode == null ? 0 : this._requiredMode.hashCode());
        code = code * 31 + (this._coercionMode == null ? 0 : this._coercionMode.hashCode());
        code = code * 31 + (this._unrecognizedFieldMode == null ? 0 : this._unrecognizedFieldMode.hashCode());
        code = code * 31 + (this._avroUnionMode ? 0 : 53);
        code = code * 31 + this._validatorParameters.hashCode();
        return code;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequiredMode=").append((Object)this._requiredMode).append(", FixupMode=").append((Object)this._coercionMode).append(", UnrecognizedFieldMode=").append((Object)this._unrecognizedFieldMode).append(", AvroUnionMode=").append(this._avroUnionMode);
        if (this._validatorParameters != NO_VALIDATOR_PARAMETERS) {
            sb.append(", ValidatorOptions=").append(this._validatorParameters);
        }
        return sb.toString();
    }
}

