/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.resolver;

import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.resolver.InputStreamProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class InJarFileDataSchemaLocation
implements DataSchemaLocation,
InputStreamProvider {
    private final JarFile _jarFile;
    private final String _pathInJar;

    public InJarFileDataSchemaLocation(JarFile jarFile, String pathInJar) {
        this._jarFile = jarFile;
        this._pathInJar = pathInJar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InJarFileDataSchemaLocation)) {
            return false;
        }
        InJarFileDataSchemaLocation other = (InJarFileDataSchemaLocation)o;
        return this._jarFile.getName().equals(other._jarFile.getName()) && this._pathInJar.equals(other._pathInJar);
    }

    public int hashCode() {
        return this._jarFile.getName().hashCode() ^ this._pathInJar.hashCode();
    }

    public String toString() {
        return this.getSourceFile().getPath() + ":" + this._pathInJar;
    }

    @Override
    public File getSourceFile() {
        return new File(this._jarFile.getName());
    }

    @Override
    public InputStream asInputStream(StringBuilder errorMessageBuilder) {
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry = this._jarFile.getEntry(this._pathInJar);
            if (zipEntry != null) {
                inputStream = this._jarFile.getInputStream(zipEntry);
            }
        }
        catch (IOException exc) {
            errorMessageBuilder.append(this._pathInJar).append(" not found in ").append(this.getSourceFile().toString()).append("\n");
        }
        return inputStream;
    }
}

