/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.resolver;

import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.resolver.AbstractDataSchemaResolver;
import com.linkedin.data.schema.resolver.FileDataSchemaLocation;
import com.linkedin.data.schema.resolver.InJarFileDataSchemaLocation;
import com.linkedin.data.schema.resolver.InputStreamProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;

public class FileDataSchemaResolver
extends AbstractDataSchemaResolver {
    public static final String DEFAULT_PATH_SEPARATOR = File.pathSeparator;
    public static final String DEFAULT_EXTENSION = ".pdsc";
    private List<String> _paths = _emptyPaths;
    private String _extension = ".pdsc";
    private final Map<String, JarFile> _pathToJarFile = new HashMap<String, JarFile>();
    private static final List<String> _emptyPaths = Collections.emptyList();
    private static final String JAR_EXTENSION = ".jar";
    private static final String DIR_IN_JAR = "pegasus";

    public FileDataSchemaResolver(DataSchemaParserFactory parserFactory) {
        super(parserFactory);
    }

    public FileDataSchemaResolver(DataSchemaParserFactory parserFactory, DataSchemaResolver dependencyResolver) {
        super(parserFactory, dependencyResolver);
    }

    public FileDataSchemaResolver(DataSchemaParserFactory parserFactory, String paths) {
        this(parserFactory);
        this.setPaths(paths);
    }

    public FileDataSchemaResolver(DataSchemaParserFactory parserFactory, String paths, DataSchemaResolver dependencyResolver) {
        this(parserFactory, dependencyResolver);
        this.setPaths(paths);
    }

    public FileDataSchemaResolver(DataSchemaParserFactory parserFactory, List<String> paths) {
        this(parserFactory);
        this.setPaths(paths);
    }

    public void setPaths(String paths) {
        this.setPaths(paths, DEFAULT_PATH_SEPARATOR);
    }

    public void setPaths(String paths, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (paths != null) {
            StringTokenizer tokenizer = new StringTokenizer(paths, separator);
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        this.setPaths(list);
    }

    public void setPaths(List<String> paths) {
        this._paths = paths;
    }

    public List<String> getPaths() {
        return this._paths;
    }

    public void setExtension(String extension) {
        this._extension = extension;
    }

    public String getExtension() {
        return this._extension;
    }

    @Override
    protected Iterator<DataSchemaLocation> possibleLocations(String name) {
        name = name.replace('.', File.separatorChar);
        if (!this._extension.isEmpty()) {
            name = name + this._extension;
        }
        final String transformedName = name;
        return new AbstractDataSchemaResolver.AbstractIterator(this._paths){

            @Override
            protected DataSchemaLocation transform(String path) {
                boolean isJar = path.endsWith(FileDataSchemaResolver.JAR_EXTENSION);
                if (isJar) {
                    JarFile jarFile = (JarFile)FileDataSchemaResolver.this._pathToJarFile.get(path);
                    if (jarFile == null) {
                        try {
                            jarFile = new JarFile(path);
                        }
                        catch (IOException exc) {
                            FileDataSchemaResolver.this._pathToJarFile.put(path, null);
                            return null;
                        }
                    }
                    StringBuilder builder = new StringBuilder();
                    builder.append(FileDataSchemaResolver.DIR_IN_JAR).append('/').append(transformedName.replace(File.separatorChar, '/'));
                    return new InJarFileDataSchemaLocation(jarFile, builder.toString());
                }
                StringBuilder builder = new StringBuilder();
                builder.append(path);
                if (path.length() > 0 && path.charAt(path.length() - 1) != File.separatorChar) {
                    builder.append(File.separatorChar);
                }
                builder.append(transformedName);
                return new FileDataSchemaLocation(new File(builder.toString()));
            }
        };
    }

    @Override
    protected InputStream locationToInputStream(DataSchemaLocation location, StringBuilder errorMessageBuilder) {
        InputStream inputStream = ((InputStreamProvider)((Object)location)).asInputStream(errorMessageBuilder);
        return inputStream;
    }
}

