/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.resolver;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDataSchemaResolver
implements DataSchemaResolver {
    private final DataSchemaResolver _dependencyResolver;
    private final Map<String, NamedDataSchema> _nameToDataSchema = new HashMap<String, NamedDataSchema>();
    private final Map<String, DataSchemaLocation> _nameToDataSchemaLocations = new HashMap<String, DataSchemaLocation>();
    private final DataSchemaParserFactory _parserFactory;
    private final Set<DataSchemaLocation> _badLocations = new HashSet<DataSchemaLocation>();
    private final Set<DataSchemaLocation> _resolvedLocations = new HashSet<DataSchemaLocation>();
    protected static final PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.out));

    protected abstract Iterator<DataSchemaLocation> possibleLocations(String var1);

    protected abstract InputStream locationToInputStream(DataSchemaLocation var1, StringBuilder var2);

    protected AbstractDataSchemaResolver(DataSchemaParserFactory parserFactory, DataSchemaResolver dependencyResolver) {
        this._parserFactory = parserFactory;
        this._dependencyResolver = dependencyResolver;
    }

    protected AbstractDataSchemaResolver(DataSchemaParserFactory parserFactory) {
        this._parserFactory = parserFactory;
        this._dependencyResolver = this;
    }

    protected boolean isBadLocation(DataSchemaLocation location) {
        return this._badLocations.contains(location);
    }

    protected boolean addBadLocation(DataSchemaLocation location) {
        return this._badLocations.add(location);
    }

    @Override
    public Map<String, NamedDataSchema> bindings() {
        return Collections.unmodifiableMap(this._nameToDataSchema);
    }

    @Override
    public Map<String, DataSchemaLocation> nameToDataSchemaLocations() {
        return Collections.unmodifiableMap(this._nameToDataSchemaLocations);
    }

    @Override
    public NamedDataSchema findDataSchema(String name, StringBuilder errorMessageBuilder) {
        NamedDataSchema found = this.existingDataSchema(name);
        if (found == null) {
            found = this.locateDataSchema(name, errorMessageBuilder);
        }
        return found;
    }

    @Override
    public NamedDataSchema existingDataSchema(String name) {
        NamedDataSchema found = this._nameToDataSchema.get(name);
        return found;
    }

    @Override
    public void bindNameToSchema(Name name, NamedDataSchema schema, DataSchemaLocation location) {
        String fullName = name.getFullName();
        NamedDataSchema replaced = this._nameToDataSchema.put(fullName, schema);
        if (replaced != null) {
            throw new IllegalStateException(fullName + " cannot be refined from " + replaced + " to " + schema);
        }
        this._nameToDataSchemaLocations.put(fullName, location);
        this._resolvedLocations.add(location);
    }

    @Override
    public boolean locationResolved(DataSchemaLocation location) {
        return this._resolvedLocations.contains(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedDataSchema locateDataSchema(String name, StringBuilder errorMessageBuilder) {
        NamedDataSchema schema = null;
        Iterator<DataSchemaLocation> locations = this.possibleLocations(name);
        while (locations.hasNext()) {
            DataSchemaLocation location = locations.next();
            if (location == null || this.isBadLocation(location)) continue;
            InputStream inputStream = null;
            try {
                inputStream = this.locationToInputStream(location, errorMessageBuilder);
                if (inputStream == null) {
                    this.addBadLocation(location);
                    continue;
                }
                schema = this.parse(inputStream, location, name, errorMessageBuilder);
                if (schema == null) continue;
                break;
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return schema;
    }

    protected NamedDataSchema parse(InputStream inputStream, final DataSchemaLocation location, String name, StringBuilder errorMessageBuilder) {
        NamedDataSchema schema = null;
        PegasusSchemaParser parser = this._parserFactory.create(this._dependencyResolver);
        parser.setLocation(location);
        parser.parse(new FilterInputStream(inputStream){

            public String toString() {
                return location.toString();
            }
        });
        if (parser.hasError()) {
            errorMessageBuilder.append("Error parsing ").append(location).append(" for \"").append(name).append("\".\n");
            errorMessageBuilder.append((CharSequence)parser.errorMessageBuilder());
            errorMessageBuilder.append("Done parsing ").append(location).append(".\n");
            this._badLocations.add(location);
        } else {
            DataSchema found = this._nameToDataSchema.get(name);
            if (found != null && found instanceof NamedDataSchema) {
                schema = (NamedDataSchema)found;
            }
        }
        return schema;
    }

    public static abstract class AbstractIterator
    implements Iterator<DataSchemaLocation> {
        private final Iterator<String> _it;

        protected abstract DataSchemaLocation transform(String var1);

        protected AbstractIterator(Iterable<String> iterable) {
            this._it = iterable.iterator();
        }

        protected AbstractIterator(Iterator<String> it) {
            this._it = it;
        }

        @Override
        public boolean hasNext() {
            return this._it.hasNext();
        }

        @Override
        public DataSchemaLocation next() {
            return this.transform(this._it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

