/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.DataLocation;
import com.linkedin.data.schema.AbstractSchemaParser;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.resolver.DefaultDataSchemaResolver;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaParser
extends AbstractSchemaParser {
    public static final String FILETYPE = "pdsc";
    public static final String FILE_EXTENSION = ".pdsc";
    private StringBuilder _errorMessageBuilder = new StringBuilder();

    public SchemaParser() {
        this(null);
    }

    public SchemaParser(DataSchemaResolver resolver) {
        super(resolver == null ? new DefaultDataSchemaResolver() : resolver);
    }

    @Override
    public String schemasToString() {
        return SchemaToJsonEncoder.schemasToJson(this.topLevelDataSchemas(), JsonBuilder.Pretty.SPACES);
    }

    @Override
    public void parse(InputStream inputStream) {
        List<Object> objects = this.jsonInputStreamToObjects(inputStream);
        this.parse(objects);
    }

    @Override
    public void parse(Reader reader) {
        List<Object> objects = this.jsonReaderToObjects(reader);
        this.parse(objects);
    }

    @Override
    public void parse(String json) {
        this.parse(new StringReader(json));
    }

    public void parse(List<Object> list) {
        for (Object o : list) {
            DataSchema schema = this.parseObject(o);
            if (schema == null) continue;
            this.addTopLevelSchema(schema);
        }
    }

    public DataSchema parseObject(Object object) {
        DataSchema schema = null;
        if (object instanceof String) {
            schema = this.stringToDataSchema((String)object);
        } else if (object instanceof DataList) {
            schema = this.dataListToDataSchema((DataList)object);
        } else if (object instanceof DataMap) {
            schema = this.dataMapToDataSchema((DataMap)object);
        } else {
            this.startErrorMessage(object).append(object).append(" is not a type.\n");
        }
        return schema;
    }

    public List<RecordDataSchema.Field> parseFields(RecordDataSchema recordSchema, DataList list) {
        ArrayList<RecordDataSchema.Field> fields = new ArrayList<RecordDataSchema.Field>();
        for (Object o : list) {
            boolean ok = true;
            if (o instanceof DataMap) {
                DataMap fieldMap = (DataMap)o;
                String name = this.getString(fieldMap, "name", true);
                DataSchema type = this.getSchemaData(fieldMap, "type");
                String doc = this.getString(fieldMap, "doc", false);
                Boolean optional = this.getBoolean(fieldMap, "optional", false);
                RecordDataSchema.Field.Order sortOrder = null;
                String order = this.getString(fieldMap, "order", false);
                if (order != null) {
                    try {
                        sortOrder = RecordDataSchema.Field.Order.valueOf(order.toUpperCase());
                    }
                    catch (IllegalArgumentException exc) {
                        this.startErrorMessage(order).append("\"").append(order).append("\" is an invalid sort order.\n");
                    }
                }
                Map<String, Object> properties = this.extractProperties(fieldMap, DataSchemaConstants.FIELD_KEYS);
                List<String> aliases = this.getStringList(fieldMap, "aliases", false);
                if (name != null && type != null) {
                    RecordDataSchema.Field field = new RecordDataSchema.Field(type);
                    field.setDeclaredInline(SchemaParser.isDeclaredInline(fieldMap.get("type")));
                    field.setDefault(fieldMap.get("default"));
                    if (doc != null) {
                        field.setDoc(doc);
                    }
                    field.setName(name, this.startCalleeMessageBuilder());
                    this.appendCalleeMessage(fieldMap);
                    if (aliases != null) {
                        field.setAliases(aliases, this.startCalleeMessageBuilder());
                        this.appendCalleeMessage(fieldMap);
                    }
                    if (optional != null) {
                        field.setOptional(optional);
                    }
                    if (sortOrder != null) {
                        field.setOrder(sortOrder);
                    }
                    field.setProperties(properties);
                    field.setRecord(recordSchema);
                    fields.add(field);
                } else {
                    ok = false;
                }
            } else {
                ok = false;
            }
            if (ok) continue;
            this.startErrorMessage(o).append(o).append(" is not a valid field.\n");
        }
        return fields;
    }

    public UnionDataSchema parseUnion(DataList list) {
        return this.dataListToDataSchema(list);
    }

    protected UnionDataSchema dataListToDataSchema(DataList list) {
        ArrayList<DataSchema> types = new ArrayList<DataSchema>();
        HashSet<DataSchema> typesDeclaredInline = new HashSet<DataSchema>(0);
        for (Object o : list) {
            DataSchema type = this.parseObject(o);
            if (type == null) continue;
            types.add(type);
            if (!SchemaParser.isDeclaredInline(o)) continue;
            typesDeclaredInline.add(type);
        }
        UnionDataSchema schema = new UnionDataSchema();
        schema.setTypes(types, this.startCalleeMessageBuilder());
        schema.setTypesDeclaredInline(typesDeclaredInline);
        this.appendCalleeMessage(list);
        return schema;
    }

    protected DataSchema dataMapToDataSchema(DataMap map) {
        DataSchema.Type type = this.getType(map);
        if (type == null) {
            return null;
        }
        PrimitiveDataSchema primitiveSchema = DataSchemaUtil.dataSchemaTypeToPrimitiveDataSchema(type);
        if (primitiveSchema != null) {
            return primitiveSchema;
        }
        ComplexDataSchema schema = null;
        NamedDataSchema namedSchema = null;
        String saveCurrentNamespace = this.getCurrentNamespace();
        String saveCurrentPackage = this.getCurrentPackage();
        Name name = null;
        String packageName = null;
        List<Name> aliasNames = null;
        if (DataSchemaConstants.NAMED_DATA_SCHEMA_TYPE_SET.contains((Object)type)) {
            name = this.getNameFromDataMap(map, "name", saveCurrentNamespace);
            packageName = this.getPackageFromDataMap(map, "package", saveCurrentPackage, saveCurrentNamespace, name);
            this.setCurrentNamespace(name.getNamespace());
            this.setCurrentPackage(packageName);
            aliasNames = this.getAliases(map);
        } else {
            Object found = map.get("name");
            if (found != null) {
                this.startErrorMessage(map).append((Object)type).append(" must not have name.\n");
            }
            if ((found = map.get("namespace")) != null) {
                this.startErrorMessage(map).append((Object)type).append(" must not have namespace.\n");
            }
            if ((found = map.get("aliases")) != null) {
                this.startErrorMessage(map).append((Object)type).append(" must not have aliases.\n");
            }
        }
        switch (type) {
            case ARRAY: {
                DataSchema itemsSchema = this.getSchemaData(map, "items");
                ArrayDataSchema arraySchema = new ArrayDataSchema(itemsSchema);
                arraySchema.setItemsDeclaredInline(SchemaParser.isDeclaredInline(map.get("items")));
                schema = arraySchema;
                break;
            }
            case ENUM: {
                List<String> symbols = this.getStringList(map, "symbols", true);
                DataMap symbolDocsMap = this.getDataMap(map, "symbolDocs", false);
                EnumDataSchema enumSchema = new EnumDataSchema(name);
                namedSchema = enumSchema;
                schema = namedSchema;
                this.bindNameToSchema(name, aliasNames, enumSchema);
                StringBuilder messageBuilder = this.startCalleeMessageBuilder();
                enumSchema.setSymbols(symbols, messageBuilder);
                if (symbolDocsMap != null) {
                    Map<String, Object> symbolDocs = this.extractProperties(symbolDocsMap, Collections.emptySet());
                    enumSchema.setSymbolDocs(symbolDocs, messageBuilder);
                }
                this.appendCalleeMessage(map);
                break;
            }
            case FIXED: {
                Integer size = this.getInteger(map, "size", true);
                FixedDataSchema fixedSchema = new FixedDataSchema(name);
                namedSchema = fixedSchema;
                schema = namedSchema;
                this.bindNameToSchema(name, aliasNames, fixedSchema);
                fixedSchema.setSize(size, this.startCalleeMessageBuilder());
                this.appendCalleeMessage(size);
                break;
            }
            case MAP: {
                DataSchema valuesSchema = this.getSchemaData(map, "values");
                MapDataSchema mapSchema = new MapDataSchema(valuesSchema);
                mapSchema.setValuesDeclaredInline(SchemaParser.isDeclaredInline(map.get("values")));
                schema = mapSchema;
                break;
            }
            case RECORD: {
                String typeUpper = ((String)map.get("type")).toUpperCase();
                RecordDataSchema.RecordType recordType = RecordDataSchema.RecordType.valueOf(typeUpper);
                RecordDataSchema recordSchema = new RecordDataSchema(name, recordType);
                namedSchema = recordSchema;
                schema = namedSchema;
                this.bindNameToSchema(name, aliasNames, recordSchema);
                ArrayList<RecordDataSchema.Field> fields = new ArrayList<RecordDataSchema.Field>();
                DataList includeList = this.getDataList(map, "include", false);
                DataList fieldsList = this.getDataList(map, "fields", true);
                boolean fieldsBeforeInclude = this.fieldsBeforeIncludes(includeList, fieldsList);
                if (fieldsBeforeInclude) {
                    fields.addAll(this.parseFields(recordSchema, fieldsList));
                    fields.addAll(this.parseInclude(recordSchema, includeList));
                } else {
                    fields.addAll(this.parseInclude(recordSchema, includeList));
                    fields.addAll(this.parseFields(recordSchema, fieldsList));
                }
                recordSchema.setFields(fields, this.startCalleeMessageBuilder());
                this.appendCalleeMessage(fieldsList);
                this.validateDefaults(recordSchema);
                break;
            }
            case TYPEREF: {
                TyperefDataSchema typerefSchema = new TyperefDataSchema(name);
                namedSchema = typerefSchema;
                schema = namedSchema;
                DataSchema referencedTypeSchema = this.getSchemaData(map, "ref");
                typerefSchema.setReferencedType(referencedTypeSchema);
                typerefSchema.setRefDeclaredInline(SchemaParser.isDeclaredInline(map.get("ref")));
                this.bindNameToSchema(name, aliasNames, typerefSchema);
                break;
            }
            default: {
                this.startErrorMessage(map).append((Object)type).append(" is not expected within ").append(map).append(".\n");
            }
        }
        if (namedSchema != null) {
            String doc = this.getString(map, "doc", false);
            if (doc != null) {
                namedSchema.setDoc(doc);
            }
            if (packageName != null) {
                namedSchema.setPackage(packageName);
            }
            if (aliasNames != null) {
                namedSchema.setAliases(aliasNames);
            }
        }
        if (schema != null) {
            Map<String, Object> properties = this.extractProperties(map, DataSchemaConstants.SCHEMA_KEYS);
            schema.setProperties(properties);
        }
        this.setCurrentNamespace(saveCurrentNamespace);
        this.setCurrentPackage(saveCurrentPackage);
        return schema;
    }

    private List<RecordDataSchema.Field> parseInclude(RecordDataSchema recordSchema, DataList includeList) {
        List<RecordDataSchema.Field> fields = Collections.emptyList();
        if (includeList != null && !includeList.isEmpty()) {
            fields = new ArrayList<RecordDataSchema.Field>();
            ArrayList<NamedDataSchema> include = new ArrayList<NamedDataSchema>(includeList.size());
            for (Object anInclude : includeList) {
                DataSchema includedSchema = this.parseObject(anInclude);
                if (includedSchema == null) {
                    assert (this.errorMessageBuilder().length() > 0);
                    continue;
                }
                if (includedSchema.getDereferencedType() != DataSchema.Type.RECORD) {
                    this.startErrorMessage(anInclude).append("\"").append(recordSchema.getFullName()).append("\" cannot include ").append(includedSchema).append(" because it is not a record.\n");
                    continue;
                }
                NamedDataSchema includedNamed = (NamedDataSchema)includedSchema;
                include.add(includedNamed);
                RecordDataSchema includedRecord = (RecordDataSchema)includedSchema.getDereferencedDataSchema();
                fields.addAll(includedRecord.getFields());
            }
            recordSchema.setInclude(include);
        }
        return fields;
    }

    private boolean fieldsBeforeIncludes(DataList includeList, DataList fieldsList) {
        boolean fieldsFirst;
        if (includeList == null || fieldsList == null) {
            fieldsFirst = false;
        } else {
            DataLocation includeListLocation = this.lookupDataLocation(includeList);
            DataLocation fieldsListLocation = this.lookupDataLocation(fieldsList);
            fieldsFirst = fieldsListLocation != null && includeListLocation != null && includeListLocation.compareTo(fieldsListLocation) > 0 ? true : this.fieldsBeforeIncludeWithoutLocation(includeList, fieldsList);
        }
        return fieldsFirst;
    }

    private boolean fieldsBeforeIncludeWithoutLocation(DataList includeList, DataList fieldsList) {
        boolean fieldsFirst;
        assert (includeList != null);
        assert (fieldsList != null);
        StringBuilder saveErrorMessageBuilder = this._errorMessageBuilder;
        DefinedAndReferencedNames includeNames = new DefinedAndReferencedNames().execute(includeList);
        DefinedAndReferencedNames fieldsNames = new DefinedAndReferencedNames().execute(fieldsList);
        boolean includeReferenceFields = includeNames.references(fieldsNames);
        boolean fieldsReferenceInclude = fieldsNames.references(includeNames);
        this._errorMessageBuilder = saveErrorMessageBuilder;
        if (includeReferenceFields && fieldsReferenceInclude) {
            this.startErrorMessage(includeList).append("Cannot determine whether include is before fields without location, include is assumed to be before fields");
            fieldsFirst = false;
        } else {
            fieldsFirst = includeReferenceFields;
        }
        return fieldsFirst;
    }

    protected List<Name> getAliases(DataMap map) {
        List<String> aliases = this.getStringList(map, "aliases", false);
        ArrayList<Name> aliasNames = null;
        if (aliases != null) {
            aliasNames = new ArrayList<Name>(aliases.size());
            for (String alias : aliases) {
                Name name = null;
                if (alias.contains(".")) {
                    name = new Name(alias, this.startCalleeMessageBuilder());
                    this.appendCalleeMessage(map);
                } else {
                    name = new Name(alias, this.getCurrentNamespace(), this.startCalleeMessageBuilder());
                    this.appendCalleeMessage(map);
                }
                if (name == null) continue;
                aliasNames.add(name);
                this.addToDataLocationMap(name, this.lookupDataLocation(alias));
            }
        }
        return aliasNames;
    }

    protected DataSchema getSchemaData(DataMap map, String key) {
        DataSchema schema = DataSchemaConstants.NULL_DATA_SCHEMA;
        Object obj = map.get(key);
        if (obj != null) {
            schema = this.parseObject(obj);
        } else {
            this.startErrorMessage(map).append(key).append(" is required but it is not present.\n");
        }
        return schema;
    }

    protected DataSchema.Type getType(DataMap map) {
        DataSchema.Type type = null;
        String s = this.getString(map, "type", true);
        if (s != null) {
            DataSchema.Type found = DataSchemaUtil.typeStringToComplexDataSchemaType(s);
            if (found != null) {
                type = found;
            } else {
                PrimitiveDataSchema primitiveDataSchema = DataSchemaUtil.typeStringToPrimitiveDataSchema(s);
                if (primitiveDataSchema != null) {
                    type = primitiveDataSchema.getType();
                } else {
                    this.startErrorMessage(map).append("\"").append(s).append("\" is an invalid type.\n");
                }
            }
        }
        return type;
    }

    private static boolean isDeclaredInline(Object type) {
        return type instanceof DataComplex;
    }

    @Override
    public StringBuilder errorMessageBuilder() {
        return this._errorMessageBuilder;
    }

    private class DefinedAndReferencedNames {
        private final StringBuilder _stringBuilder = new StringBuilder();
        private final Set<Name> _defines = new HashSet<Name>();
        private final Set<Name> _references = new HashSet<Name>();

        private DefinedAndReferencedNames() {
        }

        private DefinedAndReferencedNames execute(DataList list) {
            StringBuilder saveErrorMessageBuilder = SchemaParser.this._errorMessageBuilder;
            SchemaParser.this._errorMessageBuilder = this._stringBuilder;
            this.parseList(list);
            SchemaParser.this._errorMessageBuilder = saveErrorMessageBuilder;
            return this;
        }

        private boolean references(DefinedAndReferencedNames other) {
            for (Name ref : this._references) {
                if (!other._defines.contains(ref)) continue;
                return true;
            }
            return false;
        }

        private void parseObject(Object object) {
            if (object == null) {
                return;
            }
            Class<?> objectClass = object.getClass();
            if (objectClass == String.class) {
                String text = (String)object;
                PrimitiveDataSchema primitiveSchema = DataSchemaUtil.typeStringToPrimitiveDataSchema(text);
                if (primitiveSchema == null) {
                    Name name = new Name(text, SchemaParser.this.getCurrentNamespace(), SchemaParser.this.errorMessageBuilder());
                    this._references.add(name);
                }
            } else if (objectClass == DataList.class) {
                this.parseList((DataList)object);
            } else if (objectClass == DataMap.class) {
                this.parseMap((DataMap)object);
            }
        }

        private void parseList(DataList list) {
            for (Object o : list) {
                this.parseObject(o);
            }
        }

        private void parseMap(DataMap map) {
            Object typeValue = map.get("type");
            if (typeValue != null) {
                Class<?> typeClass = typeValue.getClass();
                if (typeClass == DataMap.class) {
                    this.parseObject(typeValue);
                } else if (typeClass == DataList.class) {
                    this.parseList((DataList)typeValue);
                } else if (typeClass == String.class) {
                    String typeString = (String)typeValue;
                    DataSchema.Type type = DataSchemaUtil.typeStringToComplexDataSchemaType(typeString);
                    if (type == null) {
                        this.parseObject(typeString);
                    } else {
                        this.parseComplex(map, type);
                    }
                }
            }
        }

        private void parseComplex(DataMap map, DataSchema.Type type) {
            String saveCurrentNamespace = SchemaParser.this.getCurrentNamespace();
            if (DataSchemaConstants.NAMED_DATA_SCHEMA_TYPE_SET.contains((Object)type)) {
                Name name = SchemaParser.this.getNameFromDataMap(map, "name", saveCurrentNamespace);
                this._defines.add(name);
                SchemaParser.this.setCurrentNamespace(name.getNamespace());
                List<Name> aliasNames = SchemaParser.this.getAliases(map);
                if (aliasNames != null) {
                    this._defines.addAll(aliasNames);
                }
            }
            switch (type) {
                case ARRAY: {
                    Object items = map.get("items");
                    this.parseObject(items);
                    break;
                }
                case MAP: {
                    Object values = map.get("values");
                    this.parseObject(values);
                    break;
                }
                case TYPEREF: {
                    Object ref = map.get("ref");
                    this.parseObject(ref);
                    break;
                }
                case RECORD: {
                    DataList fieldsList;
                    DataList includeList = SchemaParser.this.getDataList(map, "include", false);
                    if (includeList != null) {
                        this.parseList(includeList);
                    }
                    if ((fieldsList = SchemaParser.this.getDataList(map, "fields", true)) == null) break;
                    for (Object o : fieldsList) {
                        if (o.getClass() != DataMap.class) continue;
                        DataMap fieldMap = (DataMap)o;
                        Object fieldType = fieldMap.get("type");
                        this.parseObject(fieldType);
                    }
                    break;
                }
            }
            SchemaParser.this.setCurrentNamespace(saveCurrentNamespace);
        }

        public String toString() {
            return "defines=" + this._defines + " references=" + this._references + (SchemaParser.this._errorMessageBuilder.length() > 0 ? " messages=" + SchemaParser.this._errorMessageBuilder : "");
        }
    }
}

