/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.JacksonDataTemplateCodec;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class JsonBuilder {
    private final StringWriter _writer;
    private final JsonGenerator _jsonGenerator;
    private final JacksonDataCodec _jacksonDataCodec = new JacksonDataCodec();
    private final JacksonDataTemplateCodec _jacksonDataTemplateCodec = new JacksonDataTemplateCodec();
    private static final JsonFactory _jsonFactory = new JsonFactory().disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
    private static final PrettyPrinter _spacesPrettyPrinter = new SpacesPrettyPrinter();

    public JsonBuilder(Pretty pretty) throws IOException {
        this._writer = new StringWriter();
        this._jsonGenerator = _jsonFactory.createGenerator((Writer)this._writer);
        switch (pretty) {
            case SPACES: {
                this._jsonGenerator.setPrettyPrinter(_spacesPrettyPrinter);
                break;
            }
            case INDENTED: {
                this._jsonGenerator.useDefaultPrettyPrinter();
                break;
            }
        }
    }

    public String result() throws IOException {
        this._jsonGenerator.flush();
        return this._writer.toString();
    }

    public void close() throws IOException {
        this._jsonGenerator.close();
        this._writer.close();
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        this._jsonGenerator.writeBoolean(value);
    }

    public void writeString(String value) throws IOException {
        this._jsonGenerator.writeString(value);
    }

    public void writeStartObject() throws IOException {
        this._jsonGenerator.writeStartObject();
    }

    public void writeEndObject() throws IOException {
        this._jsonGenerator.writeEndObject();
    }

    public void writeFieldName(String fieldName) throws IOException {
        this._jsonGenerator.writeFieldName(fieldName);
    }

    public void writeStartArray() throws IOException {
        this._jsonGenerator.writeStartArray();
    }

    public void writeEndArray() throws IOException {
        this._jsonGenerator.writeEndArray();
    }

    public void writeStringArray(List<String> value) throws IOException {
        this.writeStartArray();
        for (String s : value) {
            this.writeString(s);
        }
        this.writeEndArray();
    }

    public void writeMap(Map<String, ?> value) throws IOException {
        this.writeStartObject();
        this.writeProperties(value);
        this.writeEndObject();
    }

    public void writeBooleanField(String fieldName, boolean value) throws IOException {
        this._jsonGenerator.writeBooleanField(fieldName, value);
    }

    public void writeIntField(String fieldName, int value) throws IOException {
        this._jsonGenerator.writeNumberField(fieldName, value);
    }

    public void writeStringField(String fieldName, String value, boolean required) throws IOException {
        if (required || !value.isEmpty()) {
            this._jsonGenerator.writeStringField(fieldName, value);
        }
    }

    public void writeStringArrayField(String fieldName, List<String> value, boolean required) throws IOException {
        if (required || !value.isEmpty()) {
            this.writeFieldName(fieldName);
            this.writeStringArray(value);
        }
    }

    public void writeMapField(String fieldName, Map<String, ?> value, boolean required) throws IOException {
        if (required || !value.isEmpty()) {
            this.writeFieldName(fieldName);
            this.writeMap(value);
        }
    }

    public void writeData(Object object) throws IOException {
        this._jacksonDataCodec.objectToJsonGenerator(object, this._jsonGenerator);
    }

    public void writeProperties(Map<String, ?> value) throws IOException {
        if (!value.isEmpty()) {
            for (Map.Entry<String, ?> entry : value.entrySet()) {
                this._jsonGenerator.writeFieldName(entry.getKey());
                this.writeData(entry.getValue());
            }
        }
    }

    public void writeDataTemplate(DataTemplate<?> template, Boolean order) throws IOException {
        this._jacksonDataTemplateCodec.dataTemplateToJsonGenerator(template, this._jsonGenerator, order);
    }

    private static class SpacesPrettyPrinter
    implements PrettyPrinter {
        private SpacesPrettyPrinter() {
        }

        public void beforeArrayValues(JsonGenerator generator) throws IOException {
        }

        public void beforeObjectEntries(JsonGenerator generator) throws IOException {
        }

        public void writeArrayValueSeparator(JsonGenerator generator) throws IOException {
            generator.writeRaw(", ");
        }

        public void writeEndArray(JsonGenerator generator, int arg1) throws IOException {
            generator.writeRaw(" ]");
        }

        public void writeEndObject(JsonGenerator generator, int arg1) throws IOException {
            generator.writeRaw(" }");
        }

        public void writeObjectEntrySeparator(JsonGenerator generator) throws IOException {
            generator.writeRaw(", ");
        }

        public void writeObjectFieldValueSeparator(JsonGenerator generator) throws IOException {
            generator.writeRaw(" : ");
        }

        public void writeRootValueSeparator(JsonGenerator generator) throws IOException {
        }

        public void writeStartArray(JsonGenerator generator) throws IOException {
            generator.writeRaw("[ ");
        }

        public void writeStartObject(JsonGenerator generator) throws IOException {
            generator.writeRaw("{ ");
        }
    }

    public static enum Pretty {
        COMPACT,
        SPACES,
        INDENTED;

    }
}

