/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.it;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.it.DataIterator;
import com.linkedin.data.transforms.Transform;
import com.linkedin.data.transforms.Transforms;
import java.util.ArrayList;

public class Transformer {
    public static Object transform(Object root, DataIterator it, Transform<Object, Object> transform) {
        DataElement element;
        ArrayList<ToTransform> transformList = new ArrayList<ToTransform>();
        while ((element = it.next()) != null) {
            transformList.add(new ToTransform(element));
        }
        for (ToTransform toTransform : transformList) {
            if (toTransform.isRoot()) {
                root = transform.apply(toTransform._value);
                continue;
            }
            toTransform.transform(transform);
        }
        return root;
    }

    public static Object replace(Object root, DataIterator it, Object value) {
        return Transformer.transform(root, it, Transforms.constantValue(value));
    }

    private static class ToTransform {
        private final Object _value;
        private final Object _parent;
        private final Object _name;

        private ToTransform(DataElement element) {
            this._value = element.getValue();
            DataElement parentElement = element.getParent();
            this._parent = parentElement == null ? null : parentElement.getValue();
            this._name = element.getName();
        }

        private boolean isRoot() {
            return this._parent == null;
        }

        private void transform(Transform<Object, Object> transform) {
            Object replacementValue = transform.apply(this._value);
            Class<?> nameClass = this._name.getClass();
            Class<?> parentClass = this._parent.getClass();
            if (nameClass == String.class) {
                assert (parentClass == DataMap.class);
                DataMap map = (DataMap)this._parent;
                String key = (String)this._name;
                map.put(key, replacementValue);
            } else if (nameClass == Integer.class) {
                int index = (Integer)this._name;
                assert (parentClass == DataList.class);
                DataList list = (DataList)this._parent;
                list.set(index, replacementValue);
            } else {
                throw new IllegalStateException("DataElement's name is not a String or Integer");
            }
        }
    }
}

