/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.collections;

import com.linkedin.data.collections.CommonMap;
import com.linkedin.data.collections.MapChecker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CheckedMap<K, V>
implements CommonMap<K, V>,
Cloneable {
    private boolean _readOnly = false;
    protected MapChecker<K, V> _checker;
    private HashMap<K, V> _map;

    public CheckedMap() {
        this._checker = null;
        this._map = new HashMap();
    }

    public CheckedMap(Map<? extends K, ? extends V> map) {
        this._checker = null;
        this.checkAll(map);
        this._map = new HashMap<K, V>(map);
    }

    public CheckedMap(int initialCapacity) {
        this._checker = null;
        this._map = new HashMap(initialCapacity);
    }

    public CheckedMap(int initialCapacity, float loadFactor) {
        this._checker = null;
        this._map = new HashMap(initialCapacity, loadFactor);
    }

    public CheckedMap(MapChecker<K, V> checker) {
        this._checker = checker;
        this._map = new HashMap();
    }

    public CheckedMap(Map<? extends K, ? extends V> map, MapChecker<K, V> checker) {
        this._checker = checker;
        this.checkAll(map);
        this._map = new HashMap<K, V>(map);
    }

    public CheckedMap(int initialCapacity, MapChecker<K, V> checker) {
        this._checker = checker;
        this._map = new HashMap(initialCapacity);
    }

    public CheckedMap(int initialCapacity, float loadFactor, MapChecker<K, V> checker) {
        this._checker = checker;
        this._map = new HashMap(initialCapacity, loadFactor);
    }

    @Override
    public void clear() {
        this.checkMutability();
        this._map.clear();
    }

    @Override
    public CheckedMap<K, V> clone() throws CloneNotSupportedException {
        CheckedMap o = (CheckedMap)super.clone();
        o._map = (HashMap)this._map.clone();
        o._readOnly = false;
        return o;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableMap(this._map).entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this._map.equals(object);
    }

    @Override
    public V get(Object key) {
        return this._map.get(key);
    }

    @Override
    public int hashCode() {
        return this._map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    @Override
    public V put(K key, V value) {
        this.checkKeyValue(key, value);
        this.checkMutability();
        return this._map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkAll(m);
        this.checkMutability();
        this._map.putAll(m);
    }

    @Override
    public V remove(Object key) {
        this.checkMutability();
        return this._map.remove(key);
    }

    public String toString() {
        return this._map.toString();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this._map.values());
    }

    @Override
    public boolean isReadOnly() {
        return this._readOnly;
    }

    @Override
    public void setReadOnly() {
        this._readOnly = true;
    }

    @Override
    public void invalidate() {
        this._map = null;
    }

    private final void checkMutability() {
        if (this._readOnly) {
            throw new UnsupportedOperationException("Cannot mutate a read-only map");
        }
    }

    private final void checkKeyValue(K key, V value) {
        if (this._checker != null) {
            this._checker.checkKeyValue(this, key, value);
        }
    }

    private final void checkAll(Map<? extends K, ? extends V> m) {
        if (this._checker != null) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this._checker.checkKeyValue(this, e.getKey(), e.getValue());
            }
        }
    }

    protected V putWithoutChecking(K key, V value) {
        this.checkMutability();
        return this._map.put(key, value);
    }

    V putWithAssertedChecking(K key, V value) {
        assert (this.assertCheckKeyValue(key, value)) : "Check is failed";
        return this.putWithoutChecking(key, value);
    }

    protected void putAllWithoutChecking(Map<? extends K, ? extends V> src) {
        this.checkMutability();
        this._map.putAll(src);
    }

    void putAllWithAssertedChecking(Map<? extends K, ? extends V> src) {
        assert (this.assertCheckMap(src)) : "Check is failed";
        this.putAllWithoutChecking(src);
    }

    protected final Map<K, V> getObject() {
        return this._map;
    }

    private boolean assertCheckKeyValue(K key, V value) {
        try {
            this.checkKeyValue(key, value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean assertCheckMap(Map<? extends K, ? extends V> map) {
        try {
            this.checkAll(map);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

