/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.BufferChain;
import com.linkedin.data.codec.DataCodec;
import com.linkedin.data.codec.DataDecodingException;
import com.linkedin.data.collections.CheckedUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PsonDataCodec
implements DataCodec {
    private static final byte[] HEADER = new byte[]{35, 33, 80, 83, 79, 78, 49, 10};
    private boolean _testMode;
    private Options _options = new Options();
    static final byte ZERO_BYTE = 0;
    static final byte ONE_BYTE = 1;
    static final int PSON_INVALID_KEY_INDEX = 0;
    static final byte PSON_NULL = 0;
    static final byte PSON_BOOLEAN = 1;
    static final byte PSON_INT = 2;
    static final byte PSON_LONG = 3;
    static final byte PSON_FLOAT = 4;
    static final byte PSON_DOUBLE = 5;
    static final byte PSON_BINARY = 6;
    static final byte PSON_STRING_EMPTY = 8;
    static final byte PSON_STRING = 9;
    static final byte PSON_STRING_WITH_LENGTH_4 = 10;
    static final byte PSON_STRING_WITH_LENGTH_2 = 11;
    static final byte PSON_ARRAY_EMPTY = 16;
    static final byte PSON_ARRAY = 17;
    static final byte PSON_ARRAY_WITH_COUNT = 18;
    static final byte PSON_OBJECT_EMPTY = 32;
    static final byte PSON_OBJECT = 33;
    static final byte PSON_OBJECT_WITH_COUNT = 34;
    static final byte PSON_LAST = -1;
    private static final int MAX_STRING_WITH_LENGTH_2 = 16382;

    public PsonDataCodec() {
    }

    public PsonDataCodec(boolean testMode) {
        this._testMode = testMode;
    }

    public PsonDataCodec setOptions(Options options) {
        this._options = options;
        return this;
    }

    public Options getOptions() {
        return this._options;
    }

    private PsonSerializer serialize(DataComplex map) throws IOException {
        PsonSerializer serializer = new PsonSerializer();
        serializer.serialize(map);
        return serializer;
    }

    protected byte[] complexToBytes(DataComplex complex) throws IOException {
        try {
            byte[] bytes = this.serialize(complex).toBytes();
            return bytes;
        }
        catch (RuntimeException exc) {
            throw new IOException("Unexpected RuntimeException", exc);
        }
    }

    protected <T extends DataComplex> T bytesToComplex(byte[] input, Class<T> clazz) throws IOException {
        try {
            BufferChain buffer = this._testMode && this._options.getBufferSize() != null ? new BufferChain(ByteOrder.LITTLE_ENDIAN, input, (int)this._options.getBufferSize()) : new BufferChain(ByteOrder.LITTLE_ENDIAN, input);
            PsonParser psonParser = new PsonParser(buffer);
            return (T)((DataComplex)clazz.cast(psonParser.read()));
        }
        catch (RuntimeException exc) {
            throw new IOException("Unexpected RuntimeException", exc);
        }
    }

    @Override
    public byte[] mapToBytes(DataMap map) throws IOException {
        return this.complexToBytes(map);
    }

    @Override
    public byte[] listToBytes(DataList list) throws IOException {
        return this.complexToBytes(list);
    }

    @Override
    public DataMap bytesToMap(byte[] input) throws IOException {
        return this.bytesToComplex(input, DataMap.class);
    }

    @Override
    public DataList bytesToList(byte[] input) throws IOException {
        return this.bytesToComplex(input, DataList.class);
    }

    protected void writeComplex(DataComplex complex, OutputStream out) throws IOException {
        try {
            this.serialize(complex).writeToOutputStream(out);
        }
        catch (RuntimeException exc) {
            throw new IOException("Unexpected RuntimeException", exc);
        }
    }

    @Override
    public void writeMap(DataMap map, OutputStream out) throws IOException {
        this.writeComplex(map, out);
    }

    @Override
    public void writeList(DataList list, OutputStream out) throws IOException {
        this.writeComplex(list, out);
    }

    protected <T extends DataComplex> T readComplex(InputStream in, Class<T> clazz) throws IOException {
        try {
            BufferChain buffer = this._testMode && this._options.getBufferSize() != null ? new BufferChain(ByteOrder.LITTLE_ENDIAN, this._options.getBufferSize()) : new BufferChain(ByteOrder.LITTLE_ENDIAN);
            buffer.readFromInputStream(in);
            buffer.rewind();
            PsonParser psonParser = new PsonParser(buffer);
            return (T)((DataComplex)clazz.cast(psonParser.read()));
        }
        catch (RuntimeException exc) {
            throw new IOException("Unexpected RuntimeException", exc);
        }
    }

    @Override
    public DataMap readMap(InputStream in) throws IOException {
        return this.readComplex(in, DataMap.class);
    }

    @Override
    public DataList readList(InputStream in) throws IOException {
        return this.readComplex(in, DataList.class);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._options + ")";
    }

    protected static class PsonParser {
        static final String HEX = "0123456789ABCDEF";
        private final BufferChain _buffer;
        private String[] _keyArray = new String[100];
        private int _expectedKeyIndex = 1;

        PsonParser(BufferChain buffer) {
            this._buffer = buffer;
        }

        static String bytesToString(byte[] bytes) {
            StringBuffer sb = new StringBuffer(bytes.length * 2 + 4);
            sb.append("0x");
            for (int i = 0; i < bytes.length; ++i) {
                byte v = bytes[i];
                sb.append(HEX.charAt(v >> 4));
                sb.append(HEX.charAt(v & 0xF));
            }
            return sb.toString();
        }

        Object read() throws IOException {
            byte[] header = new byte[HEADER.length];
            this._buffer.get(header, 0, header.length);
            if (!Arrays.equals(header, HEADER)) {
                throw new IOException("Expecting header " + PsonParser.bytesToString(HEADER) + " but got " + PsonParser.bytesToString(header));
            }
            return this.parseValue();
        }

        DataList parseArray(boolean withCount) throws IOException {
            Object item;
            int size = withCount ? this._buffer.getVarUnsignedInt() : -1;
            DataList list = size >= 0 ? new DataList(size) : new DataList();
            int count = 0;
            count = 0;
            while ((item = this.parseValue()) != null) {
                CheckedUtil.addWithoutChecking(list, item);
                ++count;
            }
            if (size >= 0 && count != size) {
                throw new IOException("Actual number array items (" + count + ") is not the same as expected (" + size + ")");
            }
            return list;
        }

        DataMap parseMap(boolean withCount) throws IOException {
            int keyIndex;
            int size = withCount ? this._buffer.getVarUnsignedInt() : -1;
            DataMap map = size >= 0 ? new DataMap((int)((double)size * 1.5 + 0.5)) : new DataMap();
            int count = 0;
            while ((keyIndex = this._buffer.getVarInt()) != 0) {
                String key;
                if (keyIndex < 0) {
                    if ((keyIndex = -keyIndex) != this._expectedKeyIndex) {
                        throw new IOException("Received new key index " + keyIndex + " but expecting " + this._expectedKeyIndex);
                    }
                    ++this._expectedKeyIndex;
                    if (keyIndex >= this._keyArray.length) {
                        this.resizeKeyArray();
                    }
                    assert (this._keyArray[keyIndex] == null);
                    this._keyArray[keyIndex] = key = this._buffer.getUtf8CString();
                } else {
                    key = this._keyArray[keyIndex];
                    assert (key != null);
                }
                Object item = this.parseValue();
                if (item == null) {
                    throw new IOException("Unexpected end of array");
                }
                CheckedUtil.putWithoutChecking(map, key, item);
                ++count;
            }
            if (size >= 0 && count != size) {
                throw new IOException("Actual number object fields (" + count + ") is not the same as expected (" + size + ")");
            }
            return map;
        }

        private void resizeKeyArray() {
            String[] newKeyArray = new String[this._keyArray.length * 2];
            System.arraycopy(this._keyArray, 0, newKeyArray, 0, this._keyArray.length);
            this._keyArray = newKeyArray;
        }

        Object parseValue() throws IOException {
            byte psonType = this._buffer.get();
            Object o = null;
            boolean valid = true;
            switch (psonType) {
                case 32: {
                    o = new DataMap();
                    break;
                }
                case 33: {
                    o = this.parseMap(false);
                    break;
                }
                case 34: {
                    o = this.parseMap(true);
                    break;
                }
                case 16: {
                    o = new DataList();
                    break;
                }
                case 17: {
                    o = this.parseArray(false);
                    break;
                }
                case 18: {
                    o = this.parseArray(true);
                    break;
                }
                case 2: {
                    o = this._buffer.getInt();
                    break;
                }
                case 3: {
                    o = this._buffer.getLong();
                    break;
                }
                case 4: {
                    o = Float.valueOf(this._buffer.getFloat());
                    break;
                }
                case 5: {
                    o = this._buffer.getDouble();
                    break;
                }
                case 8: {
                    o = "";
                    break;
                }
                case 9: {
                    o = this._buffer.getUtf8CString();
                    break;
                }
                case 10: {
                    o = this.getStringWithLength(this._buffer.getInt());
                    break;
                }
                case 11: {
                    o = this.getStringWithLength(this._buffer.getShort());
                    break;
                }
                case 1: {
                    byte b = this._buffer.get();
                    o = new Boolean(b != 0);
                    break;
                }
                case 6: {
                    int length = this._buffer.getInt();
                    o = ByteString.read(this._buffer.asInputStream(), length);
                    break;
                }
                case 0: {
                    o = Data.NULL;
                    break;
                }
                case -1: {
                    o = null;
                    break;
                }
                default: {
                    valid = false;
                }
            }
            if (!valid) {
                throw new IOException("Illegal PSON element code " + psonType);
            }
            return o;
        }

        private String getStringWithLength(int length) throws IOException {
            if (length == 0) {
                throw new DataDecodingException("String size should not be 0");
            }
            return this._buffer.getUtf8CString(length);
        }
    }

    protected class PsonSerializer
    implements Data.TraverseCallback {
        private final BufferChain _buffer;
        private final HashMap<String, Integer> _keyMap = new HashMap(200);
        private int _keyIndex = 1;
        private final boolean _encodeStringLength = PsonDataCodec.access$300(PsonDataCodec.this).getEncodeStringLength();
        private final boolean _encodeCollectionCount = PsonDataCodec.access$300(PsonDataCodec.this).getEncodeCollectionCount();

        protected PsonSerializer() {
            this._buffer = PsonDataCodec.this._options.getBufferSize() == null ? new BufferChain(ByteOrder.LITTLE_ENDIAN) : new BufferChain(ByteOrder.LITTLE_ENDIAN, PsonDataCodec.this._options.getBufferSize());
        }

        @Override
        public Iterable<Map.Entry<String, Object>> orderMap(DataMap map) {
            return map.entrySet();
        }

        @Override
        public void nullValue() throws CharacterCodingException {
            this._buffer.put((byte)0);
        }

        @Override
        public void booleanValue(boolean value) throws CharacterCodingException {
            this._buffer.put((byte)1);
            this._buffer.put(value ? (byte)1 : 0);
        }

        @Override
        public void integerValue(int value) throws CharacterCodingException {
            this._buffer.put((byte)2);
            this._buffer.putInt(value);
        }

        @Override
        public void longValue(long value) throws CharacterCodingException {
            this._buffer.put((byte)3);
            this._buffer.putLong(value);
        }

        @Override
        public void floatValue(float value) throws CharacterCodingException {
            this._buffer.put((byte)4);
            this._buffer.putFloat(value);
        }

        @Override
        public void doubleValue(double value) throws CharacterCodingException {
            this._buffer.put((byte)5);
            this._buffer.putDouble(value);
        }

        @Override
        public void stringValue(String value) throws CharacterCodingException {
            if (value.isEmpty()) {
                this._buffer.put((byte)8);
            } else if (this._encodeStringLength) {
                this.putStringWithLength(value);
            } else {
                this._buffer.put((byte)9);
                this._buffer.putUtf8CString(value);
            }
        }

        @Override
        public void byteStringValue(ByteString value) throws CharacterCodingException {
            this._buffer.put((byte)6);
            this._buffer.putInt(value.length());
            this._buffer.putByteString(value);
        }

        @Override
        public void illegalValue(Object value) throws IOException {
            throw new IOException("Illegal type encountered: " + value.getClass());
        }

        @Override
        public void emptyMap() throws CharacterCodingException {
            this._buffer.put((byte)32);
        }

        @Override
        public void startMap(DataMap map) throws CharacterCodingException {
            if (this._encodeCollectionCount) {
                this.start((byte)34);
                this._buffer.putVarUnsignedInt(map.size());
            } else {
                this.start((byte)33);
            }
        }

        @Override
        public void key(String key) throws CharacterCodingException {
            Integer found = this._keyMap.get(key);
            if (found == null) {
                this._keyMap.put(key, this._keyIndex);
                int index = -this._keyIndex;
                this._buffer.putVarInt(index);
                this._buffer.putUtf8CString(key);
                ++this._keyIndex;
            } else {
                int index = found;
                this._buffer.putVarInt(index);
            }
        }

        @Override
        public void endMap() {
            this._buffer.putVarInt(0);
        }

        @Override
        public void emptyList() throws CharacterCodingException {
            this._buffer.put((byte)16);
        }

        @Override
        public void startList(DataList list) throws CharacterCodingException {
            if (this._encodeCollectionCount) {
                this.start((byte)18);
                this._buffer.putVarUnsignedInt(list.size());
            } else {
                this.start((byte)17);
            }
        }

        @Override
        public void index(int index) {
        }

        @Override
        public void endList() {
            this._buffer.put((byte)-1);
        }

        private final void putStringWithLength(String s) throws CharacterCodingException {
            int stringLength = s.length();
            this._buffer.put((byte)10);
            BufferChain.Position startPos = this._buffer.position();
            this._buffer.putInt(0);
            this._buffer.putUtf8CString(s);
            BufferChain.Position endPos = this._buffer.position();
            this._buffer.position(startPos);
            this._buffer.putInt(this._buffer.offset(startPos, endPos) - 4);
            this._buffer.position(endPos);
        }

        private void serialize(DataComplex map) throws IOException {
            this._buffer.put(HEADER, 0, HEADER.length);
            Data.traverse(map, this);
        }

        private final byte[] toBytes() {
            return this._buffer.toBytes();
        }

        private final void writeToOutputStream(OutputStream out) throws IOException {
            this._buffer.writeToOutputStream(out);
        }

        private void start(byte psonType) throws CharacterCodingException {
            this._buffer.put(psonType);
        }
    }

    public static class Options {
        private boolean _encodeStringLength = true;
        private boolean _encodeCollectionCount = false;
        private Integer _bufferSize = null;

        public Options setEncodeStringLength(boolean value) {
            this._encodeStringLength = value;
            return this;
        }

        public boolean getEncodeStringLength() {
            return this._encodeStringLength;
        }

        public Options setEncodeCollectionCount(boolean value) {
            this._encodeCollectionCount = value;
            return this;
        }

        public boolean getEncodeCollectionCount() {
            return this._encodeCollectionCount;
        }

        public Options setBufferSize(Integer value) {
            this._bufferSize = value;
            return this;
        }

        public Integer getBufferSize() {
            return this._bufferSize;
        }

        public String toString() {
            return "encodeCollectionCount=" + this._encodeCollectionCount + ", encodeStringLength=" + this._encodeStringLength + (this._bufferSize != null ? ", bufferSize=" + this._bufferSize : "");
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            return this._encodeCollectionCount == other._encodeCollectionCount && this._encodeStringLength == other._encodeStringLength && (this._bufferSize == null ? this._bufferSize == other._bufferSize : this._bufferSize.equals(other._bufferSize));
        }

        public int hashCode() {
            return (this._encodeCollectionCount ? 3131 : 0) + (this._encodeStringLength ? 31310000 : 0) ^ (this._bufferSize != null ? this._bufferSize.hashCode() : 0);
        }
    }
}

