/*
 * Decompiled with CFR 0.152.
 */
package parquet.io;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import parquet.Log;
import parquet.column.ColumnWriteStore;
import parquet.column.ColumnWriter;
import parquet.column.impl.ColumnReadStoreImpl;
import parquet.column.page.PageReadStore;
import parquet.filter.UnboundRecordFilter;
import parquet.io.ColumnIO;
import parquet.io.EmptyRecordReader;
import parquet.io.FilteredRecordReader;
import parquet.io.GroupColumnIO;
import parquet.io.InvalidRecordException;
import parquet.io.ParquetEncodingException;
import parquet.io.PrimitiveColumnIO;
import parquet.io.RecordConsumerLoggingWrapper;
import parquet.io.RecordReader;
import parquet.io.RecordReaderImplementation;
import parquet.io.ValidatingRecordConsumer;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.io.api.RecordMaterializer;
import parquet.schema.MessageType;

public class MessageColumnIO
extends GroupColumnIO {
    private static final Log logger = Log.getLog(MessageColumnIO.class);
    private static final boolean DEBUG = Log.DEBUG;
    private List<PrimitiveColumnIO> leaves;
    private final boolean validating;

    MessageColumnIO(MessageType messageType, boolean validating) {
        super(messageType, null, 0);
        this.validating = validating;
    }

    @Override
    public List<String[]> getColumnNames() {
        return super.getColumnNames();
    }

    public <T> RecordReader<T> getRecordReader(PageReadStore columns, RecordMaterializer<T> recordMaterializer) {
        if (this.leaves.size() > 0) {
            return new RecordReaderImplementation<T>(this, recordMaterializer, this.validating, new ColumnReadStoreImpl(columns, recordMaterializer.getRootConverter(), this.getType()));
        }
        return new EmptyRecordReader<T>(recordMaterializer);
    }

    public <T> RecordReader<T> getRecordReader(PageReadStore columns, RecordMaterializer<T> recordMaterializer, UnboundRecordFilter unboundFilter) {
        return unboundFilter == null ? this.getRecordReader(columns, recordMaterializer) : new FilteredRecordReader<T>(this, recordMaterializer, this.validating, new ColumnReadStoreImpl(columns, recordMaterializer.getRootConverter(), this.getType()), unboundFilter, columns.getRowCount());
    }

    public RecordConsumer getRecordWriter(ColumnWriteStore columns) {
        RecordConsumer recordWriter = new MessageColumnIORecordConsumer(columns);
        if (DEBUG) {
            recordWriter = new RecordConsumerLoggingWrapper(recordWriter);
        }
        return this.validating ? new ValidatingRecordConsumer(recordWriter, this.getType()) : recordWriter;
    }

    void setLevels() {
        this.setLevels(0, 0, new String[0], new int[0], Arrays.asList(this), Arrays.asList(this));
    }

    void setLeaves(List<PrimitiveColumnIO> leaves) {
        this.leaves = leaves;
    }

    public List<PrimitiveColumnIO> getLeaves() {
        return this.leaves;
    }

    @Override
    public MessageType getType() {
        return (MessageType)super.getType();
    }

    private class MessageColumnIORecordConsumer
    extends RecordConsumer {
        private ColumnIO currentColumnIO;
        private int currentLevel = 0;
        private final FieldsMarker[] fieldsWritten;
        private final int[] r;
        private final ColumnWriter[] columnWriter;
        private boolean emptyField = true;

        public MessageColumnIORecordConsumer(ColumnWriteStore columns) {
            int maxDepth = 0;
            this.columnWriter = new ColumnWriter[MessageColumnIO.this.getLeaves().size()];
            for (PrimitiveColumnIO primitiveColumnIO : MessageColumnIO.this.getLeaves()) {
                maxDepth = Math.max(maxDepth, primitiveColumnIO.getFieldPath().length);
                this.columnWriter[primitiveColumnIO.getId()] = columns.getColumnWriter(primitiveColumnIO.getColumnDescriptor());
            }
            this.fieldsWritten = new FieldsMarker[maxDepth];
            for (int i = 0; i < maxDepth; ++i) {
                this.fieldsWritten[i] = new FieldsMarker();
            }
            this.r = new int[maxDepth];
        }

        public void printState() {
            this.log(this.currentLevel + ", " + this.fieldsWritten[this.currentLevel] + ": " + Arrays.toString(this.currentColumnIO.getFieldPath()) + " r:" + this.r[this.currentLevel]);
            if (this.r[this.currentLevel] > this.currentColumnIO.getRepetitionLevel()) {
                throw new InvalidRecordException(this.r[this.currentLevel] + "(r) > " + this.currentColumnIO.getRepetitionLevel() + " ( schema r)");
            }
        }

        private void log(Object m) {
            String indent = "";
            for (int i = 0; i < this.currentLevel; ++i) {
                indent = indent + "  ";
            }
            logger.debug(indent + m);
        }

        @Override
        public void startMessage() {
            if (DEBUG) {
                this.log("< MESSAGE START >");
            }
            this.currentColumnIO = MessageColumnIO.this;
            this.r[0] = 0;
            int numberOfFieldsToVisit = ((GroupColumnIO)this.currentColumnIO).getChildrenCount();
            this.fieldsWritten[0].reset(numberOfFieldsToVisit);
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void endMessage() {
            this.writeNullForMissingFieldsAtCurrentLevel();
            if (DEBUG) {
                this.log("< MESSAGE END >");
            }
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void startField(String field, int index) {
            try {
                if (DEBUG) {
                    this.log("startField(" + field + ", " + index + ")");
                }
                this.currentColumnIO = ((GroupColumnIO)this.currentColumnIO).getChild(index);
                this.emptyField = true;
                if (DEBUG) {
                    this.printState();
                }
            }
            catch (RuntimeException e) {
                throw new ParquetEncodingException("error starting field " + field + " at " + index, e);
            }
        }

        @Override
        public void endField(String field, int index) {
            if (DEBUG) {
                this.log("endField(" + field + ", " + index + ")");
            }
            this.currentColumnIO = this.currentColumnIO.getParent();
            if (this.emptyField) {
                throw new ParquetEncodingException("empty fields are illegal, the field should be ommited completely instead");
            }
            this.fieldsWritten[this.currentLevel].markWritten(index);
            int n = this.r[this.currentLevel] = this.currentLevel == 0 ? 0 : this.r[this.currentLevel - 1];
            if (DEBUG) {
                this.printState();
            }
        }

        private void writeNullForMissingFieldsAtCurrentLevel() {
            int currentFieldsCount = ((GroupColumnIO)this.currentColumnIO).getChildrenCount();
            for (int i = 0; i < currentFieldsCount; ++i) {
                if (this.fieldsWritten[this.currentLevel].isWritten(i)) continue;
                try {
                    ColumnIO undefinedField = ((GroupColumnIO)this.currentColumnIO).getChild(i);
                    int d = this.currentColumnIO.getDefinitionLevel();
                    if (DEBUG) {
                        this.log(Arrays.toString(undefinedField.getFieldPath()) + ".writeNull(" + this.r[this.currentLevel] + "," + d + ")");
                    }
                    this.writeNull(undefinedField, this.r[this.currentLevel], d);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new ParquetEncodingException("error while writing nulls for fields of indexes " + i + " . current index: " + this.fieldsWritten[this.currentLevel], e);
                }
            }
        }

        private void writeNull(ColumnIO undefinedField, int r, int d) {
            if (undefinedField.getType().isPrimitive()) {
                this.columnWriter[((PrimitiveColumnIO)undefinedField).getId()].writeNull(r, d);
            } else {
                GroupColumnIO groupColumnIO = (GroupColumnIO)undefinedField;
                int childrenCount = groupColumnIO.getChildrenCount();
                for (int i = 0; i < childrenCount; ++i) {
                    this.writeNull(groupColumnIO.getChild(i), r, d);
                }
            }
        }

        private void setRepetitionLevel() {
            this.r[this.currentLevel] = this.currentColumnIO.getRepetitionLevel();
            if (DEBUG) {
                this.log("r: " + this.r[this.currentLevel]);
            }
        }

        @Override
        public void startGroup() {
            if (DEBUG) {
                this.log("startGroup()");
            }
            ++this.currentLevel;
            this.r[this.currentLevel] = this.r[this.currentLevel - 1];
            int fieldsCount = ((GroupColumnIO)this.currentColumnIO).getChildrenCount();
            this.fieldsWritten[this.currentLevel].reset(fieldsCount);
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void endGroup() {
            if (DEBUG) {
                this.log("endGroup()");
            }
            this.emptyField = false;
            this.writeNullForMissingFieldsAtCurrentLevel();
            --this.currentLevel;
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        private ColumnWriter getColumnWriter() {
            return this.columnWriter[((PrimitiveColumnIO)this.currentColumnIO).getId()];
        }

        @Override
        public void addInteger(int value) {
            if (DEBUG) {
                this.log("addInt(" + value + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addLong(long value) {
            if (DEBUG) {
                this.log("addLong(" + value + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addBoolean(boolean value) {
            if (DEBUG) {
                this.log("addBoolean(" + value + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addBinary(Binary value) {
            if (DEBUG) {
                this.log("addBinary(" + value.length() + " bytes)");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addFloat(float value) {
            if (DEBUG) {
                this.log("addFloat(" + value + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addDouble(double value) {
            if (DEBUG) {
                this.log("addDouble(" + value + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        private class FieldsMarker {
            private BitSet vistedIndexes = new BitSet();

            private FieldsMarker() {
            }

            public String toString() {
                return "VistedIndex{vistedIndexes=" + this.vistedIndexes + '}';
            }

            public void reset(int fieldsCount) {
                this.vistedIndexes.clear(0, fieldsCount);
            }

            public void markWritten(int i) {
                this.vistedIndexes.set(i);
            }

            public boolean isWritten(int i) {
                return this.vistedIndexes.get(i);
            }
        }
    }
}

