/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.api;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import parquet.io.api.RecordConsumer;
import parquet.schema.MessageType;

public abstract class WriteSupport<T> {
    public abstract WriteContext init(Configuration var1);

    public abstract void prepareForWrite(RecordConsumer var1);

    public abstract void write(T var1);

    public static final class WriteContext {
        private final MessageType schema;
        private final Map<String, String> extraMetaData;

        public WriteContext(MessageType schema, Map<String, String> extraMetaData) {
            if (schema == null) {
                throw new NullPointerException("schema");
            }
            if (extraMetaData == null) {
                throw new NullPointerException("extraMetaData");
            }
            this.schema = schema;
            this.extraMetaData = Collections.unmodifiableMap(extraMetaData);
        }

        public MessageType getSchema() {
            return this.schema;
        }

        public Map<String, String> getExtraMetaData() {
            return this.extraMetaData;
        }
    }
}

