/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.Footer;
import parquet.hadoop.InternalParquetRecordReader;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.GlobalMetaData;
import parquet.schema.MessageType;

public class ParquetReader<T>
implements Closeable {
    private ReadSupport<T> readSupport;
    private UnboundRecordFilter filter;
    private Configuration conf;
    private ReadSupport.ReadContext readContext;
    private Iterator<Footer> footersIterator;
    private InternalParquetRecordReader<T> reader;
    private GlobalMetaData globalMetaData;

    public ParquetReader(Path file, ReadSupport<T> readSupport) throws IOException {
        this(file, readSupport, null);
    }

    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport) throws IOException {
        this(conf, file, readSupport, null);
    }

    public ParquetReader(Path file, ReadSupport<T> readSupport, UnboundRecordFilter filter) throws IOException {
        this(new Configuration(), file, readSupport, filter);
    }

    public ParquetReader(Configuration conf, Path file, ReadSupport<T> readSupport, UnboundRecordFilter filter) throws IOException {
        this.readSupport = readSupport;
        this.filter = filter;
        this.conf = conf;
        FileSystem fs = file.getFileSystem(conf);
        List<FileStatus> statuses = Arrays.asList(fs.listStatus(file));
        List<Footer> footers = ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(conf, statuses);
        this.footersIterator = footers.iterator();
        this.globalMetaData = ParquetFileWriter.getGlobalMetaData(footers);
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        for (Footer footer : footers) {
            blocks.addAll(footer.getParquetMetadata().getBlocks());
        }
        MessageType schema = this.globalMetaData.getSchema();
        Map<String, Set<String>> extraMetadata = this.globalMetaData.getKeyValueMetaData();
        this.readContext = readSupport.init(new InitContext(conf, extraMetadata, schema));
    }

    public T read() throws IOException {
        try {
            if (this.reader != null && this.reader.nextKeyValue()) {
                return this.reader.getCurrentValue();
            }
            this.initReader();
            return this.reader == null ? null : (T)this.read();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void initReader() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.footersIterator.hasNext()) {
            Footer footer = this.footersIterator.next();
            this.reader = new InternalParquetRecordReader<T>(this.readSupport, this.filter);
            this.reader.initialize(this.readContext.getRequestedSchema(), this.globalMetaData.getSchema(), footer.getParquetMetadata().getFileMetaData().getKeyValueMetaData(), this.readContext.getReadSupportMetadata(), footer.getFile(), footer.getParquetMetadata().getBlocks(), this.conf);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

