/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.service;

import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.Map;

public class StandardServiceConfig {
    public static final String STARTUP_PREFIX = "startUp";
    public static final String TIMEOUT_MS_KEY = "timeoutMs";
    public static final String STARTUP_TIMEOUT_MS_PROP = "startUp.timeoutMs";
    public static final String SHUTDOWN_PREFIX = "shutDown";
    public static final String SHUTDOWN_TIMEOUT_MS_PROP = "shutDown.timeoutMs";
    public static final Config DEFAULT_CFG = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)"startUp.timeoutMs", (Object)300000).put((Object)"shutDown.timeoutMs", (Object)300000).build());
    private final long startUpTimeoutMs;
    private final long shutDownTimeoutMs;

    public StandardServiceConfig(Config serviceCfg) {
        Config effectiveCfg = serviceCfg.withFallback((ConfigMergeable)DEFAULT_CFG);
        this.startUpTimeoutMs = effectiveCfg.getLong(STARTUP_TIMEOUT_MS_PROP);
        this.shutDownTimeoutMs = effectiveCfg.getLong(SHUTDOWN_TIMEOUT_MS_PROP);
    }

    public long getStartUpTimeoutMs() {
        return this.startUpTimeoutMs;
    }

    public long getShutDownTimeoutMs() {
        return this.shutDownTimeoutMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardServiceConfig)) {
            return false;
        }
        StandardServiceConfig other = (StandardServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartUpTimeoutMs() != other.getStartUpTimeoutMs()) {
            return false;
        }
        return this.getShutDownTimeoutMs() == other.getShutDownTimeoutMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StandardServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startUpTimeoutMs = this.getStartUpTimeoutMs();
        result = result * 59 + (int)($startUpTimeoutMs >>> 32 ^ $startUpTimeoutMs);
        long $shutDownTimeoutMs = this.getShutDownTimeoutMs();
        result = result * 59 + (int)($shutDownTimeoutMs >>> 32 ^ $shutDownTimeoutMs);
        return result;
    }
}

