/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.limiter;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.LimiterFactory;
import org.apache.gobblin.util.limiter.NonRefillableLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedLimiter
extends NonRefillableLimiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeBasedLimiter.class);
    private final long timeLimit;
    private final TimeUnit timeUnit;
    private final ScheduledThreadPoolExecutor flagFlippingExecutor;
    private volatile boolean canIssuePermit = true;

    public TimeBasedLimiter(long timeLimit) {
        this(timeLimit, TimeUnit.SECONDS);
    }

    public TimeBasedLimiter(long timeLimit, TimeUnit timeUnit) {
        this.timeLimit = timeLimit;
        this.timeUnit = timeUnit;
        this.flagFlippingExecutor = new ScheduledThreadPoolExecutor(1, ExecutorsUtils.newThreadFactory((Optional<Logger>)Optional.of((Object)LOGGER), (Optional<String>)Optional.of((Object)"TimeBasedThrottler")));
    }

    @Override
    public void start() {
        this.flagFlippingExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                TimeBasedLimiter.this.canIssuePermit = false;
            }
        }, this.timeLimit, this.timeUnit);
    }

    @Override
    public Closeable acquirePermits(long permits) throws InterruptedException {
        return this.canIssuePermit ? NO_OP_CLOSEABLE : null;
    }

    @Override
    public void stop() {
        this.flagFlippingExecutor.shutdownNow();
    }

    @Alias(value="time")
    public static class Factory
    implements LimiterFactory {
        public static final String MAX_SECONDS_KEY = "maxSeconds";

        @Override
        public Limiter buildLimiter(Config config) {
            if (!config.hasPath(MAX_SECONDS_KEY)) {
                throw new RuntimeException("Missing key maxSeconds");
            }
            return new TimeBasedLimiter(config.getLong(MAX_SECONDS_KEY));
        }
    }
}

