/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.limiter;

import com.typesafe.config.Config;
import java.io.Closeable;
import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.LimiterFactory;
import org.apache.gobblin.util.limiter.NonRefillableLimiter;

public class CountBasedLimiter
extends NonRefillableLimiter {
    public static final String FACTORY_ALIAS = "CountBasedLimiter";
    private final long countLimit;
    private long count;

    public CountBasedLimiter(long countLimit) {
        this.countLimit = countLimit;
        this.count = 0L;
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized Closeable acquirePermits(long permits) throws InterruptedException {
        if (this.count + permits <= this.countLimit) {
            this.count += permits;
            return NO_OP_CLOSEABLE;
        }
        return null;
    }

    @Override
    public void stop() {
    }

    public long getCountLimit() {
        return this.countLimit;
    }

    @Alias(value="CountBasedLimiter")
    public static class Factory
    implements LimiterFactory {
        public static final String COUNT_KEY = "maxPermits";

        @Override
        public Limiter buildLimiter(Config config) {
            if (!config.hasPath(COUNT_KEY)) {
                throw new IllegalArgumentException("Missing key maxPermits");
            }
            return new CountBasedLimiter(config.getLong(COUNT_KEY));
        }
    }
}

