/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.filesystem;

import java.io.IOException;
import java.net.URI;
import java.util.ServiceLoader;
import org.apache.gobblin.broker.ResourceInstance;
import org.apache.gobblin.broker.iface.ConfigView;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.ScopedConfigView;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceFactoryResponse;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.util.filesystem.FileSystemInstrumentationFactory;
import org.apache.gobblin.util.filesystem.FileSystemKey;
import org.apache.gobblin.util.filesystem.InstrumentedFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFactory<S extends ScopeType<S>>
implements SharedResourceFactory<FileSystem, FileSystemKey, S> {
    private static final Logger log = LoggerFactory.getLogger(FileSystemFactory.class);
    public static final String FACTORY_NAME = "filesystem";

    public static <S extends ScopeType<S>> FileSystem get(Configuration configuration, SharedResourcesBroker<S> broker) throws IOException {
        return FileSystemFactory.get(FileSystem.getDefaultUri((Configuration)configuration), configuration, broker);
    }

    public static <S extends ScopeType<S>> FileSystem get(URI uri, Configuration configuration, SharedResourcesBroker<S> broker) throws IOException {
        try {
            return (FileSystem)broker.getSharedResource(new FileSystemFactory<S>(), (SharedResourceKey)new FileSystemKey(uri, configuration));
        }
        catch (NotConfiguredException nce) {
            throw new IOException(nce);
        }
    }

    public String getName() {
        return FACTORY_NAME;
    }

    public SharedResourceFactoryResponse<FileSystem> createResource(SharedResourcesBroker<S> broker, ScopedConfigView<S, FileSystemKey> config) throws NotConfiguredException {
        try {
            FileSystemKey key = (FileSystemKey)config.getKey();
            URI uri = key.getUri();
            Configuration hadoopConf = key.getConfiguration();
            log.info("Creating instrumented FileSystem for uri " + uri);
            Class fsClass = FileSystem.getFileSystemClass((String)uri.getScheme(), (Configuration)hadoopConf);
            if (InstrumentedFileSystem.class.isAssignableFrom(fsClass)) {
                InstrumentedFileSystem tmpfs = (InstrumentedFileSystem)((Object)fsClass.newInstance());
                hadoopConf = new Configuration(hadoopConf);
                String schemeKey = "fs." + uri.getScheme() + ".impl";
                hadoopConf.set(schemeKey, tmpfs.underlyingFs.getClass().getName());
            }
            FileSystem fs = FileSystem.newInstance((URI)uri, (Configuration)hadoopConf);
            ServiceLoader<FileSystemInstrumentationFactory> loader = ServiceLoader.load(FileSystemInstrumentationFactory.class);
            for (FileSystemInstrumentationFactory instrumentationFactory : loader) {
                fs = instrumentationFactory.instrumentFileSystem(fs, broker, config);
            }
            return new ResourceInstance<FileSystem>(fs);
        }
        catch (IOException | ReflectiveOperationException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public S getAutoScope(SharedResourcesBroker<S> broker, ConfigView<S, FileSystemKey> config) {
        return (S)broker.selfScope().getType().rootScope();
    }
}

