/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.concurrent;

import com.google.common.base.Enums;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.util.concurrent.HashedWheelTimerTaskScheduler;
import org.apache.gobblin.util.concurrent.ScheduledExecutorServiceTaskScheduler;
import org.apache.gobblin.util.concurrent.TaskScheduler;

public enum TaskSchedulerType {
    SCHEDULEDEXECUTORSERVICE(ScheduledExecutorServiceTaskScheduler.class),
    HASHEDWHEELTIMER(HashedWheelTimerTaskScheduler.class);

    private final Class<? extends TaskScheduler> taskSchedulerClass;

    public static TaskSchedulerType parse(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return SCHEDULEDEXECUTORSERVICE;
        }
        return (TaskSchedulerType)((Object)Enums.getIfPresent(TaskSchedulerType.class, (String)name.toUpperCase()).or((Object)SCHEDULEDEXECUTORSERVICE));
    }

    private TaskSchedulerType(Class<? extends TaskScheduler> taskSchedulerClass) {
        this.taskSchedulerClass = taskSchedulerClass;
    }

    public Class<? extends TaskScheduler> getTaskSchedulerClass() {
        return this.taskSchedulerClass;
    }
}

