/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.concurrent;

import com.google.common.base.Optional;
import org.apache.gobblin.util.concurrent.ScheduledTask;
import org.apache.gobblin.util.concurrent.TaskScheduler;
import org.apache.gobblin.util.concurrent.TaskSchedulerType;

public class TaskSchedulerFactory {
    private TaskSchedulerFactory() {
    }

    public static <K, T extends ScheduledTask<K>> TaskScheduler<K, T> get(String type, Optional<String> name) {
        TaskSchedulerType taskSchedulerType = TaskSchedulerType.parse(type);
        return TaskSchedulerFactory.get(taskSchedulerType, name);
    }

    public static <K, T extends ScheduledTask<K>> TaskScheduler<K, T> get(TaskSchedulerType type, Optional<String> name) {
        try {
            TaskScheduler taskScheduler = type.getTaskSchedulerClass().newInstance();
            taskScheduler.start(name);
            return taskScheduler;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate task scheduler '" + name + "'.", e);
        }
    }
}

