/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.gobblin.configuration.State;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SerializationUtils {
    private static final BaseEncoding DEFAULT_ENCODING = BaseEncoding.base64();

    public static <T extends Serializable> String serialize(T obj) throws IOException {
        return SerializationUtils.serialize(obj, DEFAULT_ENCODING);
    }

    public static <T extends Serializable> String serialize(T obj, BaseEncoding enc) throws IOException {
        return enc.encode(SerializationUtils.serializeIntoBytes(obj));
    }

    /*
     * Exception decompiling
     */
    public static <T extends Serializable> byte[] serializeIntoBytes(T obj) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T extends Serializable> T deserialize(String serialized, Class<T> clazz) throws IOException {
        return SerializationUtils.deserialize(serialized, clazz, DEFAULT_ENCODING);
    }

    public static <T extends Serializable> T deserialize(String serialized, Class<T> clazz, BaseEncoding enc) throws IOException {
        return SerializationUtils.deserializeFromBytes(enc.decode((CharSequence)serialized), clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T deserializeFromBytes(byte[] serialized, Class<T> clazz) throws IOException {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(serialized));){
            Serializable serializable = (Serializable)clazz.cast(ois.readObject());
            return (T)serializable;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static <T extends State> void serializeState(FileSystem fs, Path jobStateFilePath, T state) throws IOException {
        SerializationUtils.serializeState(fs, jobStateFilePath, state, fs.getDefaultReplication(jobStateFilePath));
    }

    public static <T extends State> void serializeState(FileSystem fs, Path jobStateFilePath, T state, short replication) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)fs.create(jobStateFilePath, replication));){
            state.write((DataOutput)dataOutputStream);
        }
    }

    public static <T extends State> void deserializeState(FileSystem fs, Path jobStateFilePath, T state) throws IOException {
        try (FSDataInputStream is = fs.open(jobStateFilePath);){
            SerializationUtils.deserializeStateFromInputStream((InputStream)is, state);
        }
    }

    public static <T extends State> void deserializeStateFromInputStream(InputStream is, T state) throws IOException {
        try (DataInputStream dis = new DataInputStream(is);){
            state.readFields((DataInput)dis);
        }
    }
}

