/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapDumpForTaskUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HeapDumpForTaskUtils.class);
    private static final String DUMP_FOLDER = "dumps";

    public static void generateDumpScript(Path dumpScript, FileSystem fs, String heapFileName, String chmod) throws IOException {
        if (fs.exists(dumpScript)) {
            LOG.info("Heap dump script already exists: " + dumpScript);
            return;
        }
        try (BufferedWriter scriptWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(dumpScript), ConfigurationKeys.DEFAULT_CHARSET_ENCODING));){
            Path dumpDir = new Path(dumpScript.getParent(), DUMP_FOLDER);
            if (!fs.exists(dumpDir)) {
                fs.mkdirs(dumpDir);
            }
            scriptWriter.write("#!/bin/sh\n");
            scriptWriter.write("if [ -n \"$HADOOP_PREFIX\" ]; then\n");
            scriptWriter.write("  ${HADOOP_PREFIX}/bin/hadoop dfs -put " + heapFileName + " " + dumpDir + "/${PWD//\\//_}.hprof\n");
            scriptWriter.write("else\n");
            scriptWriter.write("  ${HADOOP_HOME}/bin/hadoop dfs -put " + heapFileName + " " + dumpDir + "/${PWD//\\//_}.hprof\n");
            scriptWriter.write("fi\n");
        }
        catch (IOException ioe) {
            LOG.error("Heap dump script is not generated successfully.");
            if (fs.exists(dumpScript)) {
                fs.delete(dumpScript, true);
            }
            throw ioe;
        }
        Runtime.getRuntime().exec(chmod + " " + dumpScript);
    }
}

