/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util.degrader;

import com.linkedin.util.degrader.DegraderControlMBean;
import com.linkedin.util.degrader.DegraderImpl;
import java.util.Date;

public class DegraderControl
implements DegraderControlMBean {
    private final DegraderImpl _degrader;

    public DegraderControl(DegraderImpl degrader) {
        this._degrader = degrader;
    }

    @Override
    public double getCurrentDropRate() {
        return this._degrader.getStats().getCurrentDropRate();
    }

    @Override
    public double getCurrentComputedDropRate() {
        return this._degrader.getStats().getCurrentComputedDropRate();
    }

    @Override
    public boolean isHigh() {
        return this._degrader.isHigh();
    }

    @Override
    public boolean isLow() {
        return this._degrader.isLow();
    }

    @Override
    public long getCurrentCountTotal() {
        return this._degrader.getStats().getCurrentCountTotal();
    }

    @Override
    public long getCurrentNoOverrideDropCountTotal() {
        return this._degrader.getStats().getCurrentNoOverrideDropCountTotal();
    }

    @Override
    public long getCurrentDroppedCountTotal() {
        return this._degrader.getStats().getCurrentDroppedCountTotal();
    }

    @Override
    public Date getLastNotDroppedTime() {
        return new Date(this._degrader.getStats().getLastNotDroppedTime());
    }

    @Override
    public long getInterval() {
        return this._degrader.getStats().getInterval();
    }

    @Override
    public Date getIntervalEndTime() {
        return new Date(this._degrader.getStats().getIntervalEndTime());
    }

    @Override
    public double getDroppedRate() {
        return this._degrader.getStats().getDroppedRate();
    }

    @Override
    public int getCallCount() {
        return this._degrader.getStats().getCallCount();
    }

    @Override
    public long getLatency() {
        return this._degrader.getStats().getLatency();
    }

    @Override
    public double getErrorRate() {
        return this._degrader.getStats().getErrorRate();
    }

    @Override
    public long getOutstandingLatency() {
        return this._degrader.getStats().getOutstandingLatency();
    }

    @Override
    public int getOutstandingCount() {
        return this._degrader.getStats().getOutstandingCount();
    }

    @Override
    public String getName() {
        return this._degrader.getName();
    }

    @Override
    public boolean isLogEnabled() {
        return this._degrader.getConfig().isLogEnabled();
    }

    @Override
    public String getLatencyToUse() {
        return this._degrader.getConfig().getLatencyToUse().toString();
    }

    @Override
    public double getOverrideDropRate() {
        return this._degrader.getConfig().getOverrideDropRate();
    }

    @Override
    public double getMaxDropRate() {
        return this._degrader.getConfig().getMaxDropRate();
    }

    @Override
    public long getMaxDropDuration() {
        return this._degrader.getConfig().getMaxDropDuration();
    }

    @Override
    public double getUpStep() {
        return this._degrader.getConfig().getUpStep();
    }

    @Override
    public double getDownStep() {
        return this._degrader.getConfig().getDownStep();
    }

    @Override
    public int getMinCallCount() {
        return this._degrader.getConfig().getMinCallCount();
    }

    @Override
    public long getHighLatency() {
        return this._degrader.getConfig().getHighLatency();
    }

    @Override
    public long getLowLatency() {
        return this._degrader.getConfig().getLowLatency();
    }

    @Override
    public double getHighErrorRate() {
        return this._degrader.getConfig().getHighErrorRate();
    }

    @Override
    public double getLowErrorRate() {
        return this._degrader.getConfig().getLowErrorRate();
    }

    @Override
    public long getHighOutstanding() {
        return this._degrader.getConfig().getHighOutstanding();
    }

    @Override
    public long getLowOutstanding() {
        return this._degrader.getConfig().getLowOutstanding();
    }

    @Override
    public int getMinOutstandingCount() {
        return this._degrader.getConfig().getMinOutstandingCount();
    }

    public int getOverrideMinCallCount() {
        return this._degrader.getConfig().getOverrideMinCallCount();
    }

    @Override
    public void setLogEnabled(boolean logEnabled) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setLogEnabled(logEnabled);
        this._degrader.setConfig(config);
    }

    @Override
    public void setLatencyToUse(String latencyToUse) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setLatencyToUse(DegraderImpl.LatencyToUse.valueOf(latencyToUse));
        this._degrader.setConfig(config);
    }

    @Override
    public void setOverrideDropRate(double overrideDropRate) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setOverrideDropRate(overrideDropRate);
        this._degrader.setConfig(config);
    }

    @Override
    public void setMaxDropRate(double maxDropRate) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setMaxDropRate(maxDropRate);
        this._degrader.setConfig(config);
    }

    @Override
    public void setMaxDropDuration(long maxDropDuration) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setMaxDropDuration(maxDropDuration);
        this._degrader.setConfig(config);
    }

    @Override
    public void setUpStep(double upStep) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setUpStep(upStep);
        this._degrader.setConfig(config);
    }

    @Override
    public void setDownStep(double downStep) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setDownStep(downStep);
        this._degrader.setConfig(config);
    }

    @Override
    public void setMinCallCount(int minCallCount) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setMinCallCount(minCallCount);
        this._degrader.setConfig(config);
    }

    @Override
    public void setHighLatency(long highLatency) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setHighLatency(highLatency);
        this._degrader.setConfig(config);
    }

    @Override
    public void setLowLatency(long lowLatency) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setLowLatency(lowLatency);
        this._degrader.setConfig(config);
    }

    @Override
    public void setHighErrorRate(double highErrorRate) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setHighErrorRate(highErrorRate);
        this._degrader.setConfig(config);
    }

    @Override
    public void setLowErrorRate(double lowErrorRate) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setLowErrorRate(lowErrorRate);
        this._degrader.setConfig(config);
    }

    @Override
    public void setHighOutstanding(long highOutstanding) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setHighOutstanding(highOutstanding);
        this._degrader.setConfig(config);
    }

    @Override
    public void setLowOutstanding(long lowOutstanding) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setLowOutstanding(lowOutstanding);
        this._degrader.setConfig(config);
    }

    @Override
    public void setMinOutstandingCount(int minOutstandingCount) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setMinOutstandingCount(minOutstandingCount);
        this._degrader.setConfig(config);
    }

    public void setOverrideMinCallCount(int overrideMinCallCount) {
        DegraderImpl.Config config = new DegraderImpl.Config(this._degrader.getConfig());
        config.setOverrideMinCallCount(overrideMinCallCount);
        this._degrader.setConfig(config);
    }

    @Override
    public void reset() {
        this._degrader.reset();
    }
}

