/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented.writer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.writer.InstrumentedDataWriterDecorator;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.writer.DataWriter;

public class InstrumentedPartitionedDataWriterDecorator<D>
extends InstrumentedDataWriterDecorator<D> {
    public static final String PARTITION = "Partition";
    private final GenericRecord partition;

    public InstrumentedPartitionedDataWriterDecorator(DataWriter<D> writer, State state, GenericRecord partition) {
        super(writer, state);
        this.partition = partition;
    }

    @Override
    public List<Tag<?>> generateTags(State state) {
        ImmutableList.Builder tags = ImmutableList.builder().addAll((Iterable)super.generateTags(state));
        tags.add((Object)new Tag(PARTITION, (Object)this.partition));
        for (Schema.Field field : this.partition.getSchema().getFields()) {
            tags.add((Object)new Tag(field.name(), this.partition.get(field.name())));
        }
        return tags.build();
    }
}

