/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.instrumented;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.Constructs;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.fork.ForkOperator;
import org.apache.gobblin.instrumented.Instrumentable;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.GobblinMetricsRegistry;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.qualitychecker.row.RowLevelPolicy;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.util.DecoratorUtils;
import org.apache.gobblin.writer.DataWriter;

public class Instrumented
implements Instrumentable,
Closeable {
    public static final String METRIC_CONTEXT_NAME_KEY = "metrics.context.name";
    public static final Random RAND = new Random();
    private final boolean instrumentationEnabled;
    protected MetricContext metricContext;
    protected final Closer closer = Closer.create();

    public static MetricContext getMetricContext(State state, Class<?> klazz) {
        return Instrumented.getMetricContext(state, klazz, new ArrayList());
    }

    public static MetricContext getMetricContext(State state, Class<?> klazz, List<Tag<?>> tags) {
        int randomId = RAND.nextInt(Integer.MAX_VALUE);
        ArrayList generatedTags = Lists.newArrayList();
        Constructs construct = null;
        if (Converter.class.isAssignableFrom(klazz)) {
            construct = Constructs.CONVERTER;
        } else if (ForkOperator.class.isAssignableFrom(klazz)) {
            construct = Constructs.FORK_OPERATOR;
        } else if (RowLevelPolicy.class.isAssignableFrom(klazz)) {
            construct = Constructs.ROW_QUALITY_CHECKER;
        } else if (Extractor.class.isAssignableFrom(klazz)) {
            construct = Constructs.EXTRACTOR;
        } else if (DataWriter.class.isAssignableFrom(klazz)) {
            construct = Constructs.WRITER;
        }
        if (construct != null) {
            generatedTags.add(new Tag("construct", (Object)construct.toString()));
        }
        if (!klazz.isAnonymousClass()) {
            generatedTags.add(new Tag("class", (Object)klazz.getCanonicalName()));
        }
        Optional gobblinMetrics = state.contains(METRIC_CONTEXT_NAME_KEY) ? GobblinMetricsRegistry.getInstance().get(state.getProp(METRIC_CONTEXT_NAME_KEY)) : Optional.absent();
        MetricContext.Builder builder = gobblinMetrics.isPresent() ? ((GobblinMetrics)gobblinMetrics.get()).getMetricContext().childBuilder(klazz.getCanonicalName() + "." + randomId) : MetricContext.builder((String)(klazz.getCanonicalName() + "." + randomId));
        return builder.addTags((Collection)generatedTags).addTags(tags).build();
    }

    public static MetricContext newContextFromReferenceContext(MetricContext context, List<Tag<?>> newTags, Optional<String> name) {
        String newName = (String)name.orNull();
        if (Strings.isNullOrEmpty((String)newName)) {
            ArrayList splitName;
            UUID uuid = UUID.randomUUID();
            String randomIdPrefix = "uuid:";
            String oldName = context.getName();
            ArrayList arrayList = splitName = Strings.isNullOrEmpty((String)oldName) ? Lists.newArrayList() : Lists.newArrayList((Iterable)Splitter.on((String)".").splitToList((CharSequence)oldName));
            if (splitName.size() > 0 && StringUtils.startsWith((CharSequence)((CharSequence)Iterables.getLast((Iterable)splitName)), (CharSequence)randomIdPrefix)) {
                splitName.set(splitName.size() - 1, String.format("%s%s", randomIdPrefix, uuid.toString()));
            } else {
                splitName.add(String.format("%s%s", randomIdPrefix, uuid.toString()));
            }
            newName = Joiner.on((String)".").join((Iterable)splitName);
        }
        MetricContext.Builder builder = context.getParent().isPresent() ? ((MetricContext)context.getParent().get()).childBuilder(newName) : MetricContext.builder((String)newName);
        return builder.addTags((Collection)context.getTags()).addTags(newTags).build();
    }

    public static boolean isLineageInstrumented(Object obj) {
        List lineage = DecoratorUtils.getDecoratorLineage((Object)obj);
        for (Object node : lineage) {
            if (!(node instanceof Instrumentable)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Timer.Context> timerContext(Optional<MetricContext> context, final String name) {
        return context.transform((Function)new Function<MetricContext, Timer.Context>(){

            public Timer.Context apply(@Nonnull MetricContext input) {
                return input.timer(name).time();
            }
        });
    }

    public static void endTimer(Optional<Timer.Context> timer) {
        timer.transform((Function)new Function<Timer.Context, Timer.Context>(){

            public Timer.Context apply(@Nonnull Timer.Context input) {
                input.close();
                return input;
            }
        });
    }

    public static void updateTimer(Optional<Timer> timer, final long duration, final TimeUnit unit) {
        timer.transform((Function)new Function<Timer, Timer>(){

            public Timer apply(@Nonnull Timer input) {
                input.update(duration, unit);
                return input;
            }
        });
    }

    public static void markMeter(Optional<Meter> meter) {
        Instrumented.markMeter(meter, 1L);
    }

    public static void markMeter(Optional<Meter> meter, final long value) {
        meter.transform((Function)new Function<Meter, Meter>(){

            public Meter apply(@Nonnull Meter input) {
                input.mark(value);
                return input;
            }
        });
    }

    public static void setMetricContextName(State state, String name) {
        state.setProp(METRIC_CONTEXT_NAME_KEY, (Object)name);
    }

    public Instrumented(State state, Class<?> klazz) {
        this(state, klazz, (List<Tag<?>>)ImmutableList.of());
    }

    public Instrumented(State state, Class<?> klazz, List<Tag<?>> tags) {
        this.instrumentationEnabled = GobblinMetrics.isEnabled((State)state);
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.getMetricContext(state, klazz, tags));
    }

    @Override
    public List<Tag<?>> generateTags(State state) {
        return Lists.newArrayList();
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return this.instrumentationEnabled;
    }

    @Override
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    @Override
    public void switchMetricContext(List<Tag<?>> tags) {
        this.metricContext = (MetricContext)this.closer.register((Closeable)Instrumented.newContextFromReferenceContext(this.metricContext, tags, (Optional<String>)Optional.absent()));
    }

    @Override
    public void switchMetricContext(MetricContext context) {
        this.metricContext = context;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

