/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.rest;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.gobblin.rest.TableTypeEnum;

public class Table
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"Table\",\"namespace\":\"org.apache.gobblin.rest\",\"doc\":\"Gobblin table definition\",\"fields\":[{\"name\":\"namespace\",\"type\":\"string\",\"doc\":\"Table namespace\",\"optional\":true},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Table name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"TableTypeEnum\",\"symbols\":[\"SNAPSHOT_ONLY\",\"SNAPSHOT_APPEND\",\"APPEND_ONLY\"]},\"doc\":\"Table type\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_Namespace = SCHEMA.getField("namespace");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");

    public Table() {
        super(new DataMap(), SCHEMA);
    }

    public Table(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasNamespace() {
        return this.contains(FIELD_Namespace);
    }

    public void removeNamespace() {
        this.remove(FIELD_Namespace);
    }

    public String getNamespace(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Namespace, String.class, mode);
    }

    @Nullable
    public String getNamespace() {
        return (String)this.obtainDirect(FIELD_Namespace, String.class, GetMode.STRICT);
    }

    public Table setNamespace(String value, SetMode mode) {
        this.putDirect(FIELD_Namespace, String.class, String.class, value, mode);
        return this;
    }

    public Table setNamespace(@Nonnull String value) {
        this.putDirect(FIELD_Namespace, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasName() {
        return this.contains(FIELD_Name);
    }

    public void removeName() {
        this.remove(FIELD_Name);
    }

    public String getName(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Name, String.class, mode);
    }

    @Nonnull
    public String getName() {
        return (String)this.obtainDirect(FIELD_Name, String.class, GetMode.STRICT);
    }

    public Table setName(String value, SetMode mode) {
        this.putDirect(FIELD_Name, String.class, String.class, value, mode);
        return this;
    }

    public Table setName(@Nonnull String value) {
        this.putDirect(FIELD_Name, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasType() {
        return this.contains(FIELD_Type);
    }

    public void removeType() {
        this.remove(FIELD_Type);
    }

    public TableTypeEnum getType(GetMode mode) {
        return (TableTypeEnum)((Object)this.obtainDirect(FIELD_Type, TableTypeEnum.class, mode));
    }

    @Nullable
    public TableTypeEnum getType() {
        return (TableTypeEnum)((Object)this.obtainDirect(FIELD_Type, TableTypeEnum.class, GetMode.STRICT));
    }

    public Table setType(TableTypeEnum value, SetMode mode) {
        this.putDirect(FIELD_Type, TableTypeEnum.class, String.class, (Object)value, mode);
        return this;
    }

    public Table setType(@Nonnull TableTypeEnum value) {
        this.putDirect(FIELD_Type, TableTypeEnum.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public Table clone() throws CloneNotSupportedException {
        return (Table)super.clone();
    }

    public Table copy() throws CloneNotSupportedException {
        return (Table)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec namespace() {
            return new PathSpec(this.getPathComponents(), "namespace");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }
    }
}

