/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.rest;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.gobblin.rest.JobStateEnum;
import org.apache.gobblin.rest.LauncherTypeEnum;
import org.apache.gobblin.rest.MetricArray;
import org.apache.gobblin.rest.TaskExecutionInfoArray;

public class JobExecutionInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"JobExecutionInfo\",\"namespace\":\"org.apache.gobblin.rest\",\"doc\":\"Gobblin job execution information\",\"fields\":[{\"name\":\"jobName\",\"type\":\"string\",\"doc\":\"Job name\"},{\"name\":\"jobId\",\"type\":\"string\",\"doc\":\"Job ID\"},{\"name\":\"startTime\",\"type\":\"long\",\"doc\":\"Job start time (epoch time)\",\"optional\":true},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"Job end time (epoch time)\",\"optional\":true},{\"name\":\"duration\",\"type\":\"long\",\"doc\":\"Job duration in milliseconds\",\"optional\":true},{\"name\":\"state\",\"type\":{\"type\":\"enum\",\"name\":\"JobStateEnum\",\"symbols\":[\"PENDING\",\"RUNNING\",\"SUCCESSFUL\",\"COMMITTED\",\"FAILED\",\"CANCELLED\"]},\"doc\":\"Job state\",\"optional\":true},{\"name\":\"launchedTasks\",\"type\":\"int\",\"doc\":\"Number of launched tasks\",\"optional\":true},{\"name\":\"completedTasks\",\"type\":\"int\",\"doc\":\"Number of completed tasks\",\"optional\":true},{\"name\":\"launcherType\",\"type\":{\"type\":\"enum\",\"name\":\"LauncherTypeEnum\",\"symbols\":[\"LOCAL\",\"MAPREDUCE\",\"CLUSTER\",\"YARN\"]},\"doc\":\"Job launcher type\",\"optional\":true},{\"name\":\"trackingUrl\",\"type\":\"string\",\"doc\":\"Job execution tracking URL\",\"optional\":true},{\"name\":\"taskExecutions\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"TaskExecutionInfo\",\"doc\":\"Gobblin task execution information\",\"fields\":[{\"name\":\"jobId\",\"type\":\"string\",\"doc\":\"Job ID\"},{\"name\":\"taskId\",\"type\":\"string\",\"doc\":\"Task ID\"},{\"name\":\"startTime\",\"type\":\"long\",\"doc\":\"Task start time (epoch time)\",\"optional\":true},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"Task end time (epoch time)\",\"optional\":true},{\"name\":\"duration\",\"type\":\"long\",\"doc\":\"Task duration in milliseconds\",\"optional\":true},{\"name\":\"state\",\"type\":{\"type\":\"enum\",\"name\":\"TaskStateEnum\",\"symbols\":[\"PENDING\",\"RUNNING\",\"SUCCESSFUL\",\"COMMITTED\",\"FAILED\",\"CANCELLED\"]},\"doc\":\"Task state\",\"optional\":true},{\"name\":\"failureException\",\"type\":\"string\",\"doc\":\"Task failure exception message\",\"optional\":true},{\"name\":\"lowWatermark\",\"type\":\"long\",\"doc\":\"Low watermark\",\"optional\":true},{\"name\":\"highWatermark\",\"type\":\"long\",\"doc\":\"High watermark\",\"optional\":true},{\"name\":\"table\",\"type\":{\"type\":\"record\",\"name\":\"Table\",\"doc\":\"Gobblin table definition\",\"fields\":[{\"name\":\"namespace\",\"type\":\"string\",\"doc\":\"Table namespace\",\"optional\":true},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Table name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"TableTypeEnum\",\"symbols\":[\"SNAPSHOT_ONLY\",\"SNAPSHOT_APPEND\",\"APPEND_ONLY\"]},\"doc\":\"Table type\",\"optional\":true}]},\"doc\":\"Table definition\",\"optional\":true},{\"name\":\"taskProperties\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Task properties\",\"optional\":true},{\"name\":\"metrics\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Metric\",\"doc\":\"Gobblin metric\",\"fields\":[{\"name\":\"group\",\"type\":\"string\",\"doc\":\"Metric group\"},{\"name\":\"name\",\"type\":\"string\",\"doc\":\"Metric name\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"MetricTypeEnum\",\"symbols\":[\"COUNTER\",\"METER\",\"GAUGE\"]},\"doc\":\"Metric type\"},{\"name\":\"value\",\"type\":\"string\",\"doc\":\"Metric value\"}]}},\"doc\":\"Job metrics\"}]}},\"doc\":\"An array of task execution information records\"},{\"name\":\"jobProperties\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"Job properties\",\"optional\":true},{\"name\":\"metrics\",\"type\":{\"type\":\"array\",\"items\":\"Metric\"},\"doc\":\"Job metrics\"}]}");
    private static final RecordDataSchema.Field FIELD_JobName = SCHEMA.getField("jobName");
    private static final RecordDataSchema.Field FIELD_JobId = SCHEMA.getField("jobId");
    private static final RecordDataSchema.Field FIELD_StartTime = SCHEMA.getField("startTime");
    private static final RecordDataSchema.Field FIELD_EndTime = SCHEMA.getField("endTime");
    private static final RecordDataSchema.Field FIELD_Duration = SCHEMA.getField("duration");
    private static final RecordDataSchema.Field FIELD_State = SCHEMA.getField("state");
    private static final RecordDataSchema.Field FIELD_LaunchedTasks = SCHEMA.getField("launchedTasks");
    private static final RecordDataSchema.Field FIELD_CompletedTasks = SCHEMA.getField("completedTasks");
    private static final RecordDataSchema.Field FIELD_LauncherType = SCHEMA.getField("launcherType");
    private static final RecordDataSchema.Field FIELD_TrackingUrl = SCHEMA.getField("trackingUrl");
    private static final RecordDataSchema.Field FIELD_TaskExecutions = SCHEMA.getField("taskExecutions");
    private static final RecordDataSchema.Field FIELD_JobProperties = SCHEMA.getField("jobProperties");
    private static final RecordDataSchema.Field FIELD_Metrics = SCHEMA.getField("metrics");

    public JobExecutionInfo() {
        super(new DataMap(), SCHEMA);
    }

    public JobExecutionInfo(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasJobName() {
        return this.contains(FIELD_JobName);
    }

    public void removeJobName() {
        this.remove(FIELD_JobName);
    }

    public String getJobName(GetMode mode) {
        return (String)this.obtainDirect(FIELD_JobName, String.class, mode);
    }

    @Nonnull
    public String getJobName() {
        return (String)this.obtainDirect(FIELD_JobName, String.class, GetMode.STRICT);
    }

    public JobExecutionInfo setJobName(String value, SetMode mode) {
        this.putDirect(FIELD_JobName, String.class, String.class, value, mode);
        return this;
    }

    public JobExecutionInfo setJobName(@Nonnull String value) {
        this.putDirect(FIELD_JobName, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasJobId() {
        return this.contains(FIELD_JobId);
    }

    public void removeJobId() {
        this.remove(FIELD_JobId);
    }

    public String getJobId(GetMode mode) {
        return (String)this.obtainDirect(FIELD_JobId, String.class, mode);
    }

    @Nonnull
    public String getJobId() {
        return (String)this.obtainDirect(FIELD_JobId, String.class, GetMode.STRICT);
    }

    public JobExecutionInfo setJobId(String value, SetMode mode) {
        this.putDirect(FIELD_JobId, String.class, String.class, value, mode);
        return this;
    }

    public JobExecutionInfo setJobId(@Nonnull String value) {
        this.putDirect(FIELD_JobId, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasStartTime() {
        return this.contains(FIELD_StartTime);
    }

    public void removeStartTime() {
        this.remove(FIELD_StartTime);
    }

    public Long getStartTime(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_StartTime, Long.class, mode);
    }

    @Nullable
    public Long getStartTime() {
        return (Long)this.obtainDirect(FIELD_StartTime, Long.class, GetMode.STRICT);
    }

    public JobExecutionInfo setStartTime(Long value, SetMode mode) {
        this.putDirect(FIELD_StartTime, Long.class, Long.class, value, mode);
        return this;
    }

    public JobExecutionInfo setStartTime(@Nonnull Long value) {
        this.putDirect(FIELD_StartTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionInfo setStartTime(long value) {
        this.putDirect(FIELD_StartTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasEndTime() {
        return this.contains(FIELD_EndTime);
    }

    public void removeEndTime() {
        this.remove(FIELD_EndTime);
    }

    public Long getEndTime(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_EndTime, Long.class, mode);
    }

    @Nullable
    public Long getEndTime() {
        return (Long)this.obtainDirect(FIELD_EndTime, Long.class, GetMode.STRICT);
    }

    public JobExecutionInfo setEndTime(Long value, SetMode mode) {
        this.putDirect(FIELD_EndTime, Long.class, Long.class, value, mode);
        return this;
    }

    public JobExecutionInfo setEndTime(@Nonnull Long value) {
        this.putDirect(FIELD_EndTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionInfo setEndTime(long value) {
        this.putDirect(FIELD_EndTime, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDuration() {
        return this.contains(FIELD_Duration);
    }

    public void removeDuration() {
        this.remove(FIELD_Duration);
    }

    public Long getDuration(GetMode mode) {
        return (Long)this.obtainDirect(FIELD_Duration, Long.class, mode);
    }

    @Nullable
    public Long getDuration() {
        return (Long)this.obtainDirect(FIELD_Duration, Long.class, GetMode.STRICT);
    }

    public JobExecutionInfo setDuration(Long value, SetMode mode) {
        this.putDirect(FIELD_Duration, Long.class, Long.class, value, mode);
        return this;
    }

    public JobExecutionInfo setDuration(@Nonnull Long value) {
        this.putDirect(FIELD_Duration, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionInfo setDuration(long value) {
        this.putDirect(FIELD_Duration, Long.class, Long.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasState() {
        return this.contains(FIELD_State);
    }

    public void removeState() {
        this.remove(FIELD_State);
    }

    public JobStateEnum getState(GetMode mode) {
        return (JobStateEnum)((Object)this.obtainDirect(FIELD_State, JobStateEnum.class, mode));
    }

    @Nullable
    public JobStateEnum getState() {
        return (JobStateEnum)((Object)this.obtainDirect(FIELD_State, JobStateEnum.class, GetMode.STRICT));
    }

    public JobExecutionInfo setState(JobStateEnum value, SetMode mode) {
        this.putDirect(FIELD_State, JobStateEnum.class, String.class, (Object)value, mode);
        return this;
    }

    public JobExecutionInfo setState(@Nonnull JobStateEnum value) {
        this.putDirect(FIELD_State, JobStateEnum.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLaunchedTasks() {
        return this.contains(FIELD_LaunchedTasks);
    }

    public void removeLaunchedTasks() {
        this.remove(FIELD_LaunchedTasks);
    }

    public Integer getLaunchedTasks(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_LaunchedTasks, Integer.class, mode);
    }

    @Nullable
    public Integer getLaunchedTasks() {
        return (Integer)this.obtainDirect(FIELD_LaunchedTasks, Integer.class, GetMode.STRICT);
    }

    public JobExecutionInfo setLaunchedTasks(Integer value, SetMode mode) {
        this.putDirect(FIELD_LaunchedTasks, Integer.class, Integer.class, value, mode);
        return this;
    }

    public JobExecutionInfo setLaunchedTasks(@Nonnull Integer value) {
        this.putDirect(FIELD_LaunchedTasks, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionInfo setLaunchedTasks(int value) {
        this.putDirect(FIELD_LaunchedTasks, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasCompletedTasks() {
        return this.contains(FIELD_CompletedTasks);
    }

    public void removeCompletedTasks() {
        this.remove(FIELD_CompletedTasks);
    }

    public Integer getCompletedTasks(GetMode mode) {
        return (Integer)this.obtainDirect(FIELD_CompletedTasks, Integer.class, mode);
    }

    @Nullable
    public Integer getCompletedTasks() {
        return (Integer)this.obtainDirect(FIELD_CompletedTasks, Integer.class, GetMode.STRICT);
    }

    public JobExecutionInfo setCompletedTasks(Integer value, SetMode mode) {
        this.putDirect(FIELD_CompletedTasks, Integer.class, Integer.class, value, mode);
        return this;
    }

    public JobExecutionInfo setCompletedTasks(@Nonnull Integer value) {
        this.putDirect(FIELD_CompletedTasks, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionInfo setCompletedTasks(int value) {
        this.putDirect(FIELD_CompletedTasks, Integer.class, Integer.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasLauncherType() {
        return this.contains(FIELD_LauncherType);
    }

    public void removeLauncherType() {
        this.remove(FIELD_LauncherType);
    }

    public LauncherTypeEnum getLauncherType(GetMode mode) {
        return (LauncherTypeEnum)((Object)this.obtainDirect(FIELD_LauncherType, LauncherTypeEnum.class, mode));
    }

    @Nullable
    public LauncherTypeEnum getLauncherType() {
        return (LauncherTypeEnum)((Object)this.obtainDirect(FIELD_LauncherType, LauncherTypeEnum.class, GetMode.STRICT));
    }

    public JobExecutionInfo setLauncherType(LauncherTypeEnum value, SetMode mode) {
        this.putDirect(FIELD_LauncherType, LauncherTypeEnum.class, String.class, (Object)value, mode);
        return this;
    }

    public JobExecutionInfo setLauncherType(@Nonnull LauncherTypeEnum value) {
        this.putDirect(FIELD_LauncherType, LauncherTypeEnum.class, String.class, (Object)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasTrackingUrl() {
        return this.contains(FIELD_TrackingUrl);
    }

    public void removeTrackingUrl() {
        this.remove(FIELD_TrackingUrl);
    }

    public String getTrackingUrl(GetMode mode) {
        return (String)this.obtainDirect(FIELD_TrackingUrl, String.class, mode);
    }

    @Nullable
    public String getTrackingUrl() {
        return (String)this.obtainDirect(FIELD_TrackingUrl, String.class, GetMode.STRICT);
    }

    public JobExecutionInfo setTrackingUrl(String value, SetMode mode) {
        this.putDirect(FIELD_TrackingUrl, String.class, String.class, value, mode);
        return this;
    }

    public JobExecutionInfo setTrackingUrl(@Nonnull String value) {
        this.putDirect(FIELD_TrackingUrl, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasTaskExecutions() {
        return this.contains(FIELD_TaskExecutions);
    }

    public void removeTaskExecutions() {
        this.remove(FIELD_TaskExecutions);
    }

    public TaskExecutionInfoArray getTaskExecutions(GetMode mode) {
        return (TaskExecutionInfoArray)this.obtainWrapped(FIELD_TaskExecutions, TaskExecutionInfoArray.class, mode);
    }

    @Nonnull
    public TaskExecutionInfoArray getTaskExecutions() {
        return (TaskExecutionInfoArray)this.obtainWrapped(FIELD_TaskExecutions, TaskExecutionInfoArray.class, GetMode.STRICT);
    }

    public JobExecutionInfo setTaskExecutions(TaskExecutionInfoArray value, SetMode mode) {
        this.putWrapped(FIELD_TaskExecutions, TaskExecutionInfoArray.class, (DataTemplate)value, mode);
        return this;
    }

    public JobExecutionInfo setTaskExecutions(@Nonnull TaskExecutionInfoArray value) {
        this.putWrapped(FIELD_TaskExecutions, TaskExecutionInfoArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasJobProperties() {
        return this.contains(FIELD_JobProperties);
    }

    public void removeJobProperties() {
        this.remove(FIELD_JobProperties);
    }

    public StringMap getJobProperties(GetMode mode) {
        return (StringMap)this.obtainWrapped(FIELD_JobProperties, StringMap.class, mode);
    }

    @Nullable
    public StringMap getJobProperties() {
        return (StringMap)this.obtainWrapped(FIELD_JobProperties, StringMap.class, GetMode.STRICT);
    }

    public JobExecutionInfo setJobProperties(StringMap value, SetMode mode) {
        this.putWrapped(FIELD_JobProperties, StringMap.class, (DataTemplate)value, mode);
        return this;
    }

    public JobExecutionInfo setJobProperties(@Nonnull StringMap value) {
        this.putWrapped(FIELD_JobProperties, StringMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMetrics() {
        return this.contains(FIELD_Metrics);
    }

    public void removeMetrics() {
        this.remove(FIELD_Metrics);
    }

    public MetricArray getMetrics(GetMode mode) {
        return (MetricArray)this.obtainWrapped(FIELD_Metrics, MetricArray.class, mode);
    }

    @Nonnull
    public MetricArray getMetrics() {
        return (MetricArray)this.obtainWrapped(FIELD_Metrics, MetricArray.class, GetMode.STRICT);
    }

    public JobExecutionInfo setMetrics(MetricArray value, SetMode mode) {
        this.putWrapped(FIELD_Metrics, MetricArray.class, (DataTemplate)value, mode);
        return this;
    }

    public JobExecutionInfo setMetrics(@Nonnull MetricArray value) {
        this.putWrapped(FIELD_Metrics, MetricArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public JobExecutionInfo clone() throws CloneNotSupportedException {
        return (JobExecutionInfo)super.clone();
    }

    public JobExecutionInfo copy() throws CloneNotSupportedException {
        return (JobExecutionInfo)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec jobName() {
            return new PathSpec(this.getPathComponents(), "jobName");
        }

        public PathSpec jobId() {
            return new PathSpec(this.getPathComponents(), "jobId");
        }

        public PathSpec startTime() {
            return new PathSpec(this.getPathComponents(), "startTime");
        }

        public PathSpec endTime() {
            return new PathSpec(this.getPathComponents(), "endTime");
        }

        public PathSpec duration() {
            return new PathSpec(this.getPathComponents(), "duration");
        }

        public PathSpec state() {
            return new PathSpec(this.getPathComponents(), "state");
        }

        public PathSpec launchedTasks() {
            return new PathSpec(this.getPathComponents(), "launchedTasks");
        }

        public PathSpec completedTasks() {
            return new PathSpec(this.getPathComponents(), "completedTasks");
        }

        public PathSpec launcherType() {
            return new PathSpec(this.getPathComponents(), "launcherType");
        }

        public PathSpec trackingUrl() {
            return new PathSpec(this.getPathComponents(), "trackingUrl");
        }

        public TaskExecutionInfoArray.Fields taskExecutions() {
            return new TaskExecutionInfoArray.Fields(this.getPathComponents(), "taskExecutions");
        }

        public PathSpec jobProperties() {
            return new PathSpec(this.getPathComponents(), "jobProperties");
        }

        public MetricArray.Fields metrics() {
            return new MetricArray.Fields(this.getPathComponents(), "metrics");
        }
    }
}

