/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.AsyncHttpJoinConverter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.http.HttpOperation;
import org.apache.gobblin.http.HttpRequestResponseRecord;
import org.apache.gobblin.http.ResponseStatus;
import org.apache.gobblin.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AvroHttpJoinConverter<RQ, RP>
extends AsyncHttpJoinConverter<Schema, Schema, GenericRecord, GenericRecord, RQ, RP> {
    private static final Logger log = LoggerFactory.getLogger(AvroHttpJoinConverter.class);
    public static final String HTTP_REQUEST_RESPONSE_FIELD = "HttpRequestResponse";

    @Override
    public Schema convertSchemaImpl(Schema inputSchema, WorkUnitState workUnitState) throws SchemaConversionException {
        if (inputSchema == null) {
            throw new SchemaConversionException("input schema is empty");
        }
        ArrayList fields = Lists.newArrayList();
        for (Schema.Field field : inputSchema.getFields()) {
            Schema.Field newField = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue(), field.order());
            fields.add(newField);
        }
        Schema.Field requestResponseField = new Schema.Field(HTTP_REQUEST_RESPONSE_FIELD, HttpRequestResponseRecord.getClassSchema(), "http output schema contains request url and return result", null);
        fields.add(requestResponseField);
        Schema combinedSchema = Schema.createRecord((String)inputSchema.getName(), (String)(inputSchema.getDoc() + " (Http request and response are contained)"), (String)inputSchema.getNamespace(), (boolean)false);
        combinedSchema.setFields((List)fields);
        return combinedSchema;
    }

    @Override
    protected HttpOperation generateHttpOperation(GenericRecord inputRecord, State state) {
        HttpOperation operation;
        HashMap<String, String> keyAndValue = new HashMap<String, String>();
        Optional<Iterable<String>> keys = this.getKeys(state);
        if (keys.isPresent()) {
            for (String key : keys.get()) {
                String value = inputRecord.get(key).toString();
                log.debug("Http join converter: key is {}, value is {}", (Object)key, (Object)value);
                keyAndValue.put(key, value);
            }
            operation = new HttpOperation();
            operation.setKeys(keyAndValue);
        } else {
            operation = HttpUtils.toHttpOperation(inputRecord);
        }
        return operation;
    }

    private Optional<Iterable<String>> getKeys(State state) {
        if (!state.contains("gobblin.converter.http.keys")) {
            return Optional.empty();
        }
        List keys = state.getPropAsList("gobblin.converter.http.keys");
        return Optional.ofNullable(keys);
    }

    @Override
    public final GenericRecord convertRecordImpl(Schema outputSchema, GenericRecord inputRecord, RQ rawRequest, ResponseStatus status) throws DataConversionException {
        if (outputSchema == null) {
            throw new DataConversionException("output schema is empty");
        }
        GenericData.Record outputRecord = new GenericData.Record(outputSchema);
        Schema httpOutputSchema = null;
        for (Schema.Field field : outputSchema.getFields()) {
            if (!field.name().equals(HTTP_REQUEST_RESPONSE_FIELD)) {
                log.debug("Copy {}", (Object)field.name());
                Object inputValue = inputRecord.get(field.name());
                outputRecord.put(field.name(), inputValue);
                continue;
            }
            httpOutputSchema = field.schema();
        }
        try {
            this.fillHttpOutputData(httpOutputSchema, (GenericRecord)outputRecord, rawRequest, status);
        }
        catch (IOException e) {
            throw new DataConversionException((Throwable)e);
        }
        return outputRecord;
    }

    protected abstract void fillHttpOutputData(Schema var1, GenericRecord var2, RQ var3, ResponseStatus var4) throws IOException;
}

