/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metastore;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.gobblin.metastore.JobHistoryStore;
import org.apache.gobblin.metastore.database.SupportedDatabaseVersion;
import org.apache.gobblin.metastore.database.VersionedDatabaseJobHistoryStore;
import org.apache.gobblin.rest.JobExecutionInfo;
import org.apache.gobblin.rest.JobExecutionQuery;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class DatabaseJobHistoryStore
implements JobHistoryStore {
    private static final Reflections reflections = new Reflections(DatabaseJobHistoryStore.getConfigurationBuilder());
    private final VersionedDatabaseJobHistoryStore versionedStore;

    @Inject
    public DatabaseJobHistoryStore(DataSource dataSource) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        MigrationVersion databaseVersion = DatabaseJobHistoryStore.getDatabaseVersion(dataSource);
        this.versionedStore = DatabaseJobHistoryStore.findVersionedDatabaseJobHistoryStore(databaseVersion);
        this.versionedStore.init(dataSource);
    }

    @Override
    public synchronized void put(JobExecutionInfo jobExecutionInfo) throws IOException {
        this.versionedStore.put(jobExecutionInfo);
    }

    @Override
    public synchronized List<JobExecutionInfo> get(JobExecutionQuery query) throws IOException {
        return this.versionedStore.get(query);
    }

    @Override
    public void close() throws IOException {
        this.versionedStore.close();
    }

    private static MigrationVersion getDatabaseVersion(DataSource dataSource) throws FlywayException {
        Flyway flyway = new Flyway();
        flyway.setDataSource(dataSource);
        MigrationInfoService info = flyway.info();
        MigrationVersion currentVersion = MigrationVersion.EMPTY;
        if (info.current() != null) {
            currentVersion = info.current().getVersion();
        }
        return currentVersion;
    }

    private static Collection<URL> effectiveClassPathUrls(ClassLoader ... classLoaders) {
        return ClasspathHelper.forManifest((Iterable)ClasspathHelper.forClassLoader((ClassLoader[])classLoaders));
    }

    private static Configuration getConfigurationBuilder() {
        ConfigurationBuilder configurationBuilder = ConfigurationBuilder.build((Object[])new Object[]{"org.apache.gobblin.metastore.database", DatabaseJobHistoryStore.effectiveClassPathUrls(DatabaseJobHistoryStore.class.getClassLoader())});
        ArrayList filteredUrls = Lists.newArrayList((Iterable)Iterables.filter((Iterable)configurationBuilder.getUrls(), (Predicate)new Predicate<URL>(){

            public boolean apply(@Nullable URL input) {
                return input != null && (!input.getProtocol().equals("file") || new File(input.getFile()).exists());
            }
        }));
        configurationBuilder.setUrls((Collection)filteredUrls);
        return configurationBuilder;
    }

    private static VersionedDatabaseJobHistoryStore findVersionedDatabaseJobHistoryStore(MigrationVersion requiredVersion) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class foundClazz = null;
        Class defaultClazz = null;
        MigrationVersion defaultVersion = MigrationVersion.EMPTY;
        for (Class clazz : Sets.intersection((Set)reflections.getTypesAnnotatedWith(SupportedDatabaseVersion.class), (Set)reflections.getSubTypesOf(VersionedDatabaseJobHistoryStore.class))) {
            SupportedDatabaseVersion annotation = clazz.getAnnotation(SupportedDatabaseVersion.class);
            String version = annotation.version();
            MigrationVersion actualVersion = MigrationVersion.fromVersion((String)(Strings.isNullOrEmpty((String)version) ? null : version));
            if (annotation.isDefault() && actualVersion.compareTo(defaultVersion) > 0) {
                defaultClazz = clazz;
                defaultVersion = actualVersion;
            }
            if (actualVersion.compareTo(requiredVersion) != 0) continue;
            foundClazz = clazz;
        }
        if (foundClazz == null) {
            foundClazz = defaultClazz;
        }
        if (foundClazz == null) {
            throw new ClassNotFoundException(String.format("Could not find an instance of %s which supports database version %s.", VersionedDatabaseJobHistoryStore.class.getSimpleName(), requiredVersion.toString()));
        }
        return (VersionedDatabaseJobHistoryStore)foundClazz.newInstance();
    }
}

