/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@Description(name="elt", value="_FUNC_(n, str1, str2, ...) - returns the n-th string", extended="Example:\n  > SELECT _FUNC_(1, 'face', 'book') FROM src LIMIT 1;\n  'face'")
public class GenericUDFElt
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int i;
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("The function ELT(N,str1,str2,str3,...) needs at least two arguments.");
        }
        for (i = 0; i < arguments.length; ++i) {
            ObjectInspector.Category category = arguments[i].getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal(i + 1) + " argument of function ELT is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        for (i = 0; i < arguments.length; ++i) {
            this.converters[i] = i == 0 ? ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector) : ObjectInspectorConverters.getConverter((ObjectInspector)arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        IntWritable intWritable = (IntWritable)this.converters[0].convert(arguments[0].get());
        if (intWritable == null) {
            return null;
        }
        int index = intWritable.get();
        if (index <= 0 || index >= arguments.length) {
            return null;
        }
        return this.converters[index].convert(arguments[index].get());
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 2);
        StringBuilder sb = new StringBuilder();
        sb.append("elt(");
        for (int i = 0; i < children.length - 1; ++i) {
            sb.append(children[i]).append(", ");
        }
        sb.append(children[children.length - 1]).append(")");
        return sb.toString();
    }
}

