/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.authorization.AuthorizationParseUtils;
import org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactory;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeRegistry;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;
import org.apache.hadoop.hive.ql.session.SessionState;

public class HiveAuthorizationTaskFactoryImpl
implements HiveAuthorizationTaskFactory {
    private final HiveConf conf;
    private final Hive db;

    public HiveAuthorizationTaskFactoryImpl(HiveConf conf, Hive db) {
        this.conf = conf;
        this.db = db;
    }

    @Override
    public Task<? extends Serializable> createCreateRoleTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) {
        String roleName = BaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        RoleDDLDesc roleDesc = new RoleDDLDesc(roleName, PrincipalType.ROLE, RoleDDLDesc.RoleOperation.CREATE_ROLE, null);
        return TaskFactory.get(new DDLWork(inputs, outputs, roleDesc), this.conf, new Task[0]);
    }

    @Override
    public Task<? extends Serializable> createDropRoleTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) {
        String roleName = BaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        RoleDDLDesc roleDesc = new RoleDDLDesc(roleName, PrincipalType.ROLE, RoleDDLDesc.RoleOperation.DROP_ROLE, null);
        return TaskFactory.get(new DDLWork(inputs, outputs, roleDesc), this.conf, new Task[0]);
    }

    @Override
    public Task<? extends Serializable> createShowRoleGrantTask(ASTNode ast, Path resultFile, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) {
        ASTNode child = (ASTNode)ast.getChild(0);
        PrincipalType principalType = PrincipalType.USER;
        switch (child.getType()) {
            case 877: {
                principalType = PrincipalType.USER;
                break;
            }
            case 687: {
                principalType = PrincipalType.GROUP;
                break;
            }
            case 784: {
                principalType = PrincipalType.ROLE;
            }
        }
        String principalName = BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
        RoleDDLDesc roleDesc = new RoleDDLDesc(principalName, principalType, RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT, null);
        roleDesc.setResFile(resultFile.toString());
        return TaskFactory.get(new DDLWork(inputs, outputs, roleDesc), this.conf, new Task[0]);
    }

    @Override
    public Task<? extends Serializable> createGrantTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = AuthorizationParseUtils.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        boolean grantOption = false;
        PrivilegeObjectDesc privilegeObj = null;
        if (ast.getChildCount() > 2) {
            for (int i = 2; i < ast.getChildCount(); ++i) {
                ASTNode astChild = (ASTNode)ast.getChild(i);
                if (astChild.getType() == 686) {
                    grantOption = true;
                    continue;
                }
                if (astChild.getType() != 768) continue;
                privilegeObj = this.analyzePrivilegeObject(astChild, outputs);
            }
        }
        String userName = SessionState.getUserFromAuthenticator();
        GrantDesc grantDesc = new GrantDesc(privilegeObj, privilegeDesc, principalDesc, userName, PrincipalType.USER, grantOption);
        return TaskFactory.get(new DDLWork(inputs, outputs, grantDesc), this.conf, new Task[0]);
    }

    @Override
    public Task<? extends Serializable> createRevokeTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = AuthorizationParseUtils.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        PrivilegeObjectDesc hiveObj = null;
        boolean grantOption = false;
        if (ast.getChildCount() > 2) {
            ASTNode astChild = (ASTNode)ast.getChild(2);
            hiveObj = this.analyzePrivilegeObject(astChild, outputs);
            if (null != ast.getFirstChildWithType(683)) {
                grantOption = true;
            }
        }
        RevokeDesc revokeDesc = new RevokeDesc(privilegeDesc, principalDesc, hiveObj, grantOption);
        return TaskFactory.get(new DDLWork(inputs, outputs, revokeDesc), this.conf, new Task[0]);
    }

    @Override
    public Task<? extends Serializable> createGrantRoleTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) {
        return this.analyzeGrantRevokeRole(true, ast, inputs, outputs);
    }

    @Override
    public Task<? extends Serializable> createShowGrantTask(ASTNode ast, Path resultFile, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        PrincipalDesc principalDesc = null;
        PrivilegeObjectDesc privHiveObj = null;
        ASTNode param = null;
        if (ast.getChildCount() > 0 && (principalDesc = AuthorizationParseUtils.getPrincipalDesc(param = (ASTNode)ast.getChild(0))) != null) {
            param = (ASTNode)ast.getChild(1);
        }
        if (param != null) {
            if (param.getType() == 777) {
                privHiveObj = new PrivilegeObjectDesc();
            } else if (param.getType() == 769) {
                privHiveObj = this.parsePrivObject(param);
            }
        }
        ShowGrantDesc showGrant = new ShowGrantDesc(resultFile.toString(), principalDesc, privHiveObj);
        return TaskFactory.get(new DDLWork(inputs, outputs, showGrant), this.conf, new Task[0]);
    }

    @Override
    public Task<? extends Serializable> createRevokeRoleTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) {
        return this.analyzeGrantRevokeRole(false, ast, inputs, outputs);
    }

    private Task<? extends Serializable> analyzeGrantRevokeRole(boolean isGrant, ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) {
        List<PrincipalDesc> principalDesc = AuthorizationParseUtils.analyzePrincipalListDef((ASTNode)ast.getChild(0));
        int rolesStartPos = 1;
        ASTNode wAdminOption = (ASTNode)ast.getChild(1);
        boolean isAdmin = false;
        if (isGrant && wAdminOption.getToken().getType() == 685 || !isGrant && wAdminOption.getToken().getType() == 578) {
            rolesStartPos = 2;
            isAdmin = true;
        }
        ArrayList<String> roles = new ArrayList<String>();
        for (int i = rolesStartPos; i < ast.getChildCount(); ++i) {
            roles.add(BaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(i).getText()));
        }
        String roleOwnerName = SessionState.getUserFromAuthenticator();
        GrantRevokeRoleDDL grantRevokeRoleDDL = new GrantRevokeRoleDDL(isGrant, roles, principalDesc, roleOwnerName, PrincipalType.USER, isAdmin);
        return TaskFactory.get(new DDLWork(inputs, outputs, grantRevokeRoleDDL), this.conf, new Task[0]);
    }

    private PrivilegeObjectDesc analyzePrivilegeObject(ASTNode ast, HashSet<WriteEntity> outputs) throws SemanticException {
        PrivilegeObjectDesc subject = this.parsePrivObject(ast);
        if (subject.getTable()) {
            Table tbl = this.getTable(subject.getObject());
            if (subject.getPartSpec() != null) {
                Partition part = this.getPartition(tbl, subject.getPartSpec());
                outputs.add(new WriteEntity(part, WriteEntity.WriteType.DDL_NO_LOCK));
            } else {
                outputs.add(new WriteEntity(tbl, WriteEntity.WriteType.DDL_NO_LOCK));
            }
        }
        return subject;
    }

    private PrivilegeObjectDesc parsePrivObject(ASTNode ast) throws SemanticException {
        PrivilegeObjectDesc subject = new PrivilegeObjectDesc();
        ASTNode child = (ASTNode)ast.getChild(0);
        ASTNode gchild = (ASTNode)child.getChild(0);
        if (child.getType() == 857) {
            subject.setTable(true);
            String[] qualified = BaseSemanticAnalyzer.getQualifiedTableName(gchild);
            subject.setObject(BaseSemanticAnalyzer.getDotName(qualified));
        } else {
            subject.setTable(false);
            subject.setObject(BaseSemanticAnalyzer.unescapeIdentifier(gchild.getText()));
        }
        for (int i = 1; i < child.getChildCount(); ++i) {
            gchild = (ASTNode)child.getChild(i);
            if (gchild.getType() == 753) {
                subject.setPartSpec(DDLSemanticAnalyzer.getPartSpec(gchild));
                continue;
            }
            if (gchild.getType() != 834) continue;
            subject.setColumns(BaseSemanticAnalyzer.getColumnNames(gchild));
        }
        return subject;
    }

    private List<PrivilegeDesc> analyzePrivilegeListDef(ASTNode node) throws SemanticException {
        ArrayList<PrivilegeDesc> ret = new ArrayList<PrivilegeDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode privilegeDef = (ASTNode)node.getChild(i);
            ASTNode privilegeType = (ASTNode)privilegeDef.getChild(0);
            Privilege privObj = PrivilegeRegistry.getPrivilege(privilegeType.getType());
            if (privObj == null) {
                throw new SemanticException("Undefined privilege " + (Object)((Object)PrivilegeType.getPrivTypeByToken(privilegeType.getType())));
            }
            List<String> cols = null;
            if (privilegeDef.getChildCount() > 1) {
                cols = BaseSemanticAnalyzer.getColumnNames((ASTNode)privilegeDef.getChild(1));
            }
            PrivilegeDesc privilegeDesc = new PrivilegeDesc(privObj, cols);
            ret.add(privilegeDesc);
        }
        return ret;
    }

    private Table getTable(String tblName) throws SemanticException {
        return this.getTable(null, tblName);
    }

    private Table getTable(String database, String tblName) throws SemanticException {
        try {
            Table tab;
            Table table = tab = database == null ? this.db.getTable(tblName, false) : this.db.getTable(database, tblName, false);
            if (tab == null) {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
            }
            return tab;
        }
        catch (HiveException e) {
            if (e instanceof SemanticException) {
                throw (SemanticException)e;
            }
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName), e);
        }
    }

    private Partition getPartition(Table table, Map<String, String> partSpec) throws SemanticException {
        try {
            Partition partition = this.db.getPartition(table, partSpec, false);
            if (partition == null) {
                throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec));
            }
            return partition;
        }
        catch (HiveException e) {
            if (e instanceof SemanticException) {
                throw (SemanticException)e;
            }
            throw new SemanticException(this.toMessage(ErrorMsg.INVALID_PARTITION, partSpec), e);
        }
    }

    private String toMessage(ErrorMsg message, Object detail) {
        return detail == null ? message.getMsg() : message.getMsg(detail.toString());
    }

    @Override
    public Task<? extends Serializable> createSetRoleTask(String roleName, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        return TaskFactory.get(new DDLWork(inputs, outputs, new RoleDDLDesc(roleName, PrincipalType.ROLE, RoleDDLDesc.RoleOperation.SET_ROLE, null)), this.conf, new Task[0]);
    }

    @Override
    public Task<? extends Serializable> createShowCurrentRoleTask(HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs, Path resFile) throws SemanticException {
        RoleDDLDesc ddlDesc = new RoleDDLDesc(null, RoleDDLDesc.RoleOperation.SHOW_CURRENT_ROLE);
        ddlDesc.setResFile(resFile.toString());
        return TaskFactory.get(new DDLWork(inputs, outputs, ddlDesc), this.conf, new Task[0]);
    }

    @Override
    public Task<? extends Serializable> createShowRolePrincipalsTask(ASTNode ast, Path resFile, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        if (ast.getChildCount() != 1) {
            throw new AssertionError((Object)"Unexpected Tokens in SHOW ROLE PRINCIPALS");
        }
        String roleName = ast.getChild(0).getText();
        RoleDDLDesc roleDDLDesc = new RoleDDLDesc(roleName, PrincipalType.ROLE, RoleDDLDesc.RoleOperation.SHOW_ROLE_PRINCIPALS, null);
        roleDDLDesc.setResFile(resFile.toString());
        return TaskFactory.get(new DDLWork(inputs, outputs, roleDDLDesc), this.conf, new Task[0]);
    }

    @Override
    public Task<? extends Serializable> createShowRolesTask(ASTNode ast, Path resFile, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        RoleDDLDesc showRolesDesc = new RoleDDLDesc(null, null, RoleDDLDesc.RoleOperation.SHOW_ROLES, null);
        showRolesDesc.setResFile(resFile.toString());
        return TaskFactory.get(new DDLWork(inputs, outputs, showRolesDesc), this.conf, new Task[0]);
    }
}

