/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.translator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.optimizer.optiq.HiveOptiqUtil;
import org.apache.hadoop.hive.ql.optimizer.optiq.OptiqSemanticException;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveAggregateRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveProjectRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveSortRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.TypeConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.EmptyRel;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.OneRowRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SetOpRel;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.rules.MultiJoinRel;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.hep.HepRelVertex;
import org.eigenbase.relopt.volcano.RelSubset;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.util.Pair;

public class PlanModifierForASTConv {
    private static final Log LOG = LogFactory.getLog(PlanModifierForASTConv.class);

    public static RelNode convertOpTree(RelNode rel, List<FieldSchema> resultSchema) throws OptiqSemanticException {
        RelNode newTopNode = rel;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Original plan for PlanModifier\n " + RelOptUtil.toString((RelNode)newTopNode)));
        }
        if (!(newTopNode instanceof ProjectRelBase) && !(newTopNode instanceof SortRel)) {
            newTopNode = PlanModifierForASTConv.introduceDerivedTable(newTopNode);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Plan after top-level introduceDerivedTable\n " + RelOptUtil.toString((RelNode)newTopNode)));
            }
        }
        PlanModifierForASTConv.convertOpTree(newTopNode, (RelNode)null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Plan after nested convertOpTree\n " + RelOptUtil.toString((RelNode)newTopNode)));
        }
        Pair<RelNode, RelNode> topSelparentPair = HiveOptiqUtil.getTopLevelSelect(newTopNode);
        PlanModifierForASTConv.fixTopOBSchema(newTopNode, topSelparentPair, resultSchema);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Plan after fixTopOBSchema\n " + RelOptUtil.toString((RelNode)newTopNode)));
        }
        topSelparentPair = HiveOptiqUtil.getTopLevelSelect(newTopNode);
        newTopNode = PlanModifierForASTConv.renameTopLevelSelectInResultSchema(newTopNode, topSelparentPair, resultSchema);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Final plan after modifier\n " + RelOptUtil.toString((RelNode)newTopNode)));
        }
        return newTopNode;
    }

    private static void convertOpTree(RelNode rel, RelNode parent) {
        List childNodes;
        if (rel instanceof EmptyRel) {
            throw new RuntimeException("Found Empty Rel");
        }
        if (rel instanceof HepRelVertex) {
            throw new RuntimeException("Found HepRelVertex");
        }
        if (rel instanceof JoinRelBase) {
            if (!PlanModifierForASTConv.validJoinParent(rel, parent)) {
                PlanModifierForASTConv.introduceDerivedTable(rel, parent);
            }
        } else {
            if (rel instanceof MultiJoinRel) {
                throw new RuntimeException("Found MultiJoinRel");
            }
            if (rel instanceof OneRowRelBase) {
                throw new RuntimeException("Found OneRowRelBase");
            }
            if (rel instanceof RelSubset) {
                throw new RuntimeException("Found RelSubset");
            }
            if (rel instanceof SetOpRel) {
                if (!PlanModifierForASTConv.validSetopParent(rel, parent)) {
                    PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                }
                SetOpRel setopRel = (SetOpRel)rel;
                for (RelNode inputRel : setopRel.getInputs()) {
                    if (PlanModifierForASTConv.validSetopChild(inputRel)) continue;
                    PlanModifierForASTConv.introduceDerivedTable(inputRel, (RelNode)setopRel);
                }
            } else if (rel instanceof SingleRel) {
                if (rel instanceof FilterRelBase) {
                    if (!PlanModifierForASTConv.validFilterParent(rel, parent)) {
                        PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                    }
                } else if (rel instanceof HiveSortRel) {
                    if (!PlanModifierForASTConv.validSortParent(rel, parent)) {
                        PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                    }
                    if (!PlanModifierForASTConv.validSortChild((HiveSortRel)rel)) {
                        PlanModifierForASTConv.introduceDerivedTable(((HiveSortRel)rel).getChild(), rel);
                    }
                } else if (rel instanceof HiveAggregateRel) {
                    RelNode newParent = parent;
                    if (!PlanModifierForASTConv.validGBParent(rel, parent)) {
                        newParent = PlanModifierForASTConv.introduceDerivedTable(rel, parent);
                    }
                    if (PlanModifierForASTConv.isEmptyGrpAggr(rel)) {
                        PlanModifierForASTConv.replaceEmptyGroupAggr(rel, newParent);
                    }
                }
            }
        }
        if ((childNodes = rel.getInputs()) != null) {
            for (RelNode r : childNodes) {
                PlanModifierForASTConv.convertOpTree(r, rel);
            }
        }
    }

    private static void fixTopOBSchema(RelNode rootRel, Pair<RelNode, RelNode> topSelparentPair, List<FieldSchema> resultSchema) throws OptiqSemanticException {
        if (!(topSelparentPair.getKey() instanceof SortRel) || !HiveOptiqUtil.orderRelNode((RelNode)topSelparentPair.getKey())) {
            return;
        }
        HiveSortRel obRel = (HiveSortRel)topSelparentPair.getKey();
        ProjectRelBase obChild = (ProjectRelBase)topSelparentPair.getValue();
        if (obChild.getRowType().getFieldCount() <= resultSchema.size()) {
            return;
        }
        RelDataType rt = obChild.getRowType();
        HashSet collationInputRefs = new HashSet(RelCollationImpl.ordinals((RelCollation)obRel.getCollation()));
        ImmutableMap.Builder inputRefToCallMapBldr = ImmutableMap.builder();
        for (int i = resultSchema.size(); i < rt.getFieldCount(); ++i) {
            if (!collationInputRefs.contains(i)) continue;
            inputRefToCallMapBldr.put((Object)i, obChild.getChildExps().get(i));
        }
        ImmutableMap inputRefToCallMap = inputRefToCallMapBldr.build();
        if (obChild.getRowType().getFieldCount() - inputRefToCallMap.size() != resultSchema.size()) {
            LOG.error((Object)PlanModifierForASTConv.generateInvalidSchemaMessage(obChild, resultSchema, inputRefToCallMap.size()));
            throw new OptiqSemanticException("Result Schema didn't match Optimized Op Tree Schema");
        }
        HiveProjectRel replacementProjectRel = HiveProjectRel.create(obChild.getChild(), obChild.getChildExps().subList(0, resultSchema.size()), obChild.getRowType().getFieldNames().subList(0, resultSchema.size()));
        obRel.replaceInput(0, replacementProjectRel);
        obRel.setInputRefToCallMap((ImmutableMap<Integer, RexNode>)inputRefToCallMap);
    }

    private static String generateInvalidSchemaMessage(ProjectRelBase topLevelProj, List<FieldSchema> resultSchema, int fieldsForOB) {
        String errorDesc = "Result Schema didn't match Optiq Optimized Op Tree; schema: ";
        for (FieldSchema fs : resultSchema) {
            errorDesc = errorDesc + "[" + fs.getName() + ":" + fs.getType() + "], ";
        }
        errorDesc = errorDesc + " projection fields: ";
        for (RexNode exp : topLevelProj.getChildExps()) {
            errorDesc = errorDesc + "[" + exp.toString() + ":" + exp.getType() + "], ";
        }
        if (fieldsForOB != 0) {
            errorDesc = errorDesc + fieldsForOB + " fields removed due to ORDER BY  ";
        }
        return errorDesc.substring(0, errorDesc.length() - 2);
    }

    private static RelNode renameTopLevelSelectInResultSchema(RelNode rootRel, Pair<RelNode, RelNode> topSelparentPair, List<FieldSchema> resultSchema) throws OptiqSemanticException {
        RelNode parentOforiginalProjRel = (RelNode)topSelparentPair.getKey();
        HiveProjectRel originalProjRel = (HiveProjectRel)topSelparentPair.getValue();
        List rootChildExps = originalProjRel.getChildExps();
        if (resultSchema.size() != rootChildExps.size()) {
            LOG.error((Object)PlanModifierForASTConv.generateInvalidSchemaMessage(originalProjRel, resultSchema, 0));
            throw new OptiqSemanticException("Result Schema didn't match Optimized Op Tree Schema");
        }
        ArrayList<String> newSelAliases = new ArrayList<String>();
        for (int i = 0; i < rootChildExps.size(); ++i) {
            String colAlias = resultSchema.get(i).getName();
            if (colAlias.startsWith("_")) {
                colAlias = colAlias.substring(1);
            }
            newSelAliases.add(colAlias);
        }
        HiveProjectRel replacementProjectRel = HiveProjectRel.create(originalProjRel.getChild(), originalProjRel.getChildExps(), newSelAliases);
        if (rootRel == originalProjRel) {
            return replacementProjectRel;
        }
        parentOforiginalProjRel.replaceInput(0, (RelNode)replacementProjectRel);
        return rootRel;
    }

    private static RelNode introduceDerivedTable(RelNode rel) {
        List<RexNode> projectList = HiveOptiqUtil.getProjsFromBelowAsInputRef(rel);
        HiveProjectRel select = HiveProjectRel.create(rel.getCluster(), rel, projectList, rel.getRowType(), rel.getCollationList());
        return select;
    }

    private static RelNode introduceDerivedTable(RelNode rel, RelNode parent) {
        int i = 0;
        int pos = -1;
        List childList = parent.getInputs();
        for (RelNode child : childList) {
            if (child == rel) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            throw new RuntimeException("Couldn't find child node in parent's inputs");
        }
        RelNode select = PlanModifierForASTConv.introduceDerivedTable(rel);
        parent.replaceInput(pos, select);
        return select;
    }

    private static boolean validJoinParent(RelNode joinNode, RelNode parent) {
        boolean validParent = true;
        if (parent instanceof JoinRelBase) {
            if (((JoinRelBase)parent).getRight() == joinNode) {
                validParent = false;
            }
        } else if (parent instanceof SetOpRel) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validFilterParent(RelNode filterNode, RelNode parent) {
        boolean validParent = true;
        if (parent instanceof FilterRelBase || parent instanceof JoinRelBase || parent instanceof SetOpRel) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validGBParent(RelNode gbNode, RelNode parent) {
        boolean validParent = true;
        if (parent instanceof JoinRelBase || parent instanceof SetOpRel || parent instanceof AggregateRelBase || parent instanceof FilterRelBase && ((AggregateRelBase)gbNode).getGroupSet().isEmpty()) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validSortParent(RelNode sortNode, RelNode parent) {
        boolean validParent = true;
        if (!(parent == null || parent instanceof ProjectRelBase || parent instanceof SortRel || HiveOptiqUtil.orderRelNode(parent))) {
            validParent = false;
        }
        return validParent;
    }

    private static boolean validSortChild(HiveSortRel sortNode) {
        boolean validChild = true;
        RelNode child = sortNode.getChild();
        if (!(HiveOptiqUtil.limitRelNode(sortNode) && HiveOptiqUtil.orderRelNode(child) || child instanceof ProjectRelBase)) {
            validChild = false;
        }
        return validChild;
    }

    private static boolean validSetopParent(RelNode setop, RelNode parent) {
        boolean validChild = true;
        if (parent != null && !(parent instanceof ProjectRelBase)) {
            validChild = false;
        }
        return validChild;
    }

    private static boolean validSetopChild(RelNode setopChild) {
        boolean validChild = true;
        if (!(setopChild instanceof ProjectRelBase)) {
            validChild = false;
        }
        return validChild;
    }

    private static boolean isEmptyGrpAggr(RelNode gbNode) {
        AggregateRelBase aggrnode = (AggregateRelBase)gbNode;
        return aggrnode.getGroupSet().isEmpty() && aggrnode.getAggCallList().isEmpty();
    }

    private static void replaceEmptyGroupAggr(RelNode rel, RelNode parent) {
        List exps = parent.getChildExps();
        for (RexNode rexNode : exps) {
            if (rexNode.getKind() == SqlKind.LITERAL) continue;
            throw new RuntimeException("We expect " + parent.toString() + " to contain only constants. However, " + rexNode.toString() + " is " + rexNode.getKind());
        }
        HiveAggregateRel oldAggRel = (HiveAggregateRel)rel;
        RelDataTypeFactory typeFactory = oldAggRel.getCluster().getTypeFactory();
        RelDataType longType = TypeConverter.convert(TypeInfoFactory.longTypeInfo, typeFactory);
        RelDataType intType = TypeConverter.convert(TypeInfoFactory.intTypeInfo, typeFactory);
        SqlAggFunction countFn = SqlFunctionConverter.getOptiqAggFn("count", (ImmutableList<RelDataType>)ImmutableList.of((Object)intType), longType);
        ImmutableList argList = ImmutableList.of((Object)0);
        AggregateCall dummyCall = new AggregateCall((Aggregation)countFn, false, (List)argList, longType, null);
        AggregateRelBase newAggRel = oldAggRel.copy(oldAggRel.getTraitSet(), oldAggRel.getChild(), oldAggRel.getGroupSet(), (List<AggregateCall>)ImmutableList.of((Object)dummyCall));
        RelNode select = PlanModifierForASTConv.introduceDerivedTable((RelNode)newAggRel);
        parent.replaceInput(0, select);
    }
}

