/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.translator;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.ASTConverter;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.optiq.translator.TypeConverter;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexVisitorImpl;

public class ExprNodeConverter
extends RexVisitorImpl<ExprNodeDesc> {
    RelDataType rType;
    String tabAlias;
    boolean partitioningExpr;

    public ExprNodeConverter(String tabAlias, RelDataType rType, boolean partitioningExpr) {
        super(true);
        assert (partitioningExpr);
        this.tabAlias = tabAlias;
        this.rType = rType;
        this.partitioningExpr = partitioningExpr;
    }

    public ExprNodeDesc visitInputRef(RexInputRef inputRef) {
        RelDataTypeField f = (RelDataTypeField)this.rType.getFieldList().get(inputRef.getIndex());
        return new ExprNodeColumnDesc(TypeConverter.convert(f.getType()), f.getName(), this.tabAlias, this.partitioningExpr);
    }

    public ExprNodeDesc visitCall(RexCall call) {
        ExprNodeGenericFuncDesc gfDesc = null;
        if (!this.deep) {
            return null;
        }
        LinkedList<ExprNodeDesc> args = new LinkedList<ExprNodeDesc>();
        for (RexNode operand : call.operands) {
            args.add((ExprNodeDesc)operand.accept((RexVisitor)this));
        }
        if (ASTConverter.isFlat(call)) {
            ArrayList<ExprNodeDesc> tmpExprArgs = new ArrayList<ExprNodeDesc>();
            tmpExprArgs.addAll(args.subList(0, 2));
            gfDesc = new ExprNodeGenericFuncDesc(TypeConverter.convert(call.getType()), SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), 2), tmpExprArgs);
            for (int i = 2; i < call.operands.size(); ++i) {
                tmpExprArgs = new ArrayList();
                tmpExprArgs.add(gfDesc);
                tmpExprArgs.add((ExprNodeDesc)args.get(i));
                gfDesc = new ExprNodeGenericFuncDesc(TypeConverter.convert(call.getType()), SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), 2), tmpExprArgs);
            }
        } else {
            gfDesc = new ExprNodeGenericFuncDesc(TypeConverter.convert(call.getType()), SqlFunctionConverter.getHiveUDF(call.getOperator(), call.getType(), args.size()), args);
        }
        return gfDesc;
    }

    public ExprNodeDesc visitLiteral(RexLiteral literal) {
        RelDataType lType = literal.getType();
        switch (literal.getType().getSqlTypeName()) {
            case BOOLEAN: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, RexLiteral.booleanValue((RexNode)literal));
            }
            case TINYINT: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.byteTypeInfo, ((Number)literal.getValue3()).byteValue());
            }
            case SMALLINT: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.shortTypeInfo, ((Number)literal.getValue3()).shortValue());
            }
            case INTEGER: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, ((Number)literal.getValue3()).intValue());
            }
            case BIGINT: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.longTypeInfo, ((Number)literal.getValue3()).longValue());
            }
            case FLOAT: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.floatTypeInfo, Float.valueOf(((Number)literal.getValue3()).floatValue()));
            }
            case DOUBLE: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, ((Number)literal.getValue3()).doubleValue());
            }
            case DATE: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.dateTypeInfo, new Date(((Calendar)literal.getValue()).getTimeInMillis()));
            }
            case TIMESTAMP: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, literal.getValue3());
            }
            case BINARY: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.binaryTypeInfo, literal.getValue3());
            }
            case DECIMAL: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)lType.getPrecision(), (int)lType.getScale()), literal.getValue3());
            }
            case VARCHAR: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)lType.getPrecision()), new HiveVarchar((String)literal.getValue3(), lType.getPrecision()));
            }
            case CHAR: {
                return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.getCharTypeInfo((int)lType.getPrecision()), new HiveChar((String)literal.getValue3(), lType.getPrecision()));
            }
        }
        return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.voidTypeInfo, literal.getValue3());
    }
}

