/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteCanApplyCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;

public final class RewriteCanApplyProcFactory {
    public static CheckFilterProc canApplyOnFilterOperator(TableScanOperator topOp) {
        return new CheckFilterProc(topOp);
    }

    public static CheckGroupByProc canApplyOnGroupByOperator(TableScanOperator topOp) {
        return new CheckGroupByProc(topOp);
    }

    private static class CheckGroupByProc
    implements NodeProcessor {
        private TableScanOperator topOp;

        public CheckGroupByProc(TableScanOperator topOp) {
            this.topOp = topOp;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator operator = (GroupByOperator)nd;
            RewriteCanApplyCtx canApplyCtx = (RewriteCanApplyCtx)ctx;
            if (canApplyCtx.getParseContext().getGroupOpToInputTables().containsKey(operator) && !canApplyCtx.isQueryHasGroupBy()) {
                ArrayList<ExprNodeDesc> keyList;
                canApplyCtx.setQueryHasGroupBy(true);
                GroupByDesc conf = (GroupByDesc)operator.getConf();
                ArrayList<AggregationDesc> aggrList = conf.getAggregators();
                if (aggrList != null && aggrList.size() > 0) {
                    for (AggregationDesc aggregationDesc : aggrList) {
                        canApplyCtx.setAggFuncCnt(canApplyCtx.getAggFuncCnt() + 1);
                        if (canApplyCtx.getAggFuncCnt() > 1) {
                            return false;
                        }
                        String aggFunc = aggregationDesc.getGenericUDAFName();
                        if (!"count".equals(aggFunc)) {
                            canApplyCtx.setAggFuncIsNotCount(true);
                            return false;
                        }
                        ArrayList<ExprNodeDesc> para = aggregationDesc.getParameters();
                        if (para == null) {
                            canApplyCtx.setAggFuncColsFetchException(true);
                            continue;
                        }
                        if (para.size() == 0) {
                            canApplyCtx.setCountOnAllCols(true);
                            canApplyCtx.setAggFunction("_count_of_all");
                            continue;
                        }
                        if (para.size() == 1) {
                            ExprNodeDesc expr = ExprNodeDescUtils.backtrack((ExprNodeDesc)para.get(0), operator, this.topOp);
                            if (expr instanceof ExprNodeColumnDesc) {
                                canApplyCtx.getSelectColumnsList().add(((ExprNodeColumnDesc)expr).getColumn());
                                canApplyCtx.getAggFuncColList().add(((ExprNodeColumnDesc)expr).getColumn());
                                canApplyCtx.setAggFunction("_count_of_" + ((ExprNodeColumnDesc)expr).getColumn() + "");
                                continue;
                            }
                            if (!(expr instanceof ExprNodeConstantDesc)) continue;
                            canApplyCtx.setCountOfOne(true);
                            canApplyCtx.setAggFunction("_count_of_1");
                            continue;
                        }
                        throw new SemanticException("Invalid number of arguments for count");
                    }
                }
                if ((keyList = conf.getKeys()) == null || keyList.size() == 0) {
                    canApplyCtx.setGbyKeysFetchException(true);
                }
                for (ExprNodeDesc expr : keyList) {
                    this.checkExpression(canApplyCtx, expr);
                }
            }
            return null;
        }

        private void checkExpression(RewriteCanApplyCtx canApplyCtx, ExprNodeDesc expr) {
            if (expr instanceof ExprNodeColumnDesc) {
                canApplyCtx.getGbKeyNameList().addAll(expr.getCols());
            } else if (expr instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc funcExpr = (ExprNodeGenericFuncDesc)expr;
                List<ExprNodeDesc> childExprs = funcExpr.getChildren();
                for (ExprNodeDesc childExpr : childExprs) {
                    if (childExpr instanceof ExprNodeColumnDesc) {
                        canApplyCtx.getGbKeyNameList().addAll(expr.getCols());
                        canApplyCtx.getSelectColumnsList().add(((ExprNodeColumnDesc)childExpr).getColumn());
                        continue;
                    }
                    if (!(childExpr instanceof ExprNodeGenericFuncDesc)) continue;
                    this.checkExpression(canApplyCtx, childExpr);
                }
            }
        }
    }

    private static class CheckFilterProc
    implements NodeProcessor {
        private TableScanOperator topOp;

        public CheckFilterProc(TableScanOperator topOp) {
            this.topOp = topOp;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator operator = (FilterOperator)nd;
            RewriteCanApplyCtx canApplyCtx = (RewriteCanApplyCtx)ctx;
            FilterDesc conf = (FilterDesc)operator.getConf();
            ExprNodeDesc oldengfd = conf.getPredicate();
            if (oldengfd == null) {
                canApplyCtx.setWhrClauseColsFetchException(true);
                return null;
            }
            ExprNodeDesc backtrack = ExprNodeDescUtils.backtrack(oldengfd, operator, this.topOp);
            if (backtrack == null) {
                canApplyCtx.setWhrClauseColsFetchException(true);
                return null;
            }
            for (String col : backtrack.getCols()) {
                canApplyCtx.getPredicateColumnsList().add(col);
            }
            return null;
        }
    }
}

