/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class ConstantPropagateProcCtx
implements NodeProcessorCtx {
    private static final Log LOG = LogFactory.getLog(ConstantPropagateProcCtx.class);
    private final Map<Operator<? extends Serializable>, Map<ColumnInfo, ExprNodeDesc>> opToConstantExprs = new HashMap<Operator<? extends Serializable>, Map<ColumnInfo, ExprNodeDesc>>();
    private final Map<Operator<? extends OperatorDesc>, OpParseContext> opToParseCtx;
    private final List<Operator<? extends Serializable>> opToDelete = new ArrayList<Operator<? extends Serializable>>();

    public ConstantPropagateProcCtx(Map<Operator<? extends OperatorDesc>, OpParseContext> opToParseCtx) {
        this.opToParseCtx = opToParseCtx;
    }

    public Map<Operator<? extends Serializable>, Map<ColumnInfo, ExprNodeDesc>> getOpToConstantExprs() {
        return this.opToConstantExprs;
    }

    public Map<Operator<? extends OperatorDesc>, OpParseContext> getOpToParseCtxMap() {
        return this.opToParseCtx;
    }

    private ColumnInfo resolve(ColumnInfo ci, RowResolver rr, RowResolver parentRR) throws SemanticException {
        String tblAlias;
        ColumnInfo rci;
        String alias = ci.getAlias();
        if (alias == null) {
            alias = ci.getInternalName();
        }
        if ((rci = rr.get(tblAlias = ci.getTabAlias(), alias)) == null && rr.getRslvMap().size() == 1 && parentRR.getRslvMap().size() == 1) {
            rci = rr.get(null, alias);
        }
        if (rci == null) {
            return null;
        }
        String[] tmp = rr.reverseLookup(rci.getInternalName());
        rci.setTabAlias(tmp[0]);
        rci.setAlias(tmp[1]);
        LOG.debug((Object)("Resolved " + ci.getTabAlias() + "." + ci.getAlias() + " as " + rci.getTabAlias() + "." + rci.getAlias() + " with rr: " + rr));
        return rci;
    }

    public Map<ColumnInfo, ExprNodeDesc> getPropagatedConstants(Operator<? extends Serializable> op) {
        HashMap<ColumnInfo, ExprNodeDesc> constants = new HashMap<ColumnInfo, ExprNodeDesc>();
        OpParseContext parseCtx = this.opToParseCtx.get(op);
        if (parseCtx == null) {
            return constants;
        }
        RowResolver rr = parseCtx.getRowResolver();
        LOG.debug((Object)("Getting constants of op:" + op + " with rr:" + rr));
        try {
            if (op.getParentOperators() == null) {
                return constants;
            }
            if (op instanceof UnionOperator) {
                String alias = (String)rr.getRslvMap().keySet().toArray()[0];
                HashMap<ColumnInfo, ExprNodeDesc> intersection = null;
                for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                    Map<ColumnInfo, ExprNodeDesc> unionConst = this.opToConstantExprs.get(parent);
                    LOG.debug((Object)("Constant of op " + parent.getOperatorId() + " " + unionConst));
                    if (intersection == null) {
                        intersection = new HashMap<ColumnInfo, ExprNodeDesc>();
                        for (Map.Entry<ColumnInfo, ExprNodeDesc> entry : unionConst.entrySet()) {
                            ColumnInfo ci = new ColumnInfo(entry.getKey());
                            ci.setTabAlias(alias);
                            intersection.put(ci, entry.getValue());
                        }
                    } else {
                        Iterator itr = intersection.entrySet().iterator();
                        while (itr.hasNext()) {
                            Map.Entry entry = itr.next();
                            boolean found = false;
                            for (Map.Entry<ColumnInfo, ExprNodeDesc> f : this.opToConstantExprs.get(parent).entrySet()) {
                                if (!((ColumnInfo)entry.getKey()).getInternalName().equals(f.getKey().getInternalName())) continue;
                                if (!((ExprNodeDesc)entry.getValue()).isSame(f.getValue())) break;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            itr.remove();
                        }
                    }
                    if (!intersection.isEmpty()) continue;
                    return intersection;
                }
                LOG.debug((Object)("Propagated union constants:" + intersection));
                return intersection;
            }
            for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                Map<ColumnInfo, ExprNodeDesc> c = this.opToConstantExprs.get(parent);
                for (Map.Entry<ColumnInfo, ExprNodeDesc> e : c.entrySet()) {
                    ColumnInfo ci = e.getKey();
                    Object var11_22 = null;
                    ExprNodeDesc constant = e.getValue();
                    ColumnInfo columnInfo = this.resolve(ci, rr, this.opToParseCtx.get(parent).getRowResolver());
                    if (columnInfo != null) {
                        constants.put(columnInfo, constant);
                        continue;
                    }
                    LOG.debug((Object)("Can't resolve " + ci.getTabAlias() + "." + ci.getAlias() + " from rr:" + rr));
                }
            }
            LOG.debug((Object)("Offerring constants " + constants.keySet() + " to operator " + op.toString()));
            return constants;
        }
        catch (SemanticException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public RowResolver getRowResolver(Operator<? extends Serializable> op) {
        OpParseContext parseCtx = this.opToParseCtx.get(op);
        if (parseCtx == null) {
            return null;
        }
        return parseCtx.getRowResolver();
    }

    public void addOpToDelete(Operator<? extends Serializable> op) {
        this.opToDelete.add(op);
    }

    public List<Operator<? extends Serializable>> getOpToDelete() {
        return this.opToDelete;
    }
}

