/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.ExprNodeColumnEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeConstantEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorHead;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorRef;
import org.apache.hadoop.hive.ql.exec.ExprNodeFieldEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeGenericFuncEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeNullEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;

public final class ExprNodeEvaluatorFactory {
    private ExprNodeEvaluatorFactory() {
    }

    public static ExprNodeEvaluator get(ExprNodeDesc desc) throws HiveException {
        if (desc instanceof ExprNodeConstantDesc) {
            return new ExprNodeConstantEvaluator((ExprNodeConstantDesc)desc);
        }
        if (desc instanceof ExprNodeColumnDesc) {
            return new ExprNodeColumnEvaluator((ExprNodeColumnDesc)desc);
        }
        if (desc instanceof ExprNodeGenericFuncDesc) {
            return new ExprNodeGenericFuncEvaluator((ExprNodeGenericFuncDesc)desc);
        }
        if (desc instanceof ExprNodeFieldDesc) {
            return new ExprNodeFieldEvaluator((ExprNodeFieldDesc)desc);
        }
        if (desc instanceof ExprNodeNullDesc) {
            return new ExprNodeNullEvaluator((ExprNodeNullDesc)desc);
        }
        throw new RuntimeException("Cannot find ExprNodeEvaluator for the exprNodeDesc = " + desc);
    }

    public static ExprNodeEvaluator toCachedEval(ExprNodeEvaluator eval) {
        if (eval instanceof ExprNodeGenericFuncEvaluator) {
            EvaluatorContext context = new EvaluatorContext();
            ExprNodeEvaluatorFactory.iterate(eval, context);
            if (context.hasReference) {
                return new ExprNodeEvaluatorHead(eval);
            }
        }
        return eval;
    }

    private static ExprNodeEvaluator iterate(ExprNodeEvaluator eval, EvaluatorContext context) {
        ExprNodeEvaluator replace;
        if (!(eval instanceof ExprNodeConstantEvaluator) && eval.isDeterministic() && (replace = context.getEvaluated(eval)) != null) {
            return replace;
        }
        ExprNodeEvaluator[] children = eval.getChildren();
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                ExprNodeEvaluator replace2 = ExprNodeEvaluatorFactory.iterate(children[i], context);
                if (replace2 == null) continue;
                children[i] = replace2;
            }
        }
        return null;
    }

    private static class EvaluatorContext {
        private final Map<ExprNodeDesc.ExprNodeDescEqualityWrapper, ExprNodeEvaluator> cached = new HashMap<ExprNodeDesc.ExprNodeDescEqualityWrapper, ExprNodeEvaluator>();
        private boolean hasReference;

        private EvaluatorContext() {
        }

        public ExprNodeEvaluator getEvaluated(ExprNodeEvaluator eval) {
            ExprNodeDesc.ExprNodeDescEqualityWrapper key = new ExprNodeDesc.ExprNodeDescEqualityWrapper((ExprNodeDesc)eval.expr);
            ExprNodeEvaluator prev = this.cached.get(key);
            if (prev == null) {
                this.cached.put(key, eval);
                return null;
            }
            this.hasReference = true;
            return new ExprNodeEvaluatorRef(prev);
        }
    }
}

