/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.metadata.types.Metadata;
import org.apache.gobblin.type.RecordWithMetadata;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class EnvelopedRecordWithMetadataToRecordWithMetadata
extends Converter<String, Object, RecordWithMetadata<byte[]>, RecordWithMetadata<?>> {
    private static final String RECORD_KEY = "r";
    private static final String METADATA_KEY = "rMd";
    private static final String METADATA_RECORD_KEY = "recordMetadata";
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final JsonFactory jsonFactory = new JsonFactory();

    public String convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<RecordWithMetadata<?>> convertRecord(Object outputSchema, RecordWithMetadata<byte[]> inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try (JsonParser parser = jsonFactory.createJsonParser(inputRecord.getRecord());){
            parser.setCodec((ObjectCodec)objectMapper);
            JsonNode jsonNode = parser.readValueAsTree();
            if (!jsonNode.has(RECORD_KEY)) {
                throw new DataConversionException("Input data does not have record.");
            }
            String record = jsonNode.get(RECORD_KEY).getTextValue();
            Metadata md = new Metadata();
            if (jsonNode.has(METADATA_KEY) && jsonNode.get(METADATA_KEY).has(METADATA_RECORD_KEY)) {
                md.getRecordMetadata().putAll((Map)objectMapper.readValue(jsonNode.get(METADATA_KEY).get(METADATA_RECORD_KEY), Map.class));
            }
            Set<RecordWithMetadata<?>> set = Collections.singleton(new RecordWithMetadata<String>(record, md));
            return set;
        }
        catch (IOException e) {
            throw new DataConversionException((Throwable)e);
        }
    }
}

