/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive.spec.predicate;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.HiveRegistrationUnit;

public class PartitionNotExistPredicate
implements Predicate<HiveRegister> {
    protected final String dbName;
    protected final String tableName;
    protected final List<HiveRegistrationUnit.Column> partitionKeys;
    protected final List<String> partitionValues;

    public boolean apply(HiveRegister register) {
        try {
            return !register.existsPartition(this.dbName, this.tableName, this.partitionKeys, this.partitionValues);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @ConstructorProperties(value={"dbName", "tableName", "partitionKeys", "partitionValues"})
    public PartitionNotExistPredicate(String dbName, String tableName, List<HiveRegistrationUnit.Column> partitionKeys, List<String> partitionValues) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.partitionKeys = partitionKeys;
        this.partitionValues = partitionValues;
    }
}

