/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive.policy;

import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HivePartition;
import org.apache.gobblin.hive.HiveRegProps;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.HiveSerDeManager;
import org.apache.gobblin.hive.HiveTable;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicy;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.hive.spec.SimpleHiveSpec;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.source.extractor.extract.kafka.ConfigStoreUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;

@Alpha
public class HiveRegistrationPolicyBase
implements HiveRegistrationPolicy {
    public static final String HIVE_DATABASE_NAME = "hive.database.name";
    public static final String ADDITIONAL_HIVE_DATABASE_NAMES = "additional.hive.database.names";
    public static final String HIVE_DATABASE_REGEX = "hive.database.regex";
    public static final String HIVE_DATABASE_NAME_PREFIX = "hive.database.name.prefix";
    public static final String HIVE_DATABASE_NAME_SUFFIX = "hive.database.name.suffix";
    public static final String HIVE_TABLE_NAME = "hive.table.name";
    public static final String ADDITIONAL_HIVE_TABLE_NAMES = "additional.hive.table.names";
    public static final String HIVE_TABLE_REGEX = "hive.table.regex";
    public static final String HIVE_TABLE_NAME_PREFIX = "hive.table.name.prefix";
    public static final String HIVE_TABLE_NAME_SUFFIX = "hive.table.name.suffix";
    public static final String HIVE_SANITIZE_INVALID_NAMES = "hive.sanitize.invalid.names";
    public static final String HIVE_FS_URI = "hive.registration.fs.uri";
    public static final String PRIMARY_TABLE_TOKEN = "$PRIMARY_TABLE";
    protected static final ConfigClient configClient = ConfigClient.createConfigClient((VersionStabilityPolicy)VersionStabilityPolicy.WEAK_LOCAL_STABILITY);
    private static final Pattern VALID_DB_TABLE_NAME_PATTERN_1 = Pattern.compile("[a-z0-9][a-z0-9_]*");
    private static final Pattern VALID_DB_TABLE_NAME_PATTERN_2 = Pattern.compile(".*[a-z_].*");
    public static final String CONFIG_FOR_TOPIC_TIMER = "configForTopicTimer";
    protected final HiveRegProps props;
    protected final FileSystem fs;
    protected final boolean sanitizeNameAllowed;
    protected final Optional<Pattern> dbNamePattern;
    protected final Optional<Pattern> tableNamePattern;
    protected final String dbNamePrefix;
    protected final String dbNameSuffix;
    protected final String tableNamePrefix;
    protected final String tableNameSuffix;
    protected final MetricContext metricContext;

    public HiveRegistrationPolicyBase(State props) throws IOException {
        Preconditions.checkNotNull((Object)props);
        this.props = new HiveRegProps(props);
        this.fs = props.contains(HIVE_FS_URI) ? FileSystem.get((URI)URI.create(props.getProp(HIVE_FS_URI)), (Configuration)new Configuration()) : FileSystem.get((Configuration)new Configuration());
        this.sanitizeNameAllowed = props.getPropAsBoolean(HIVE_SANITIZE_INVALID_NAMES, true);
        this.dbNamePattern = props.contains(HIVE_DATABASE_REGEX) ? Optional.of((Object)Pattern.compile(props.getProp(HIVE_DATABASE_REGEX))) : Optional.absent();
        this.tableNamePattern = props.contains(HIVE_TABLE_REGEX) ? Optional.of((Object)Pattern.compile(props.getProp(HIVE_TABLE_REGEX))) : Optional.absent();
        this.dbNamePrefix = props.getProp(HIVE_DATABASE_NAME_PREFIX, "");
        this.dbNameSuffix = props.getProp(HIVE_DATABASE_NAME_SUFFIX, "");
        this.tableNamePrefix = props.getProp(HIVE_TABLE_NAME_PREFIX, "");
        this.tableNameSuffix = props.getProp(HIVE_TABLE_NAME_SUFFIX, "");
        this.metricContext = Instrumented.getMetricContext((State)props, HiveRegister.class);
    }

    protected Optional<String> getDatabaseName(Path path) {
        if (!this.props.contains(HIVE_DATABASE_NAME) && !this.props.contains(HIVE_DATABASE_REGEX)) {
            return Optional.absent();
        }
        return Optional.of((Object)(this.dbNamePrefix + this.getDatabaseOrTableName(path, HIVE_DATABASE_NAME, HIVE_DATABASE_REGEX, this.dbNamePattern) + this.dbNameSuffix));
    }

    protected Iterable<String> getDatabaseNames(Path path) {
        ArrayList databaseNames = Lists.newArrayList();
        Optional<String> databaseName = this.getDatabaseName(path);
        if (databaseName.isPresent()) {
            databaseNames.add(databaseName.get());
        }
        if (!Strings.isNullOrEmpty((String)this.props.getProp(ADDITIONAL_HIVE_DATABASE_NAMES))) {
            for (String additionalDbName : this.props.getPropAsList(ADDITIONAL_HIVE_DATABASE_NAMES)) {
                databaseNames.add(this.dbNamePrefix + additionalDbName + this.dbNameSuffix);
            }
        }
        Preconditions.checkState((!databaseNames.isEmpty() ? 1 : 0) != 0, (Object)"Hive database name not specified");
        return databaseNames;
    }

    protected Optional<String> getTableName(Path path) {
        if (!this.props.contains(HIVE_TABLE_NAME) && !this.props.contains(HIVE_TABLE_REGEX)) {
            return Optional.absent();
        }
        return Optional.of((Object)(this.tableNamePrefix + this.getDatabaseOrTableName(path, HIVE_TABLE_NAME, HIVE_TABLE_REGEX, this.tableNamePattern) + this.tableNameSuffix));
    }

    protected Iterable<String> getTableNames(Path path) {
        List<String> tableNames = this.getTableNames((Optional<String>)Optional.absent(), path);
        Preconditions.checkState((!tableNames.isEmpty() ? 1 : 0) != 0, (Object)"Hive table name not specified");
        return tableNames;
    }

    protected List<String> getTableNames(Optional<String> dbPrefix, Path path) {
        ArrayList tableNames;
        block5: {
            String additionalNamesProp;
            Optional<String> primaryTableName;
            block4: {
                tableNames = Lists.newArrayList();
                primaryTableName = this.getTableName(path);
                if (primaryTableName.isPresent() && !dbPrefix.isPresent()) {
                    tableNames.add(primaryTableName.get());
                }
                Optional configForTopic = Optional.absent();
                if (primaryTableName.isPresent()) {
                    Timer.Context context = this.metricContext.timer(CONFIG_FOR_TOPIC_TIMER).time();
                    configForTopic = ConfigStoreUtils.getConfigForTopic((Properties)this.props.getProperties(), (String)"topic.name", (ConfigClient)configClient);
                    context.close();
                }
                additionalNamesProp = dbPrefix.isPresent() ? String.format("%s.%s", dbPrefix.get(), HIVE_TABLE_NAME) : ADDITIONAL_HIVE_TABLE_NAMES;
                if (!configForTopic.isPresent() || !((Config)configForTopic.get()).hasPath(additionalNamesProp)) break block4;
                for (String additionalTableName : Splitter.on((String)",").trimResults().splitToList((CharSequence)((Config)configForTopic.get()).getString(additionalNamesProp))) {
                    String resolvedTableName = StringUtils.replace((String)additionalTableName, (String)PRIMARY_TABLE_TOKEN, (String)((String)primaryTableName.get()));
                    tableNames.add(this.tableNamePrefix + resolvedTableName + this.tableNameSuffix);
                }
                break block5;
            }
            if (Strings.isNullOrEmpty((String)this.props.getProp(additionalNamesProp))) break block5;
            for (String additionalTableName : this.props.getPropAsList(additionalNamesProp)) {
                String resolvedTableName = primaryTableName.isPresent() ? StringUtils.replace((String)additionalTableName, (String)PRIMARY_TABLE_TOKEN, (String)((String)primaryTableName.get())) : additionalTableName;
                tableNames.add(this.tableNamePrefix + resolvedTableName + this.tableNameSuffix);
            }
        }
        return tableNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getDatabaseOrTableName(Path path, String nameKey, String regexKey, Optional<Pattern> pattern) {
        String name;
        if (this.props.contains(nameKey)) {
            name = this.props.getProp(nameKey);
            return this.sanitizeAndValidateName(name);
        } else {
            if (!pattern.isPresent()) throw new IllegalStateException("Missing required property " + nameKey + " or " + regexKey);
            Matcher matcher = ((Pattern)pattern.get()).matcher(path.toString());
            if (!matcher.matches() || matcher.groupCount() < 1) throw new IllegalStateException("No group match found for regexKey " + regexKey + " with regexp " + ((Pattern)pattern.get()).toString() + " on path " + path);
            name = matcher.group(1);
        }
        return this.sanitizeAndValidateName(name);
    }

    protected String sanitizeAndValidateName(String name) {
        name = name.toLowerCase();
        if (this.sanitizeNameAllowed && !HiveRegistrationPolicyBase.isNameValid(name)) {
            name = HiveRegistrationPolicyBase.sanitizeName(name);
        }
        if (HiveRegistrationPolicyBase.isNameValid(name)) {
            return name;
        }
        throw new IllegalStateException(name + " is not a valid Hive database or table name");
    }

    protected List<HiveTable> getTables(Path path) throws IOException {
        ArrayList tables = Lists.newArrayList();
        for (String databaseName : this.getDatabaseNames(path)) {
            boolean foundTablesViaDbFilter = false;
            for (String tableName : this.getTableNames((Optional<String>)Optional.of((Object)databaseName), path)) {
                tables.add(this.getTable(path, databaseName, tableName));
                foundTablesViaDbFilter = true;
            }
            if (foundTablesViaDbFilter) continue;
            for (String tableName : this.getTableNames(path)) {
                tables.add(this.getTable(path, databaseName, tableName));
            }
        }
        return tables;
    }

    protected HiveTable getTable(Path path, String dbName, String tableName) throws IOException {
        HiveTable table = ((HiveTable.Builder)((HiveTable.Builder)((HiveTable.Builder)new HiveTable.Builder().withDbName(dbName)).withTableName(tableName)).withSerdeManaager(HiveSerDeManager.get(this.props))).build();
        table.setLocation(this.fs.makeQualified(this.getTableLocation(path)).toString());
        table.setSerDeProps(path);
        State tableProps = new State(this.props.getTablePartitionProps());
        if (this.props.getRuntimeTableProps().isPresent()) {
            tableProps.setProp("runtime.props", this.props.getRuntimeTableProps().get());
        }
        table.setProps(tableProps);
        table.setStorageProps(this.props.getStorageProps());
        table.setSerDeProps(this.props.getSerdeProps());
        table.setNumBuckets(-1);
        table.setBucketColumns(Lists.newArrayList());
        table.setTableType(TableType.EXTERNAL_TABLE.toString());
        return table;
    }

    protected Optional<HivePartition> getPartition(Path path, HiveTable table) throws IOException {
        return Optional.absent();
    }

    protected Path getTableLocation(Path path) {
        return path;
    }

    protected static boolean isNameValid(String name) {
        Preconditions.checkNotNull((Object)name);
        name = name.toLowerCase();
        return VALID_DB_TABLE_NAME_PATTERN_1.matcher(name).matches() && VALID_DB_TABLE_NAME_PATTERN_2.matcher(name).matches();
    }

    protected static String sanitizeName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_]", "_");
    }

    @Override
    public Collection<HiveSpec> getHiveSpecs(Path path) throws IOException {
        ArrayList specs = Lists.newArrayList();
        for (HiveTable table : this.getTables(path)) {
            specs.add(((SimpleHiveSpec.Builder)((SimpleHiveSpec.Builder)new SimpleHiveSpec.Builder(path).withTable(table)).withPartition(this.getPartition(path, table))).build());
        }
        return specs;
    }

    public static HiveRegistrationPolicy getPolicy(State props) {
        Preconditions.checkArgument((boolean)props.contains("hive.registration.policy"));
        String policyType = props.getProp("hive.registration.policy");
        try {
            return (HiveRegistrationPolicy)ConstructorUtils.invokeConstructor(Class.forName(policyType), (Object[])new Object[]{props});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to instantiate " + HiveRegistrationPolicy.class.getSimpleName() + " with type " + policyType, e);
        }
    }
}

