/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import java.util.Set;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveRegistrationUnit;
import org.apache.hadoop.fs.Path;

@Alpha
public class HiveRegistrationUnitComparator<T extends HiveRegistrationUnitComparator<?>> {
    protected final HiveRegistrationUnit existingUnit;
    protected final HiveRegistrationUnit newUnit;
    protected boolean result = false;

    public HiveRegistrationUnitComparator(HiveRegistrationUnit existingUnit, HiveRegistrationUnit newUnit) {
        this.existingUnit = existingUnit;
        this.newUnit = newUnit;
    }

    public T compareRawLocation() {
        if (!this.result) {
            this.result |= !new Path((String)this.existingUnit.getLocation().get()).toUri().getRawPath().equals(new Path((String)this.newUnit.getLocation().get()).toUri().getRawPath());
        }
        return (T)this;
    }

    public T compareInputFormat() {
        if (!this.result) {
            this.compare(this.existingUnit.getInputFormat(), this.newUnit.getInputFormat());
        }
        return (T)this;
    }

    public T compareOutputFormat() {
        if (!this.result) {
            this.compare(this.existingUnit.getOutputFormat(), this.newUnit.getOutputFormat());
        }
        return (T)this;
    }

    public T compareIsCompressed() {
        if (!this.result) {
            this.compare(this.existingUnit.getIsCompressed(), this.newUnit.getIsCompressed());
        }
        return (T)this;
    }

    public T compareNumBuckets() {
        if (!this.result) {
            this.compare(this.existingUnit.getNumBuckets(), this.newUnit.getNumBuckets());
        }
        return (T)this;
    }

    public T compareBucketCols() {
        if (!this.result) {
            this.compare(this.existingUnit.getBucketColumns(), this.newUnit.getBucketColumns());
        }
        return (T)this;
    }

    public T compareIsStoredAsSubDirs() {
        if (!this.result) {
            this.compare(this.existingUnit.getIsStoredAsSubDirs(), this.newUnit.getIsStoredAsSubDirs());
        }
        return (T)this;
    }

    public T compareParameters() {
        if (!this.result) {
            this.checkExistingIsSuperstate(this.existingUnit.getProps(), this.newUnit.getProps());
            this.checkExistingIsSuperstate(this.existingUnit.getStorageProps(), this.newUnit.getStorageProps());
            this.checkExistingIsSuperstate(this.existingUnit.getSerDeProps(), this.newUnit.getSerDeProps());
        }
        return (T)this;
    }

    public T compareAll() {
        ((HiveRegistrationUnitComparator)((HiveRegistrationUnitComparator)((HiveRegistrationUnitComparator)((HiveRegistrationUnitComparator)((HiveRegistrationUnitComparator)((HiveRegistrationUnitComparator)((HiveRegistrationUnitComparator)this.compareInputFormat()).compareOutputFormat()).compareIsCompressed()).compareIsStoredAsSubDirs()).compareNumBuckets()).compareBucketCols()).compareRawLocation()).compareParameters();
        return (T)this;
    }

    protected <E> void compare(Optional<E> existingValue, Optional<E> newValue) {
        boolean different = !newValue.isPresent() ? false : !existingValue.isPresent() || !existingValue.get().equals(newValue.get());
        this.result |= different;
    }

    protected void checkExistingIsSuperstate(State existingState, State newState) {
        this.checkExistingIsSuperset(existingState.getProperties().entrySet(), newState.getProperties().entrySet());
    }

    protected <E> void checkExistingIsSuperset(Set<E> existingSet, Set<E> newSet) {
        this.result |= !existingSet.containsAll(newSet);
    }

    public boolean result() {
        boolean resultCopy = this.result;
        this.result = false;
        return resultCopy;
    }
}

